/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.jaxrs.BookServerResourceCreatedSpringProviders;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerResourceCreatedSpringProviderTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceCreatedSpringProviderTest.launchServer(BookServerResourceCreatedSpringProviders.class));
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        connect.addRequestProperty("Content-Language", "badger-fish-language");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123badgerfish.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"BadgerFish output not correct", (Object)this.getStringFromInputStream(expected).trim(), (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetBookNotFound() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/books/12345";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book_notfound_mapped.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)this.getStringFromInputStream(expected).trim(), (Object)this.getStringFromInputStream(in).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/petstore/pets";
        URL url = new URL(endpointAddress);
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDefaultUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Accept", "text/xml");
        httpUrlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        httpUrlConnection.setRequestProperty("Connection", "close");
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        File inputFile = new File(((Object)((Object)this)).getClass().getResource("resources/singleValPostBody.txt").toURI());
        byte[] tmp = new byte[4096];
        int i = 0;
        FileInputStream is = new FileInputStream(inputFile);
        try {
            while ((i = ((InputStream)is).read(tmp)) >= 0) {
                outputstream.write(tmp, 0, i);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        outputstream.flush();
        int responseCode = httpUrlConnection.getResponseCode();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)200, (Object)responseCode);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Wrong status returned", (Object)"open", (Object)this.getStringFromInputStream(httpUrlConnection.getInputStream()));
        httpUrlConnection.disconnect();
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

