/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.jaxrs.BookServerSpring;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerSpringBookTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerSpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerSpringBookTest.launchServer(BookServerSpring.class));
    }

    @Test
    public void testGetBookByUriInfo() throws Exception {
        String endpointAddress = "http://localhost:9080/the/thebooks/bookstore/bookinfo?param1=12&param2=3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBookByUriInfo2() throws Exception {
        String endpointAddress = "http://localhost:9080/the/thebooks3/bookstore/bookinfo?param1=12&param2=3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore/books/123";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt", "application/jettison");
    }

    @Test
    public void testGetBookAsArray() throws Exception {
        URL url = new URL("http://localhost:9080/the/bookstore/books/list/123");
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        JAXRSClientServerSpringBookTest.assertEquals((Object)"{\"Books\":{\"books\":[{\"id\":123,\"name\":\"CXF in Action\"}]}}", (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBookWithEncodedQueryValue() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore/booksquery?id=12%2B3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetBookWithEncodedPathValue() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore/id=12%2B3";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    @Test
    public void testGetDefaultBook() throws Exception {
        String endpointAddress = "http://localhost:9080/the/bookstore";
        this.getBook(endpointAddress, "resources/expected_get_book123json.txt");
    }

    private void getBook(String endpointAddress, String resource) throws Exception {
        this.getBook(endpointAddress, resource, "application/json");
    }

    private void getBook(String endpointAddress, String resource, String type) throws Exception {
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", type);
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        JAXRSClientServerSpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testAddInvalidXmlBook() throws Exception {
        this.doPost("http://localhost:9080/the/bookstore/books/convert", 500, "application/xml", "resources/add_book.txt", null);
        this.doPost("http://localhost:9080/the/thebooks/bookstore/books/convert", 500, "application/xml", "resources/add_book.txt", null);
    }

    @Test
    public void testAddInvalidJsonBook() throws Exception {
        this.doPost("http://localhost:9080/the/bookstore/books/convert", 500, "application/json", "resources/add_book2json_invalid.txt", null);
        this.doPost("http://localhost:9080/the/thebooks/bookstore/books/convert", 500, "application/json", "resources/add_book2json_invalid.txt", null);
    }

    @Test
    public void testAddValidXmlBook() throws Exception {
        this.doPost("http://localhost:9080/the/bookstore/books/convert", 200, "application/xml", "resources/add_book2.txt", "resources/expected_get_book123.txt");
        this.doPost("http://localhost:9080/the/thebooks/bookstore/books/convert", 200, "application/xml", "resources/add_book2.txt", "resources/expected_get_book123.txt");
    }

    @Test
    public void testAddValidBookJson() throws Exception {
        this.doPost("http://localhost:9080/the/bookstore/books/convert", 200, "application/json", "resources/add_book2json.txt", "resources/expected_get_book123.txt");
        this.doPost("http://localhost:9080/the/thebooks/bookstore/books/convert", 200, "application/json", "resources/add_book2json.txt", "resources/expected_get_book123.txt");
        this.doPost("http://localhost:9080/the/thebooks/bookstore/books/convert", 200, "application/jettison", "resources/add_book2json.txt", "resources/expected_get_book123.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(String endpointAddress, int expectedStatus, String contentType, String inResource, String expectedResource) throws Exception {
        File input = new File(((Object)((Object)this)).getClass().getResource(inResource).toURI());
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", contentType);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerSpringBookTest.assertEquals((Object)expectedStatus, (Object)result);
            if (expectedStatus != 500) {
                InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream(expectedResource);
                JAXRSClientServerSpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
            } else {
                JAXRSClientServerSpringBookTest.assertTrue((boolean)post.getResponseBodyAsString().contains("Cannot find the declaration of element"));
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

