/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.jaxrs.MultipartServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSMultipartTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSMultipartTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSMultipartTest.launchServer(MultipartServer.class));
    }

    @Test
    public void testBookAsRootAttachmentStreamSource() throws Exception {
        String address = "http://localhost:9085/bookstore/books/stream";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsRootAttachmentStreamSourceNoContentId() throws Exception {
        String address = "http://localhost:9085/bookstore/books/stream";
        this.doAddBook(address, "attachmentData3", 200);
    }

    @Test
    public void testBookAsRootAttachmentInputStream() throws Exception {
        String address = "http://localhost:9085/bookstore/books/istream";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsMessageContextDataHandler() throws Exception {
        String address = "http://localhost:9085/bookstore/books/mchandlers";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsMessageContextAttachments() throws Exception {
        String address = "http://localhost:9085/bookstore/books/attachments";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testBookAsMessageContextAttachment() throws Exception {
        String address = "http://localhost:9085/bookstore/books/attachment";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsRootAttachmentJAXB() throws Exception {
        String address = "http://localhost:9085/bookstore/books/jaxb";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsDataSource() throws Exception {
        String address = "http://localhost:9085/bookstore/books/dsource";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsDataSource2() throws Exception {
        String address = "http://localhost:9085/bookstore/books/dsource2";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsBody() throws Exception {
        String address = "http://localhost:9085/bookstore/books/body";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookFormData() throws Exception {
        String address = "http://localhost:9085/bookstore/books/form";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookFormBody() throws Exception {
        String address = "http://localhost:9085/bookstore/books/formbody";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookFormBody2() throws Exception {
        String address = "http://localhost:9085/bookstore/books/formbody2";
        this.doAddBook("multipart/form-data", address, "attachmentForm", 200);
    }

    @Test
    public void testAddBookAsJAXB2() throws Exception {
        String address = "http://localhost:9085/bookstore/books/jaxb2";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsListOfAttachments() throws Exception {
        String address = "http://localhost:9085/bookstore/books/listattachments";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsListOfStreams() throws Exception {
        String address = "http://localhost:9085/bookstore/books/lististreams";
        this.doAddBook(address, "attachmentData", 200);
    }

    @Test
    public void testAddBookAsJAXBJSON() throws Exception {
        String address = "http://localhost:9085/bookstore/books/jaxbjson";
        this.doAddBook(address, "attachmentData2", 200);
    }

    @Test
    public void testAddBookAsJAXBJSONMixed() throws Exception {
        String address = "http://localhost:9085/bookstore/books/jaxbjson";
        this.doAddBook("multipart/mixed", address, "attachmentData2", 200);
    }

    @Test
    public void testConsumesMismatch() throws Exception {
        String address = "http://localhost:9085/bookstore/books/mismatch1";
        this.doAddBook(address, "attachmentData2", 415);
    }

    @Test
    public void testConsumesMismatch2() throws Exception {
        String address = "http://localhost:9085/bookstore/books/mismatch2";
        this.doAddBook(address, "attachmentData2", 415);
    }

    @Test
    public void testAddBookAsDataHandler() throws Exception {
        String address = "http://localhost:9085/bookstore/books/dhandler";
        this.doAddBook(address, "attachmentData", 200);
    }

    private void doAddBook(String address, String resourceName, int status) throws Exception {
        this.doAddBook("multipart/related", address, resourceName, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddBook(String type, String address, String resourceName, int status) throws Exception {
        PostMethod post = new PostMethod(address);
        String ct = type + "; type=\"text/xml\"; " + "start=\"rootPart\"; " + "boundary=\"----=_Part_4_701508.1145579811786\"";
        post.setRequestHeader("Content-Type", ct);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/" + resourceName);
        InputStreamRequestEntity entity = new InputStreamRequestEntity(is);
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSMultipartTest.assertEquals((Object)status, (Object)result);
            if (status == 200) {
                InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
                JAXRSMultipartTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

