/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServerRestSoap;
import org.apache.cxf.systest.jaxrs.BookSoapService;
import org.apache.cxf.systest.jaxrs.BookStoreJaxrsJaxws;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSSoapBookTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSSoapBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSSoapBookTest.launchServer(BookServerRestSoap.class));
    }

    @Test
    public void testGetAll() throws Exception {
        InputStream in = this.getRestInputStream("http://localhost:9092/test/services/rest2/myRestService");
        JAXRSSoapBookTest.assertEquals((Object)"0", (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBook123() throws Exception {
        InputStream in = this.getRestInputStream("http://localhost:9092/test/services/rest/bookstore/123");
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSSoapBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGetBookRest() throws Exception {
        String endpointAddress = "http://localhost:9092/test/services/rest/bookstore/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/add_book.txt").toURI());
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", "application/xml");
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSSoapBookTest.assertEquals((Object)200, (Object)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
            JAXRSSoapBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testGetBookSoap() throws Exception {
        String wsdlAddress = "http://localhost:9092/test/services/soap/bookservice?wsdl";
        URL wsdlUrl = new URL(wsdlAddress);
        BookSoapService service = new BookSoapService(wsdlUrl, new QName("http://books.com", "BookService"));
        BookStoreJaxrsJaxws store = service.getBookPort();
        Book book = store.getBook(new Long(123L));
        JAXRSSoapBookTest.assertEquals((String)"id is wrong", (Object)book.getId(), (Object)123);
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    private InputStream getRestInputStream(String endpointAddress) throws Exception {
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml,text/plain");
        return connect.getInputStream();
    }
}

