/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.any.Greeter;
import org.apache.hello_world_soap_http.any.SOAPService;
import org.apache.hello_world_soap_http.any_types.GreeterImpl;
import org.apache.hello_world_soap_http.any_types.SayHi;
import org.apache.hello_world_soap_http.any_types.SayHi1;
import org.junit.BeforeClass;
import org.junit.Test;

public final class AnyClientServerTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(AnyClientServerTest.class);
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http/any", "SOAPService");

    @BeforeClass
    public static void startServers() throws Exception {
        AnyClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)AnyClientServerTest.launchServer(MyServer.class));
    }

    @Test
    public void testAny() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/any.wsdl");
        AnyClientServerTest.assertNotNull((Object)wsdl);
        SOAPService ss = new SOAPService(wsdl, this.serviceName);
        Greeter port = ss.getSoapPort();
        ArrayList<SayHi.Port> any = new ArrayList<SayHi.Port>();
        SayHi.Port anyPort = new SayHi.Port();
        SayHi.Port anyPort1 = new SayHi.Port();
        JAXBElement ele1 = new JAXBElement(new QName("http://apache.org/hello_world_soap_http/other", "port"), String.class, (Object)"hello");
        anyPort.setAny((Object)ele1);
        JAXBElement ele2 = new JAXBElement(new QName("http://apache.org/hello_world_soap_http/other", "port"), String.class, (Object)"Bon");
        anyPort1.setAny((Object)ele2);
        any.add(anyPort);
        any.add(anyPort1);
        String rep = port.sayHi(any);
        AnyClientServerTest.assertEquals((Object)rep, (Object)"helloBon");
    }

    @Test
    public void testList() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/any.wsdl");
        AnyClientServerTest.assertNotNull((Object)wsdl);
        SOAPService ss = new SOAPService(wsdl, this.serviceName);
        Greeter port = ss.getSoapPort();
        ArrayList<SayHi1.Port> list = new ArrayList<SayHi1.Port>();
        SayHi1.Port port1 = new SayHi1.Port();
        port1.setRequestType("hello");
        SayHi1.Port port2 = new SayHi1.Port();
        port2.setRequestType("Bon");
        list.add(port1);
        list.add(port2);
        String rep = port.sayHi1(list);
        AnyClientServerTest.assertEquals((Object)rep, (Object)"helloBon");
    }

    public static class MyServer
    extends AbstractBusTestServerBase {
        protected void run() {
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9000/SoapContext/SoapPort";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                MyServer s = new MyServer();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                LOG.info("done!");
            }
        }
    }
}

