/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.util.HashMap;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.systest.jaxws.ServerGreeterNoWsdl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientServerGreeterNoWsdlTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerGreeterNoWsdlTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerGreeterNoWsdlTest.launchServer(ServerGreeterNoWsdl.class, (boolean)true));
    }

    @Test
    public void testInvocation() throws Exception {
        GreeterService service = new GreeterService();
        ClientServerGreeterNoWsdlTest.assertNotNull((Object)service);
        try {
            Greeter greeter = service.getGreeterPort();
            String greeting = greeter.greetMe("Bonjour");
            ClientServerGreeterNoWsdlTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerGreeterNoWsdlTest.assertEquals((Object)"Hello Bonjour", (Object)greeting);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testGetGreetMe() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9020/SoapContext/GreeterPort/greetMe/requestType/cxf");
        httpConnection.connect();
        ClientServerGreeterNoWsdlTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerGreeterNoWsdlTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)httpConnection.getContentType());
        ClientServerGreeterNoWsdlTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerGreeterNoWsdlTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerGreeterNoWsdlTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        ns.put("ns2", "http://cxf.apache.org/greeter_control/types");
        XPathUtils xu = new XPathUtils(ns);
        Node body = (Node)xu.getValue("/soap:Envelope/soap:Body", (Node)doc, XPathConstants.NODE);
        ClientServerGreeterNoWsdlTest.assertNotNull((Object)body);
        String response = (String)xu.getValue("//ns2:greetMeResponse/ns2:responseType/text()", body, XPathConstants.STRING);
        ClientServerGreeterNoWsdlTest.assertEquals((Object)"Hello cxf", (Object)response);
    }
}

