/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.anonymous_complex_type.AnonymousComplexType;
import org.apache.cxf.anonymous_complex_type.AnonymousComplexTypeService;
import org.apache.cxf.anonymous_complex_type.RefSplitName;
import org.apache.cxf.anonymous_complex_type.RefSplitNameResponse;
import org.apache.cxf.anonymous_complex_type.SplitName;
import org.apache.cxf.anonymous_complex_type.SplitNameResponse;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.jaxb_element_test.JaxbElementTest;
import org.apache.cxf.jaxb_element_test.JaxbElementTest_Service;
import org.apache.cxf.ordered_param_holder.ComplexStruct;
import org.apache.cxf.ordered_param_holder.OrderedParamHolder;
import org.apache.cxf.ordered_param_holder.OrderedParamHolder_Service;
import org.apache.cxf.systest.jaxws.ComplexException;
import org.apache.cxf.systest.jaxws.CustomException;
import org.apache.cxf.systest.jaxws.DocLitBareCodeFirstService;
import org.apache.cxf.systest.jaxws.DocLitWrappedCodeFirstBaseService;
import org.apache.cxf.systest.jaxws.DocLitWrappedCodeFirstService;
import org.apache.cxf.systest.jaxws.DocLitWrappedCodeFirstServiceImpl;
import org.apache.cxf.systest.jaxws.DocLitWrappedCodeFirstServiceMissingOps;
import org.apache.cxf.systest.jaxws.RpcLitCodeFirstService;
import org.apache.cxf.systest.jaxws.RpcLitCodeFirstServiceImpl;
import org.apache.cxf.systest.jaxws.ServerMisc;
import org.apache.cxf.systest.jaxws.ServiceTestFault;
import org.apache.cxf.tests.inherit.Inherit;
import org.apache.cxf.tests.inherit.InheritService;
import org.apache.cxf.tests.inherit.objects.SubTypeA;
import org.apache.cxf.tests.inherit.objects.SubTypeB;
import org.apache.cxf.tests.inherit.types.ObjectInfo;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientServerMiscTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerMiscTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerMiscTest.launchServer(ServerMisc.class));
    }

    @Test
    public void testDocLitBare() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/DocLitBareCodeFirstService", "DocLitBareCodeFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/DocLitBareCodeFirstService", "DocLitBareCodeFirstService");
        Service service = Service.create((QName)servName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", "http://localhost:9003/DocLitBareCodeFirstService/");
        DocLitBareCodeFirstService port = (DocLitBareCodeFirstService)service.getPort(portName, DocLitBareCodeFirstService.class);
        DocLitBareCodeFirstService.GreetMeRequest req = new DocLitBareCodeFirstService.GreetMeRequest();
        req.setName("Foo");
        DocLitBareCodeFirstService.GreetMeResponse resp = port.greetMe(req);
        ClientServerMiscTest.assertEquals((Object)req.getName(), (Object)resp.getName());
        service = Service.create((URL)new URL("http://localhost:9003/DocLitBareCodeFirstService/?wsdl"), (QName)servName);
        port = (DocLitBareCodeFirstService)service.getPort(portName, DocLitBareCodeFirstService.class);
        resp = port.greetMe(req);
        ClientServerMiscTest.assertEquals((Object)req.getName(), (Object)resp.getName());
        req.setName("fault");
        try {
            resp = port.greetMe(req);
            ClientServerMiscTest.fail((String)"did not get fault back");
        }
        catch (SOAPFaultException ex) {
            ClientServerMiscTest.assertEquals((Object)"mr.actor", (Object)ex.getFault().getFaultActor());
            ClientServerMiscTest.assertEquals((Object)"test", (Object)ex.getFault().getDetail().getFirstChild().getLocalName());
        }
    }

    @Test
    public void testAnonymousComplexType() throws Exception {
        AnonymousComplexTypeService actService = new AnonymousComplexTypeService();
        ClientServerMiscTest.assertNotNull((Object)actService);
        QName portName = new QName("http://cxf.apache.org/anonymous_complex_type/", "anonymous_complex_typeSOAP");
        AnonymousComplexType act = (AnonymousComplexType)actService.getPort(portName, AnonymousComplexType.class);
        try {
            SplitNameResponse.Names reply = act.splitName("Tom Li");
            ClientServerMiscTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerMiscTest.assertEquals((Object)"Tom", (Object)reply.getFirst());
            ClientServerMiscTest.assertEquals((Object)"Li", (Object)reply.getSecond());
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testRefAnonymousComplexType() throws Exception {
        AnonymousComplexTypeService actService = new AnonymousComplexTypeService();
        ClientServerMiscTest.assertNotNull((Object)actService);
        QName portName = new QName("http://cxf.apache.org/anonymous_complex_type/", "anonymous_complex_typeSOAP");
        AnonymousComplexType act = (AnonymousComplexType)actService.getPort(portName, AnonymousComplexType.class);
        try {
            SplitName name = new SplitName();
            name.setName("Tom Li");
            RefSplitName refName = new RefSplitName();
            refName.setSplitName(name);
            RefSplitNameResponse reply = act.refSplitName(refName);
            ClientServerMiscTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerMiscTest.assertEquals((Object)"Tom", (Object)reply.getSplitNameResponse().getNames().getFirst());
            ClientServerMiscTest.assertEquals((Object)"Li", (Object)reply.getSplitNameResponse().getNames().getSecond());
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testMinOccursAndNillableJAXBElement() throws Exception {
        JaxbElementTest_Service service = new JaxbElementTest_Service();
        ClientServerMiscTest.assertNotNull((Object)service);
        JaxbElementTest port = (JaxbElementTest)service.getPort(JaxbElementTest.class);
        try {
            String response = port.newOperation("hello");
            ClientServerMiscTest.assertNotNull((Object)response);
            ClientServerMiscTest.assertEquals((Object)"in=hello", (Object)response);
            response = port.newOperation(null);
            ClientServerMiscTest.assertNotNull((Object)response);
            ClientServerMiscTest.assertEquals((Object)"in=null", (Object)response);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testOrderedParamHolder() throws Exception {
        OrderedParamHolder_Service service = new OrderedParamHolder_Service();
        OrderedParamHolder port = service.getOrderedParamHolderSOAP();
        try {
            Holder part3 = new Holder();
            part3.value = new ComplexStruct();
            ((ComplexStruct)part3.value).setElem1("elem1");
            ((ComplexStruct)part3.value).setElem2("elem2");
            ((ComplexStruct)part3.value).setElem3(0);
            Holder part2 = new Holder();
            part2.value = 0;
            Holder part1 = new Holder();
            part1.value = "part1";
            port.orderedParamHolder(part3, part2, part1);
            ClientServerMiscTest.assertNotNull((Object)part3.value);
            ClientServerMiscTest.assertEquals((String)"check value", (Object)"return elem1", (Object)((ComplexStruct)part3.value).getElem1());
            ClientServerMiscTest.assertEquals((String)"check value", (Object)"return elem2", (Object)((ComplexStruct)part3.value).getElem2());
            ClientServerMiscTest.assertEquals((String)"check value", (Object)1, (Object)((ComplexStruct)part3.value).getElem3());
            ClientServerMiscTest.assertNotNull((Object)part2.value);
            ClientServerMiscTest.assertEquals((String)"check value", (Object)1, (Object)((Integer)part2.value));
            ClientServerMiscTest.assertNotNull((Object)part1.value);
            ClientServerMiscTest.assertEquals((String)"check value", (Object)"return part1", (Object)part1.value);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testMissingMethods() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstService");
        Service service = Service.create((URL)new URL("http://localhost:9003/DocLitWrappedCodeFirstService/?wsdl"), (QName)servName);
        DocLitWrappedCodeFirstServiceMissingOps port = (DocLitWrappedCodeFirstServiceMissingOps)service.getPort(portName, DocLitWrappedCodeFirstServiceMissingOps.class);
        int[] ret = port.echoIntArray(new int[]{1, 2});
        ClientServerMiscTest.assertNotNull((Object)ret);
    }

    @Test
    public void testStringListOutDocLitNoWsdl() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstService");
        Service service = Service.create((QName)servName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", "http://localhost:9003/DocLitWrappedCodeFirstService/");
        DocLitWrappedCodeFirstService port = (DocLitWrappedCodeFirstService)service.getPort(portName, DocLitWrappedCodeFirstService.class);
        this.runDocLitTest(port);
    }

    @Test
    public void testStringListOutDocLitWsdl() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstService");
        Service service = Service.create((URL)new URL("http://localhost:9003/DocLitWrappedCodeFirstService/?wsdl"), (QName)servName);
        DocLitWrappedCodeFirstService port = (DocLitWrappedCodeFirstService)service.getPort(portName, DocLitWrappedCodeFirstService.class);
        this.runDocLitTest(port);
    }

    @Test
    public void testSimpleClientWithWsdl() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService", "DocLitWrappedCodeFirstService");
        ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
        factory.setWsdlURL("http://localhost:9003/DocLitWrappedCodeFirstService/?wsdl");
        factory.setServiceName(servName);
        factory.setServiceClass(DocLitWrappedCodeFirstService.class);
        factory.setEndpointName(portName);
        DocLitWrappedCodeFirstService port = (DocLitWrappedCodeFirstService)factory.create();
        ClientServerMiscTest.assertNotNull((Object)port);
        String echoMsg = port.echo("Hello");
        ClientServerMiscTest.assertEquals((Object)"Hello", (Object)echoMsg);
    }

    private void runDocLitTest(DocLitWrappedCodeFirstService port) throws Exception {
        long start = System.currentTimeMillis();
        port.doOneWay();
        ClientServerMiscTest.assertTrue((System.currentTimeMillis() - start < 500L ? 1 : 0) != 0);
        Set<DocLitWrappedCodeFirstService.Foo> fooSet = port.getFooSet();
        ClientServerMiscTest.assertEquals((Object)2, (Object)fooSet.size());
        ClientServerMiscTest.assertEquals((Object)24, (Object)port.echoIntDifferentWrapperName(24));
        String echoMsg = port.echo("Hello");
        ClientServerMiscTest.assertEquals((Object)"Hello", (Object)echoMsg);
        ArrayList<String> rev = new ArrayList<String>(Arrays.asList(DocLitWrappedCodeFirstServiceImpl.DATA));
        Collections.reverse(rev);
        String[] arrayOut = port.arrayOutput();
        ClientServerMiscTest.assertNotNull((Object)arrayOut);
        ClientServerMiscTest.assertEquals((Object)3, (Object)arrayOut.length);
        for (int x = 0; x < 3; ++x) {
            ClientServerMiscTest.assertEquals((Object)DocLitWrappedCodeFirstServiceImpl.DATA[x], (Object)arrayOut[x]);
        }
        Vector<String> listOut = port.listOutput();
        ClientServerMiscTest.assertNotNull(listOut);
        ClientServerMiscTest.assertEquals((Object)3, (Object)listOut.size());
        for (int x = 0; x < 3; ++x) {
            ClientServerMiscTest.assertEquals((Object)DocLitWrappedCodeFirstServiceImpl.DATA[x], listOut.get(x));
        }
        String s = port.arrayInput(DocLitWrappedCodeFirstServiceImpl.DATA);
        ClientServerMiscTest.assertEquals((Object)"string1string2string3", (Object)s);
        s = port.listInput(Arrays.asList(DocLitWrappedCodeFirstServiceImpl.DATA));
        ClientServerMiscTest.assertEquals((Object)"string1string2string3", (Object)s);
        s = port.multiListInput(Arrays.asList(DocLitWrappedCodeFirstServiceImpl.DATA), rev, "Hello", 24);
        ClientServerMiscTest.assertEquals((Object)"string1string2string3string3string2string1Hello24", (Object)s);
        s = port.listInput(new ArrayList<String>());
        ClientServerMiscTest.assertEquals((Object)"", (Object)s);
        s = port.listInput(null);
        ClientServerMiscTest.assertEquals((Object)"", (Object)s);
        s = port.multiListInput(Arrays.asList(DocLitWrappedCodeFirstServiceImpl.DATA), rev, null, 24);
        ClientServerMiscTest.assertEquals((Object)"string1string2string3string3string2string1<null>24", (Object)s);
        Holder a = new Holder();
        Holder b = new Holder((Object)"Hello");
        Holder c = new Holder();
        Holder d = new Holder((Object)" ");
        Holder e = new Holder((Object)"world!");
        Holder f = new Holder();
        Holder g = new Holder();
        s = port.multiInOut((Holder<String>)a, (Holder<String>)b, (Holder<String>)c, (Holder<String>)d, (Holder<String>)e, (Holder<String>)f, (Holder<String>)g);
        ClientServerMiscTest.assertEquals((Object)"Hello world!", (Object)s);
        ClientServerMiscTest.assertEquals((Object)"a", (Object)a.value);
        ClientServerMiscTest.assertEquals((Object)"b", (Object)b.value);
        ClientServerMiscTest.assertEquals((Object)"c", (Object)c.value);
        ClientServerMiscTest.assertEquals((Object)"d", (Object)d.value);
        ClientServerMiscTest.assertEquals((Object)"e", (Object)e.value);
        ClientServerMiscTest.assertEquals((Object)"f", (Object)f.value);
        ClientServerMiscTest.assertEquals((Object)"g", (Object)g.value);
        List<DocLitWrappedCodeFirstService.Foo> foos = port.listObjectOutput();
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos.size());
        ClientServerMiscTest.assertEquals((Object)"a", (Object)foos.get(0).getName());
        ClientServerMiscTest.assertEquals((Object)"b", (Object)foos.get(1).getName());
        List<DocLitWrappedCodeFirstService.Foo[]> foos2 = port.listObjectArrayOutput();
        ClientServerMiscTest.assertNotNull(foos2);
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos2.size());
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos2.get(0).length);
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos2.get(1).length);
        int[] ints = port.echoIntArray(new int[]{1, 2, 3}, null);
        ClientServerMiscTest.assertEquals((Object)3, (Object)ints.length);
        ClientServerMiscTest.assertEquals((Object)1, (Object)ints[0]);
        ClientServerMiscTest.assertEquals((Object)"Val", (Object)port.createBar("Val").getName());
        this.testExceptionCases(port);
    }

    private void testExceptionCases(DocLitWrappedCodeFirstService port) throws Exception {
        try {
            port.throwException(10);
            ClientServerMiscTest.fail((String)"Expected exception not found");
        }
        catch (ServiceTestFault ex) {
            ClientServerMiscTest.assertEquals((Object)10L, (Object)ex.getFaultInfo().getId());
        }
        try {
            port.throwException(-1);
            ClientServerMiscTest.fail((String)"Expected exception not found");
        }
        catch (ServiceTestFault ex) {
            ClientServerMiscTest.assertNull((Object)ex.getFaultInfo());
        }
        try {
            port.throwException(-2);
            ClientServerMiscTest.fail((String)"Expected exception not found");
        }
        catch (CustomException ex) {
            ClientServerMiscTest.assertEquals((Object)"CE: -2", (Object)ex.getMessage());
            ClientServerMiscTest.assertEquals((Object)"A Value", (Object)ex.getA());
            ClientServerMiscTest.assertEquals((Object)"B Value", (Object)ex.getB());
        }
        try {
            port.throwException(-3);
            ClientServerMiscTest.fail((String)"Expected exception not found");
        }
        catch (ComplexException ex) {
            ClientServerMiscTest.assertEquals((Object)"Throw user fault -3", (Object)ex.getMessage());
            ClientServerMiscTest.assertEquals((Object)3, (Object)ex.getInts().length);
        }
        try {
            port.throwException(-3);
            ClientServerMiscTest.fail((String)"Expected exception not found");
        }
        catch (ComplexException ex) {
            ClientServerMiscTest.assertEquals((Object)"Throw user fault -3", (Object)ex.getMessage());
        }
    }

    @Test
    public void testRpcLitNoWsdl() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/RpcLitCodeFirstService", "RpcLitCodimlpementor6eFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/RpcLitCodeFirstService", "RpcLitCodeFirstService");
        Service service = Service.create((QName)servName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", "http://localhost:9003/RpcLitCodeFirstService/");
        RpcLitCodeFirstService port = (RpcLitCodeFirstService)service.getPort(portName, RpcLitCodeFirstService.class);
        this.runRpcLitTest(port);
    }

    @Test
    public void testRpcLitWsdl() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/RpcLitCodeFirstService", "RpcLitCodeFirstServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/RpcLitCodeFirstService", "RpcLitCodeFirstService");
        Service service = Service.create((URL)new URL("http://localhost:9003/RpcLitCodeFirstService/?wsdl"), (QName)servName);
        RpcLitCodeFirstService port = (RpcLitCodeFirstService)service.getPort(portName, RpcLitCodeFirstService.class);
        this.runRpcLitTest(port);
    }

    private void runRpcLitTest(RpcLitCodeFirstService port) throws Exception {
        String[] ret = port.convertToString(new int[]{1, 2, 3});
        ClientServerMiscTest.assertEquals((Object)3, (Object)ret.length);
        ArrayList<String> rev = new ArrayList<String>(Arrays.asList(RpcLitCodeFirstServiceImpl.DATA));
        Collections.reverse(rev);
        String[] arrayOut = port.arrayOutput();
        ClientServerMiscTest.assertNotNull((Object)arrayOut);
        ClientServerMiscTest.assertEquals((Object)3, (Object)arrayOut.length);
        for (int x = 0; x < 3; ++x) {
            ClientServerMiscTest.assertEquals((Object)RpcLitCodeFirstServiceImpl.DATA[x], (Object)arrayOut[x]);
        }
        Vector<String> listOut = port.listOutput();
        ClientServerMiscTest.assertNotNull(listOut);
        ClientServerMiscTest.assertEquals((Object)3, (Object)listOut.size());
        for (int x = 0; x < 3; ++x) {
            ClientServerMiscTest.assertEquals((Object)RpcLitCodeFirstServiceImpl.DATA[x], listOut.get(x));
        }
        String s = port.arrayInput(RpcLitCodeFirstServiceImpl.DATA);
        ClientServerMiscTest.assertEquals((Object)"string1string2string3", (Object)s);
        s = port.listInput(Arrays.asList(RpcLitCodeFirstServiceImpl.DATA));
        ClientServerMiscTest.assertEquals((Object)"string1string2string3", (Object)s);
        s = port.multiListInput(Arrays.asList(RpcLitCodeFirstServiceImpl.DATA), rev, "Hello", 24);
        ClientServerMiscTest.assertEquals((Object)"string1string2string3string3string2string1Hello24", (Object)s);
        s = port.listInput(new ArrayList<String>());
        ClientServerMiscTest.assertEquals((Object)"", (Object)s);
        try {
            s = port.listInput(null);
            ClientServerMiscTest.fail((String)"RPC/Lit parts cannot be null");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        try {
            s = port.multiListInput(Arrays.asList(RpcLitCodeFirstServiceImpl.DATA), rev, null, 24);
            ClientServerMiscTest.fail((String)"RPC/Lit parts cannot be null");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        Holder a = new Holder();
        Holder b = new Holder((Object)"Hello");
        Holder c = new Holder();
        Holder d = new Holder((Object)" ");
        Holder e = new Holder((Object)"world!");
        Holder f = new Holder();
        Holder g = new Holder();
        s = port.multiInOut((Holder<String>)a, (Holder<String>)b, (Holder<String>)c, (Holder<String>)d, (Holder<String>)e, (Holder<String>)f, (Holder<String>)g);
        ClientServerMiscTest.assertEquals((Object)"Hello world!", (Object)s);
        ClientServerMiscTest.assertEquals((Object)"a", (Object)a.value);
        ClientServerMiscTest.assertEquals((Object)"b", (Object)b.value);
        ClientServerMiscTest.assertEquals((Object)"c", (Object)c.value);
        ClientServerMiscTest.assertEquals((Object)"d", (Object)d.value);
        ClientServerMiscTest.assertEquals((Object)"e", (Object)e.value);
        ClientServerMiscTest.assertEquals((Object)"f", (Object)f.value);
        ClientServerMiscTest.assertEquals((Object)"g", (Object)g.value);
        a = new Holder();
        b = new Holder((Object)"Hello");
        c = new Holder();
        d = new Holder((Object)" ");
        e = new Holder((Object)"world!");
        f = new Holder();
        g = new Holder();
        s = port.multiHeaderInOut((Holder<String>)a, (Holder<String>)b, (Holder<String>)c, (Holder<String>)d, (Holder<String>)e, (Holder<String>)f, (Holder<String>)g);
        ClientServerMiscTest.assertEquals((Object)"Hello world!", (Object)s);
        ClientServerMiscTest.assertEquals((Object)"a", (Object)a.value);
        ClientServerMiscTest.assertEquals((Object)"b", (Object)b.value);
        ClientServerMiscTest.assertEquals((Object)"c", (Object)c.value);
        ClientServerMiscTest.assertEquals((Object)"d", (Object)d.value);
        ClientServerMiscTest.assertEquals((Object)"e", (Object)e.value);
        ClientServerMiscTest.assertEquals((Object)"f", (Object)f.value);
        ClientServerMiscTest.assertEquals((Object)"g", (Object)g.value);
        List<RpcLitCodeFirstService.Foo> foos = port.listObjectOutput();
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos.size());
        ClientServerMiscTest.assertEquals((Object)"a", (Object)foos.get(0).getName());
        ClientServerMiscTest.assertEquals((Object)"b", (Object)foos.get(1).getName());
        List<RpcLitCodeFirstService.Foo[]> foos2 = port.listObjectArrayOutput();
        ClientServerMiscTest.assertNotNull(foos2);
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos2.size());
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos2.get(0).length);
        ClientServerMiscTest.assertEquals((Object)2, (Object)foos2.get(1).length);
    }

    @Test
    public void testInheritedTypesInOtherPackage() throws Exception {
        InheritService serv = new InheritService();
        Inherit port = serv.getInheritPort();
        ObjectInfo obj = port.getObject(0);
        ClientServerMiscTest.assertNotNull((Object)obj);
        ClientServerMiscTest.assertNotNull((Object)obj.getBaseObject());
        ClientServerMiscTest.assertEquals((Object)"A", (Object)obj.getBaseObject().getName());
        ClientServerMiscTest.assertTrue((boolean)(obj.getBaseObject() instanceof SubTypeA));
        obj = port.getObject(1);
        ClientServerMiscTest.assertNotNull((Object)obj);
        ClientServerMiscTest.assertNotNull((Object)obj.getBaseObject());
        ClientServerMiscTest.assertEquals((Object)"B", (Object)obj.getBaseObject().getName());
        ClientServerMiscTest.assertTrue((boolean)(obj.getBaseObject() instanceof SubTypeB));
    }

    @Test
    public void testInterfaceExtension() throws Exception {
        QName portName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstBaseService", "DocLitWrappedCodeFirstBaseServicePort");
        QName servName = new QName("http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstBaseService", "DocLitWrappedCodeFirstBaseService");
        Service service = Service.create((QName)servName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", "http://localhost:9003/DocLitWrappedCodeFirstServiceBaseService/");
        DocLitWrappedCodeFirstBaseService port = (DocLitWrappedCodeFirstBaseService)service.getPort(portName, DocLitWrappedCodeFirstBaseService.class);
        ClientServerMiscTest.assertEquals((Object)1, (Object)port.operationInBase(1));
        ClientServerMiscTest.assertEquals((Object)2, (Object)port.operationInSub1(2));
        ClientServerMiscTest.assertEquals((Object)3, (Object)port.operationInSub2(3));
        service = Service.create((URL)new URL("http://localhost:9003/DocLitWrappedCodeFirstServiceBaseService/?wsdl"), (QName)servName);
        port = (DocLitWrappedCodeFirstBaseService)service.getPort(portName, DocLitWrappedCodeFirstBaseService.class);
        ClientServerMiscTest.assertEquals((Object)1, (Object)port.operationInBase(1));
        ClientServerMiscTest.assertEquals((Object)2, (Object)port.operationInSub1(2));
        ClientServerMiscTest.assertEquals((Object)3, (Object)port.operationInSub2(3));
    }

    @Test
    public void testAnonymousMinOccursConfig() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9003/DocLitWrappedCodeFirstServiceSettings/?wsdl");
        httpConnection.connect();
        ClientServerMiscTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerMiscTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerMiscTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerMiscTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        ns.put("tns", "http://cxf.apache.org/systest/jaxws/DocLitWrappedCodeFirstService");
        ns.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        ns.put("xs", "http://www.w3.org/2001/XMLSchema");
        XPathUtils xu = new XPathUtils(ns);
        Node ct = (Node)xu.getValue("//wsdl:definitions/wsdl:types/xs:schema/xs:element[@name='getFooSetResponse']/xs:complexType/xs:sequence", (Node)doc, XPathConstants.NODE);
        ClientServerMiscTest.assertNotNull((Object)ct);
        ct = (Node)xu.getValue("//wsdl:definitions/wsdl:types/xs:schema/xs:element[@name='multiInOut']/xs:complexType/xs:sequence/xs:element[@nillable='true']", (Node)doc, XPathConstants.NODE);
        ClientServerMiscTest.assertNotNull((Object)ct);
    }
}

