/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.systest.jaxws.ServerMixedStyle;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.hello_world_mixedstyle.Greeter;
import org.apache.hello_world_mixedstyle.PingMeFault;
import org.apache.hello_world_mixedstyle.SOAPService;
import org.apache.hello_world_mixedstyle.types.GreetMe1;
import org.apache.hello_world_mixedstyle.types.GreetMeResponse;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientServerMixedStyleTest
extends AbstractClientServerTestBase {
    private final QName portName = new QName("http://apache.org/hello_world_mixedstyle", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerMixedStyleTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerMixedStyleTest.launchServer(ServerMixedStyle.class));
    }

    @Test
    public void testMixedStyle() throws Exception {
        SOAPService service = new SOAPService();
        ClientServerMixedStyleTest.assertNotNull((Object)service);
        try {
            Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
            GreetMe1 request = new GreetMe1();
            request.setRequestType("Bonjour");
            GreetMeResponse greeting = greeter.greetMe(request);
            ClientServerMixedStyleTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerMixedStyleTest.assertEquals((Object)"Hello Bonjour", (Object)greeting.getResponseType());
            String reply = greeter.sayHi();
            ClientServerMixedStyleTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerMixedStyleTest.assertEquals((Object)"Bonjour", (Object)reply);
            try {
                greeter.pingMe();
                ClientServerMixedStyleTest.fail((String)"expected exception not caught");
            }
            catch (PingMeFault f) {}
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testCXF885() throws Exception {
        Service serv = Service.create((QName)new QName("http://example.com", "MixedTest"));
        ServerMixedStyle.MixedTest test = (ServerMixedStyle.MixedTest)serv.getPort(ServerMixedStyle.MixedTest.class);
        ((BindingProvider)test).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:9027/cxf885");
        String ret = test.hello("A", "B");
        ClientServerMixedStyleTest.assertEquals((Object)"Hello A and B", (Object)ret);
        String ret2 = test.simple("Dan");
        ClientServerMixedStyleTest.assertEquals((Object)"Hello Dan", (Object)ret2);
        String ret3 = test.tripple("A", "B", "C");
        ClientServerMixedStyleTest.assertEquals((Object)"Tripple: A B C", (Object)ret3);
        String ret4 = test.simple2(24);
        ClientServerMixedStyleTest.assertEquals((Object)"Int: 24", (Object)ret4);
        serv = Service.create((URL)new URL("http://localhost:9027/cxf885?wsdl"), (QName)new QName("http://example.com", "MixedTestImplService"));
        test = (ServerMixedStyle.MixedTest)serv.getPort(new QName("http://example.com", "MixedTestImplPort"), ServerMixedStyle.MixedTest.class);
        ret = test.hello("A", "B");
        ClientServerMixedStyleTest.assertEquals((Object)"Hello A and B", (Object)ret);
        ret2 = test.simple("Dan");
        ClientServerMixedStyleTest.assertEquals((Object)"Hello Dan", (Object)ret2);
        ret3 = test.tripple("A", "B", "C");
        ClientServerMixedStyleTest.assertEquals((Object)"Tripple: A B C", (Object)ret3);
        ret4 = test.simple2(24);
        ClientServerMixedStyleTest.assertEquals((Object)"Int: 24", (Object)ret4);
    }
}

