/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.hello_world_rpclit.GreeterRPCLit;
import org.apache.hello_world_rpclit.SOAPServiceRPCLit;
import org.apache.hello_world_rpclit.types.MyComplexStruct;
import org.apache.hello_world_soap_http.RPCLitGreeterImpl;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientServerRPCLitTest
extends AbstractClientServerTestBase {
    private final QName portName = new QName("http://apache.org/hello_world_rpclit", "SoapPortRPCLit");

    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerRPCLitTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerRPCLitTest.launchServer(Server.class));
    }

    @Test
    public void testBasicConnection() throws Exception {
        SOAPServiceRPCLit service = new SOAPServiceRPCLit();
        ClientServerRPCLitTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            GreeterRPCLit greeter = (GreeterRPCLit)service.getPort(this.portName, GreeterRPCLit.class);
            for (int idx = 0; idx < 1; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                ClientServerRPCLitTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                ClientServerRPCLitTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                ClientServerRPCLitTest.assertNotNull((String)"no response received from service", (Object)reply);
                ClientServerRPCLitTest.assertEquals((Object)response2, (Object)reply);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testComplexType() throws Exception {
        SOAPServiceRPCLit service = new SOAPServiceRPCLit();
        ClientServerRPCLitTest.assertNotNull((Object)service);
        GreeterRPCLit greeter = (GreeterRPCLit)service.getPort(this.portName, GreeterRPCLit.class);
        MyComplexStruct in = new MyComplexStruct();
        in.setElem1("elem1");
        in.setElem2("elem2");
        in.setElem3(45);
        try {
            MyComplexStruct out = greeter.sendReceiveData(in);
            ClientServerRPCLitTest.assertNotNull((String)"no response received from service", (Object)out);
            ClientServerRPCLitTest.assertEquals((Object)in.getElem1(), (Object)out.getElem1());
            ClientServerRPCLitTest.assertEquals((Object)in.getElem2(), (Object)out.getElem2());
            ClientServerRPCLitTest.assertEquals((Object)in.getElem3(), (Object)out.getElem3());
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            RPCLitGreeterImpl implementor = new RPCLitGreeterImpl();
            String address = "http://localhost:9002/SOAPServiceRPCLit/SoapPort";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

