/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.systest.jaxws.DocLitWrappedCodeFirstService;
import org.apache.cxf.systest.jaxws.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.DocLitBare;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.SOAPService;
import org.apache.hello_world_soap_http.SOAPServiceBogusAddressTest;
import org.apache.hello_world_soap_http.SOAPServiceDocLitBare;
import org.apache.hello_world_soap_http.SOAPServiceMultiPortTypeTest;
import org.apache.hello_world_soap_http.types.BareDocumentResponse;
import org.apache.hello_world_soap_http.types.GreetMeLaterResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientServerTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(ClientServerTest.class);
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");
    private final QName fakePortName = new QName("http://apache.org/hello_world_soap_http", "FakePort");
    private final QName portName1 = new QName("http://apache.org/hello_world_soap_http", "SoapPort2");

    @BeforeClass
    public static void startServers() throws Exception {
        URL url = ClientServerTest.class.getResource("fault-stack-trace.xml");
        ClientServerTest.assertNotNull((String)"cannot find test resource", (Object)url);
        defaultConfigFileName = url.toString();
        ClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testBase64() throws URISyntaxException {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/others/dynamic_client_base64.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        String wsdlUrl = null;
        wsdlUrl = wsdl.toURI().toString();
        CXFBusFactory busFactory = new CXFBusFactory();
        Bus bus = busFactory.createBus();
        DynamicClientFactory dynamicClientFactory = DynamicClientFactory.newInstance((Bus)bus);
        Client client = dynamicClientFactory.createClient(wsdlUrl);
        ClientServerTest.assertNotNull((Object)client);
    }

    @Test
    public void testJaxWsDynamicClient() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/others/dynamic_client_base64.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        String wsdlUrl = null;
        wsdlUrl = wsdl.toURI().toString();
        CXFBusFactory busFactory = new CXFBusFactory();
        Bus bus = busFactory.createBus();
        JaxWsDynamicClientFactory dynamicClientFactory = JaxWsDynamicClientFactory.newInstance((Bus)bus);
        Client client = dynamicClientFactory.createClient(wsdlUrl);
        ClientServerTest.assertNotNull((Object)client);
    }

    @Test
    public void testBasicConnection() throws Exception {
        SOAPService service = new SOAPService();
        ClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        try {
            greeter.greetMe("test");
            String reply = greeter.sayHi();
            ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerTest.assertEquals((Object)"Bonjour", (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        BindingProvider bp = (BindingProvider)greeter;
        Map responseContext = bp.getResponseContext();
        Integer responseCode = (Integer)responseContext.get(Message.RESPONSE_CODE);
        ClientServerTest.assertEquals((Object)200, (Object)responseCode);
    }

    @Test
    public void testNillable() throws Exception {
        SOAPService service = new SOAPService();
        ClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        try {
            String reply = greeter.testNillable("test", 100);
            ClientServerTest.assertEquals((Object)"test", (Object)reply);
            reply = greeter.testNillable(null, 100);
            ClientServerTest.assertNull((Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testAddPortWithSpecifiedSoap12Binding() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.fakePortName, "http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://localhost:9009/SoapContext/SoapPort");
        Greeter greeter = (Greeter)service.getPort(this.fakePortName, Greeter.class);
        String response = new String("Bonjour");
        try {
            greeter.greetMe("test");
            String reply = greeter.sayHi();
            ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerTest.assertEquals((Object)response, (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testAddPortWithSpecifiedSoap11Binding() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.fakePortName, "http://schemas.xmlsoap.org/wsdl/soap/http", "http://localhost:9000/SoapContext/SoapPort");
        Greeter greeter = (Greeter)service.getPort(this.fakePortName, Greeter.class);
        String response = new String("Bonjour");
        try {
            greeter.greetMe("test");
            String reply = greeter.sayHi();
            ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerTest.assertEquals((Object)response, (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testAddPort() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.fakePortName, "http://schemas.xmlsoap.org/soap/", "http://localhost:9000/SoapContext/SoapPort");
        Greeter greeter = (Greeter)service.getPort(this.fakePortName, Greeter.class);
        String response = new String("Bonjour");
        try {
            greeter.greetMe("test");
            String reply = greeter.sayHi();
            ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerTest.assertEquals((Object)response, (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testGetPortOneParam() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        Service service = Service.create((URL)url, (QName)this.serviceName);
        Greeter greeter = (Greeter)service.getPort(Greeter.class);
        String response = new String("Bonjour");
        try {
            greeter.greetMe("test");
            String reply = greeter.sayHi();
            ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
            ClientServerTest.assertEquals((Object)response, (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testDocLitBareConnection() throws Exception {
        SOAPServiceDocLitBare service = new SOAPServiceDocLitBare();
        ClientServerTest.assertNotNull((Object)service);
        DocLitBare greeter = (DocLitBare)service.getPort(this.portName1, DocLitBare.class);
        try {
            BareDocumentResponse bareres = greeter.testDocLitBare("MySimpleDocument");
            ClientServerTest.assertNotNull((String)"no response for operation testDocLitBare", (Object)bareres);
            ClientServerTest.assertEquals((Object)"CXF", (Object)bareres.getCompany());
            ClientServerTest.assertTrue((bareres.getId() == 1 ? 1 : 0) != 0);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testBasicConnectionAndOneway() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            for (int idx = 0; idx < 1; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                ClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                ClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                ClientServerTest.assertEquals((Object)response2, (Object)reply);
                greeter.greetMeOneWay("Milestone-" + idx);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testBasicConnection2() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(Greeter.class);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            for (int idx = 0; idx < 5; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                ClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                ClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                ClientServerTest.assertEquals((Object)response2, (Object)reply);
                greeter.greetMeOneWay("Milestone-" + idx);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testAsyncPollingCall() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        ClientServerTest.assertNotNull((Object)service);
        long before = System.currentTimeMillis();
        long delay = 3000L;
        Response r1 = greeter.greetMeLaterAsync(delay);
        Response r2 = greeter.greetMeLaterAsync(delay);
        long after = System.currentTimeMillis();
        ClientServerTest.assertTrue((String)("Duration of calls exceeded " + 2L * delay + " ms"), (after - before < 2L * delay ? 1 : 0) != 0);
        ClientServerTest.assertFalse((String)"Response already available.", (boolean)r1.isDone());
        ClientServerTest.assertFalse((String)"Response already available.", (boolean)r2.isDone());
        for (long waited = 0L; waited < delay + 1000L; waited += 500L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (r1.isDone() && r2.isDone()) break;
        }
        ClientServerTest.assertTrue((String)"Response is  not available.", (boolean)r1.isDone());
        ClientServerTest.assertTrue((String)"Response is  not available.", (boolean)r2.isDone());
    }

    @Test
    public void testAsyncSynchronousPolling() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ClientServerTest.assertNotNull((Object)service);
        final String expectedString = new String("Hello, finally!");
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        long before = System.currentTimeMillis();
        long delay = 3000L;
        Response response = greeter.greetMeLaterAsync(delay);
        long after = System.currentTimeMillis();
        ClientServerTest.assertTrue((String)("Duration of calls exceeded " + delay + " ms"), (after - before < delay ? 1 : 0) != 0);
        ClientServerTest.assertFalse((String)"Response already available.", (boolean)response.isDone());
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Poller
        extends Thread {
            Response<GreetMeLaterResponse> response;
            int tid;

            Poller(Response<GreetMeLaterResponse> r, int t) {
                this.response = r;
                this.tid = t;
            }

            @Override
            public void run() {
                if (this.tid % 2 > 0) {
                    while (!this.response.isDone()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                GreetMeLaterResponse reply = null;
                try {
                    reply = (GreetMeLaterResponse)this.response.get();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Poller " + this.tid + " failed with " + ex));
                }
                Assert.assertNotNull((String)("Poller " + this.tid + ": no response received from service"), (Object)reply);
                String s = reply.getResponseType();
                Assert.assertEquals((Object)expectedString, (Object)s);
            }
        }
        Poller[] pollers = new Poller[4];
        for (int i = 0; i < pollers.length; ++i) {
            pollers[i] = new Poller(response, i);
        }
        for (Poller p : pollers) {
            p.start();
        }
        for (Poller p : pollers) {
            p.join();
        }
    }

    @Test
    public void testAsyncCallUseProperAssignedExecutor() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        class TestExecutor
        implements Executor {
            private int count;

            TestExecutor() {
            }

            public void execute(Runnable command) {
                ++this.count;
                LOG.info("asyn call time " + this.count);
                command.run();
            }

            public int getCount() {
                return this.count;
            }
        }
        TestExecutor executor = new TestExecutor();
        service.setExecutor((Executor)executor);
        ClientServerTest.assertNotNull((Object)service);
        ClientServerTest.assertSame((Object)executor, (Object)service.getExecutor());
        ClientServerTest.assertEquals((Object)executor.getCount(), (Object)0);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        ArrayList<Response> responses = new ArrayList<Response>();
        for (int i = 0; i < 5; ++i) {
            responses.add(greeter.greetMeAsync("asyn call" + i));
        }
        for (Response resp : responses) {
            resp.get();
        }
        ClientServerTest.assertEquals((Object)5, (Object)executor.getCount());
    }

    @Test
    public void testAsyncCallWithHandler() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ClientServerTest.assertNotNull((Object)service);
        MyHandler h = new MyHandler();
        MyHandler.invocationCount = 0;
        String expectedString = new String("Hello, finally!");
        try {
            Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
            long before = System.currentTimeMillis();
            long delay = 3000L;
            Future f = greeter.greetMeLaterAsync(delay, (AsyncHandler)h);
            long after = System.currentTimeMillis();
            ClientServerTest.assertTrue((String)("Duration of calls exceeded " + delay + " ms"), (after - before < delay ? 1 : 0) != 0);
            ClientServerTest.assertFalse((String)"Response already available.", (boolean)f.isDone());
            for (int i = 0; !f.isDone() && i < 50; ++i) {
                Thread.sleep(100L);
            }
            ClientServerTest.assertEquals((String)"callback was not executed or did not return the expected result", (Object)expectedString, (Object)h.getReplyBuffer());
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        ClientServerTest.assertEquals((Object)1, (Object)MyHandler.invocationCount);
    }

    @Test
    public void testAsyncCallWithHandlerAndMultipleClients() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ClientServerTest.assertNotNull((Object)service);
        final MyHandler h = new MyHandler();
        MyHandler.invocationCount = 0;
        final String expectedString = new String("Hello, finally!");
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        long before = System.currentTimeMillis();
        long delay = 3000L;
        Future f = greeter.greetMeLaterAsync(delay, (AsyncHandler)h);
        long after = System.currentTimeMillis();
        ClientServerTest.assertTrue((String)("Duration of calls exceeded " + delay + " ms"), (after - before < delay ? 1 : 0) != 0);
        ClientServerTest.assertFalse((String)"Response already available.", (boolean)f.isDone());
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Poller
        extends Thread {
            Future<?> future;
            int tid;

            Poller(Future<?> f, int t) {
                this.future = f;
                this.tid = t;
            }

            @Override
            public void run() {
                if (this.tid % 2 > 0) {
                    while (!this.future.isDone()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                try {
                    this.future.get();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Poller " + this.tid + " failed with " + ex));
                }
                Assert.assertEquals((String)"callback was not executed or did not return the expected result", (Object)expectedString, (Object)h.getReplyBuffer());
            }
        }
        Poller[] pollers = new Poller[4];
        for (int i = 0; i < pollers.length; ++i) {
            pollers[i] = new Poller(f, i);
        }
        for (Poller p : pollers) {
            p.start();
        }
        for (Poller p : pollers) {
            p.join();
        }
        ClientServerTest.assertEquals((Object)1, (Object)MyHandler.invocationCount);
    }

    @Test
    public void testFaults() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ExecutorService ex = Executors.newFixedThreadPool(1);
        service.setExecutor((Executor)ex);
        ClientServerTest.assertNotNull((Object)service);
        String noSuchCodeFault = "NoSuchCodeLitFault";
        String badRecordFault = "BadRecordLitFault";
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        for (int idx = 0; idx < 2; ++idx) {
            try {
                greeter.testDocLitFault(noSuchCodeFault);
                ClientServerTest.fail((String)"Should have thrown NoSuchCodeLitFault exception");
            }
            catch (NoSuchCodeLitFault nslf) {
                ClientServerTest.assertNotNull((Object)nslf.getFaultInfo());
                ClientServerTest.assertNotNull((Object)nslf.getFaultInfo().getCode());
            }
            try {
                greeter.testDocLitFault(badRecordFault);
                ClientServerTest.fail((String)"Should have thrown BadRecordLitFault exception");
                continue;
            }
            catch (BadRecordLitFault brlf) {
                BindingProvider bp = (BindingProvider)greeter;
                Map responseContext = bp.getResponseContext();
                String contentType = (String)responseContext.get("Content-Type");
                ClientServerTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)contentType);
                Integer responseCode = (Integer)responseContext.get(Message.RESPONSE_CODE);
                ClientServerTest.assertEquals((Object)500, (Object)responseCode);
                ClientServerTest.assertNotNull((Object)brlf.getFaultInfo());
                ClientServerTest.assertEquals((Object)"BadRecordLitFault", (Object)brlf.getFaultInfo());
            }
        }
    }

    @Test
    public void testFaultStackTrace() throws Exception {
        System.setProperty("cxf.config.file.url", ((Object)((Object)this)).getClass().getResource("fault-stack-trace.xml").toString());
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        ExecutorService ex = Executors.newFixedThreadPool(1);
        service.setExecutor((Executor)ex);
        ClientServerTest.assertNotNull((Object)service);
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        try {
            greeter.testDocLitFault("");
            ClientServerTest.fail((String)"Should have thrown Runtime exception");
        }
        catch (WebServiceException e) {
            ClientServerTest.assertEquals((String)"can't get back original message", (Object)"Unknown source", (Object)e.getCause().getMessage());
            ClientServerTest.assertTrue((e.getCause().getStackTrace().length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetSayHi() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9000/SoapContext/SoapPort/sayHi");
        httpConnection.connect();
        httpConnection.connect();
        ClientServerTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)httpConnection.getContentType());
        ClientServerTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        ns.put("ns2", "http://apache.org/hello_world_soap_http/types");
        XPathUtils xu = new XPathUtils(ns);
        Node body = (Node)xu.getValue("/soap:Envelope/soap:Body", (Node)doc, XPathConstants.NODE);
        ClientServerTest.assertNotNull((Object)body);
        String response = (String)xu.getValue("//ns2:sayHiResponse/ns2:responseType/text()", body, XPathConstants.STRING);
        ClientServerTest.assertEquals((Object)"Bonjour", (Object)response);
    }

    @Test
    public void testGetGreetMe() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9000/SoapContext/SoapPort/greetMe/requestType/cxf");
        httpConnection.connect();
        ClientServerTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)httpConnection.getContentType());
        ClientServerTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        ns.put("ns2", "http://apache.org/hello_world_soap_http/types");
        XPathUtils xu = new XPathUtils(ns);
        Node body = (Node)xu.getValue("/soap:Envelope/soap:Body", (Node)doc, XPathConstants.NODE);
        ClientServerTest.assertNotNull((Object)body);
        String response = (String)xu.getValue("//ns2:greetMeResponse/ns2:responseType/text()", body, XPathConstants.STRING);
        ClientServerTest.assertEquals((Object)"Hello cxf", (Object)response);
    }

    @Test
    public void testGetWSDL() throws Exception {
        String url = "http://localhost:9000/SoapContext/SoapPort?wsdl";
        HttpURLConnection httpConnection = this.getHttpConnection(url);
        httpConnection.connect();
        ClientServerTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerTest.assertEquals((Object)"text/xml", (Object)httpConnection.getContentType());
        ClientServerTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerTest.assertNotNull((Object)doc);
    }

    @Test
    public void testGetGreetMeFromQuery() throws Exception {
        String url = "http://localhost:9000/SoapContext/SoapPort/greetMe?requestType=" + URLEncoder.encode("cxf (was CeltixFire)", "UTF-8");
        HttpURLConnection httpConnection = this.getHttpConnection(url);
        httpConnection.connect();
        ClientServerTest.assertEquals((Object)200, (Object)httpConnection.getResponseCode());
        ClientServerTest.assertEquals((Object)"text/xml; charset=utf-8", (Object)httpConnection.getContentType());
        ClientServerTest.assertEquals((Object)"OK", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getInputStream();
        ClientServerTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        ClientServerTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        ns.put("ns2", "http://apache.org/hello_world_soap_http/types");
        XPathUtils xu = new XPathUtils(ns);
        Node body = (Node)xu.getValue("/soap:Envelope/soap:Body", (Node)doc, XPathConstants.NODE);
        ClientServerTest.assertNotNull((Object)body);
        String response = (String)xu.getValue("//ns2:greetMeResponse/ns2:responseType/text()", body, XPathConstants.STRING);
        ClientServerTest.assertEquals((Object)"Hello cxf (was CeltixFire)", (Object)response);
    }

    @Test
    public void testBasicAuth() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.fakePortName, "http://schemas.xmlsoap.org/soap/", "http://localhost:9000/SoapContext/SoapPort");
        Greeter greeter = (Greeter)service.getPort(this.fakePortName, Greeter.class);
        try {
            BindingProvider bp = (BindingProvider)greeter;
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", "BJ");
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", "pswd");
            String s = greeter.greetMe("secure");
            ClientServerTest.assertEquals((Object)"Hello BJ", (Object)s);
            bp.getRequestContext().remove("javax.xml.ws.security.auth.username");
            bp.getRequestContext().remove("javax.xml.ws.security.auth.password");
            Client client = ClientProxy.getClient((Object)greeter);
            HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
            AuthorizationPolicy policy = new AuthorizationPolicy();
            policy.setUserName("BJ2");
            policy.setPassword("pswd");
            httpConduit.setAuthorization(policy);
            s = greeter.greetMe("secure");
            ClientServerTest.assertEquals((Object)"Hello BJ2", (Object)s);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testBogusAddress() throws Exception {
        String realAddress = "http://localhost:9015/SoapContext/SoapPort";
        SOAPServiceBogusAddressTest service = new SOAPServiceBogusAddressTest();
        Greeter greeter = service.getSoapPort();
        try {
            greeter.greetMe("test");
            ClientServerTest.fail((String)"Should fail");
        }
        catch (WebServiceException f) {
            // empty catch block
        }
        BindingProvider bp = (BindingProvider)greeter;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", realAddress);
        greeter.greetMe("test");
        greeter.greetMe("test");
        bp.getRequestContext().remove("javax.xml.ws.service.endpoint.address");
        try {
            greeter.greetMe("test");
            ClientServerTest.fail((String)"Should fail");
        }
        catch (WebServiceException f) {
            // empty catch block
        }
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", realAddress);
        String reply = greeter.sayHi();
        ClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
        ClientServerTest.assertEquals((Object)"Bonjour", (Object)reply);
    }

    @Test
    public void testDynamicClientFactory() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        String wsdlUrl = null;
        wsdlUrl = wsdl.toURI().toString();
        DynamicClientFactory dcf = DynamicClientFactory.newInstance();
        Client client = dcf.createClient(wsdlUrl, this.serviceName, this.portName);
        client.invoke("greetMe", new Object[]{"test"});
        Object[] result = client.invoke("sayHi", new Object[0]);
        ClientServerTest.assertNotNull((String)"no response received from service", (Object)result);
        ClientServerTest.assertEquals((Object)"Bonjour", (Object)result[0]);
        HashMap<String, String> jaxbContextProperties = new HashMap<String, String>();
        jaxbContextProperties.put("com.sun.xml.bind.defaultNamespaceRemap", "uri:ultima:thule");
        dcf.setJaxbContextProperties(jaxbContextProperties);
        client = dcf.createClient(wsdlUrl, this.serviceName, this.portName);
        client.invoke("greetMe", new Object[]{"test"});
        result = client.invoke("sayHi", new Object[0]);
        ClientServerTest.assertNotNull((String)"no response received from service", (Object)result);
        ClientServerTest.assertEquals((Object)"Bonjour", (Object)result[0]);
    }

    @Test
    public void testMultiPorts() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        QName sname = new QName("http://apache.org/hello_world_soap_http", "SOAPServiceMultiPortTypeTest");
        SOAPServiceMultiPortTypeTest service = new SOAPServiceMultiPortTypeTest(wsdl, sname);
        BareDocumentResponse resp = service.getDocLitBarePort().testDocLitBare("CXF");
        ClientServerTest.assertNotNull((Object)resp);
        ClientServerTest.assertEquals((Object)"CXF", (Object)resp.getCompany());
        String result = service.getGreeterPort().greetMe("CXF");
        ClientServerTest.assertEquals((Object)"Hello CXF", (Object)result);
    }

    @Test
    public void testProxy() throws Exception {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        };
        Object implementor4 = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{DocLitWrappedCodeFirstService.class}, handler);
        Endpoint.publish((String)"http://localhost:9023/DocLitWrappedCodeFirstService/", (Object)implementor4);
        URL url = new URL("http://localhost:9023/DocLitWrappedCodeFirstService/?wsdl");
        InputStream ins = url.openStream();
        ins.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyHandler
    implements AsyncHandler<GreetMeLaterResponse> {
        static int invocationCount;
        private String replyBuffer;

        MyHandler() {
        }

        public void handleResponse(Response<GreetMeLaterResponse> response) {
            ++invocationCount;
            try {
                GreetMeLaterResponse reply = (GreetMeLaterResponse)response.get();
                this.replyBuffer = reply.getResponseType();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
        }

        String getReplyBuffer() {
            return this.replyBuffer;
        }
    }
}

