/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.test.AbstractCXFTest;
import org.apache.hello_world_soap_http.Greeter;
import org.junit.Assert;
import org.junit.Test;

public class JaxWsClientThreadTest
extends AbstractCXFTest {
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");

    @Test
    public void testRequestContextThreadSafety() throws Throwable {
        int i;
        URL url = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        Service s = Service.create((URL)url, (QName)this.serviceName);
        final Greeter greeter = (Greeter)s.getPort(this.portName, Greeter.class);
        final InvocationHandler handler = Proxy.getInvocationHandler(greeter);
        ((BindingProvider)handler).getRequestContext().put("thread.local.request.context", Boolean.TRUE);
        Map requestContext = ((BindingProvider)handler).getRequestContext();
        String address = (String)requestContext.get("javax.xml.ws.service.endpoint.address");
        final Throwable[] errorHolder = new Throwable[1];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String protocol = "http-" + Thread.currentThread().getId();
                    for (int i = 0; i < 10; ++i) {
                        String threadSpecificaddress = protocol + "://localhost:80/" + i;
                        Map requestContext = ((BindingProvider)handler).getRequestContext();
                        requestContext.put("javax.xml.ws.service.endpoint.address", threadSpecificaddress);
                        Assert.assertEquals((String)"we get what we set", (Object)threadSpecificaddress, requestContext.get("javax.xml.ws.service.endpoint.address"));
                        try {
                            greeter.greetMe("Hi");
                        }
                        catch (SOAPFaultException expected) {
                            MalformedURLException mue = (MalformedURLException)expected.getCause().getCause();
                            if (mue == null || mue.getMessage() == null) {
                                throw expected;
                            }
                            Assert.assertTrue((String)"protocol contains thread id from context", (mue.getMessage().indexOf(protocol) != 0 ? 1 : 0) != 0);
                        }
                        requestContext.remove("javax.xml.ws.service.endpoint.address");
                        Assert.assertTrue((String)"property is null", (requestContext.get("javax.xml.ws.service.endpoint.address") == null ? 1 : 0) != 0);
                    }
                }
                catch (Throwable t) {
                    errorHolder[0] = t;
                }
            }
        };
        int numThreads = 5;
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new Thread(r);
        }
        for (i = 0; i < 5; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
        if (errorHolder[0] != null) {
            throw errorHolder[0];
        }
        JaxWsClientThreadTest.assertTrue((String)"address from existing context has not changed", (boolean)address.equals(requestContext.get("javax.xml.ws.service.endpoint.address")));
        ((ClientImpl.EchoContext)((WrappedMessageContext)requestContext).getWrappedMap()).reload();
        JaxWsClientThreadTest.assertTrue((String)"address is different", (!address.equals(requestContext.get("javax.xml.ws.service.endpoint.address")) ? 1 : 0) != 0);
        JaxWsClientThreadTest.assertTrue((String)"property is null from last thread execution", (requestContext.get("javax.xml.ws.service.endpoint.address") == null ? 1 : 0) != 0);
    }
}

