/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.no_body_parts.types.Operation1;
import org.apache.cxf.no_body_parts.types.Operation1Response;
import org.apache.cxf.systest.jaxws.ServerNoBodyParts;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JaxWsDynamicClientTest
extends AbstractBusClientServerTestBase {
    private String md5(byte[] bytes) {
        MessageDigest algorithm;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        algorithm.reset();
        algorithm.update(bytes);
        byte[] messageDigest = algorithm.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        JaxWsDynamicClientTest.assertTrue((String)"server did not launch correctly", (boolean)JaxWsDynamicClientTest.launchServer(ServerNoBodyParts.class, (boolean)true));
    }

    @Test
    public void testInvocation() throws Exception {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        URL wsdlURL = new URL("http://localhost:9020/NoBodyParts/NoBodyPartsService?wsdl");
        Client client = dcf.createClient(wsdlURL);
        byte[] bucketOfBytes = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/wsdl/no_body_parts.wsdl"));
        Operation1 parameters = new Operation1();
        parameters.setOptionString("opt-ion");
        parameters.setTargetType("tar-get");
        Object[] rparts = client.invoke("operation1", new Object[]{parameters, bucketOfBytes});
        Operation1Response r = (Operation1Response)rparts[0];
        JaxWsDynamicClientTest.assertEquals((Object)this.md5(bucketOfBytes), (Object)r.getStatus());
        ClientCallback callback = new ClientCallback();
        client.invoke(callback, "operation1", new Object[]{parameters, bucketOfBytes});
        rparts = callback.get();
        r = (Operation1Response)rparts[0];
        JaxWsDynamicClientTest.assertEquals((Object)this.md5(bucketOfBytes), (Object)r.getStatus());
    }
}

