/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxws;

import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Holder;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.locator.LocatorService;
import org.apache.locator.LocatorService_Service;
import org.apache.locator.types.QueryEndpoints;
import org.apache.locator_test.LocatorServiceImpl;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class LocatorClientServerTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(LocatorClientServerTest.class);
    private final QName serviceName = new QName("http://apache.org/locator", "LocatorService");

    @BeforeClass
    public static void startServers() throws Exception {
        LocatorClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)LocatorClientServerTest.launchServer(MyServer.class));
    }

    @Test
    @Ignore(value="not legal if serviceName, portName, address all NULL")
    public void testLocatorService() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/locator.wsdl");
        LocatorClientServerTest.assertNotNull((Object)wsdl);
        LocatorService_Service ss = new LocatorService_Service(wsdl, this.serviceName);
        LocatorService port = ss.getLocatorServicePort();
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        W3CEndpointReference w3cEpr = builder.build();
        port.registerPeerManager(w3cEpr, new Holder(), new Holder());
        port.deregisterPeerManager(new String());
        port.registerEndpoint(null, w3cEpr);
        port.deregisterEndpoint(null, w3cEpr);
        port.lookupEndpoint(new QName("", ""));
        port.listEndpoints();
        port.queryEndpoints(new QueryEndpoints());
    }

    @Test
    public void testIllegalState() throws Exception {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        try {
            builder.build();
            LocatorClientServerTest.fail((String)"Address in an EPR cannot be null, when serviceName or portName is null");
        }
        catch (IllegalStateException ie) {
            LocatorClientServerTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            LocatorClientServerTest.fail((String)("Unexpected Exception " + e.getClass() + " raised: " + e.getMessage()));
        }
    }

    public static class MyServer
    extends AbstractBusTestServerBase {
        protected void run() {
            LocatorServiceImpl implementor = new LocatorServiceImpl();
            String address = "http://localhost:6006/services/LocatorService";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                MyServer s = new MyServer();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                LOG.info("done!");
            }
        }
    }
}

