/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jbi;

import java.net.URL;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.hello_world.jbi.Greeter;
import org.apache.hello_world.jbi.GreeterImpl;
import org.apache.hello_world.jbi.HelloWorldService;
import org.apache.hello_world.jbi.PingMeFault;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientServerTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(ClientServerTest.class);
    private final QName serviceName = new QName("http://apache.org/hello_world/jbi", "HelloWorldService");
    private JBIContainer container;

    @BeforeClass
    public static void startServers() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.container = new JBIContainer();
        this.container.setEmbedded(true);
        this.container.init();
        this.container.start();
    }

    @After
    public void tearDown() throws Exception {
        this.container.shutDown();
    }

    @Test
    public void testJBI() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_jbi.wsdl");
        ClientServerTest.assertNotNull((Object)wsdl);
        this.createBus();
        assert (this.bus != null);
        TestComponent component = new TestComponent(new QName("http://apache.org/hello_world/jbi", "HelloWorldService"), "endpoint");
        this.container.activateComponent(new ActivationSpec("component", (Object)component));
        DeliveryChannel channel = component.getChannel();
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        jbiTransportFactory.setBus(this.bus);
        jbiTransportFactory.setDeliveryChannel(channel);
        HelloWorldService ss = new HelloWorldService(wsdl, this.serviceName);
        Greeter port = ss.getSoapPort();
        GreeterImpl implementor = new GreeterImpl();
        String address = "http://foo/bar/baz";
        EndpointImpl e = (EndpointImpl)Endpoint.publish((String)address, (Object)implementor);
        e.getServer().getEndpoint().getInInterceptors().add(new LoggingInInterceptor());
        e.getServer().getEndpoint().getOutInterceptors().add(new LoggingOutInterceptor());
        port.greetMeOneWay("test");
        String rep = port.greetMe("ffang");
        ClientServerTest.assertEquals((Object)rep, (Object)"Hello ffang");
        rep = port.sayHi();
        ClientServerTest.assertEquals((Object)rep, (Object)"Bonjour");
        try {
            port.pingMe();
            ClientServerTest.fail();
        }
        catch (PingMeFault ex) {
            ClientServerTest.assertEquals((Object)ex.getFaultInfo().getMajor(), (Object)2);
            ClientServerTest.assertEquals((Object)ex.getFaultInfo().getMinor(), (Object)1);
        }
    }

    public static class TestComponent
    extends ComponentSupport {
        public TestComponent(QName service, String endpoint) {
            super(service, endpoint);
        }

        public DeliveryChannel getChannel() throws MessagingException {
            return this.getContext().getDeliveryChannel();
        }
    }
}

