/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jca;

import java.net.URL;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.connector.Connection;
import org.apache.cxf.jca.cxf.CXFConnectionRequestInfo;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.BeforeClass;
import org.junit.Test;

public class OutBoundConnectionTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        OutBoundConnectionTest.assertTrue((String)"server did not launch correctly", (boolean)OutBoundConnectionTest.launchServer(Server.class));
    }

    @Test
    public void testBasicConnection() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        OutBoundConnectionTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        OutBoundConnectionTest.assertNotNull((Object)service);
        CXFConnectionRequestInfo cri = new CXFConnectionRequestInfo(Greeter.class, wsdl, service.getServiceName(), this.portName);
        ManagedConnectionFactoryImpl managedFactory = new ManagedConnectionFactoryImpl();
        Subject subject = new Subject();
        ManagedConnection mc = managedFactory.createManagedConnection(subject, (ConnectionRequestInfo)cri);
        Object o = mc.getConnection(subject, (ConnectionRequestInfo)cri);
        try {
            o.hashCode();
            o.toString();
        }
        catch (WebServiceException ex) {
            OutBoundConnectionTest.fail((String)"The connection object should support Object method");
        }
        this.verifyResult(o);
    }

    @Test
    public void testGetConnectionFromSEI() throws Exception {
        CXFConnectionRequestInfo requestInfo = new CXFConnectionRequestInfo();
        requestInfo.setInterface(Greeter.class);
        requestInfo.setAddress("http://localhost:9000/SoapContext/SoapPort");
        ManagedConnectionFactoryImpl factory = new ManagedConnectionFactoryImpl();
        ManagedConnection mc = factory.createManagedConnection(null, (ConnectionRequestInfo)requestInfo);
        Object client = mc.getConnection(null, (ConnectionRequestInfo)requestInfo);
        this.verifyResult(client);
    }

    private void verifyResult(Object o) throws Exception {
        OutBoundConnectionTest.assertTrue((String)"returned connect does not implement Connection interface", (boolean)(o instanceof Connection));
        OutBoundConnectionTest.assertTrue((String)"returned connect does not implement Connection interface", (boolean)(o instanceof Greeter));
        Greeter greeter = (Greeter)o;
        String response = new String("Bonjour");
        for (int idx = 0; idx < 5; ++idx) {
            String reply = greeter.sayHi();
            OutBoundConnectionTest.assertNotNull((String)"no response received from service", (Object)reply);
            OutBoundConnectionTest.assertEquals((Object)response, (Object)reply);
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9000/SoapContext/SoapPort";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

