/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms;

import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.hello_world_jms.HelloWorldOneWayPort;
import org.apache.cxf.hello_world_jms.HelloWorldQueueDecoupledOneWaysService;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;

@WebService(serviceName="HelloWorldQueueDecoupledOneWaysService", portName="HelloWorldQueueDecoupledOneWaysPort", endpointInterface="org.apache.cxf.hello_world_jms.HelloWorldOneWayPort", targetNamespace="http://cxf.apache.org/hello_world_jms", wsdlLocation="testutils/jms_test.wsdl")
public class GreeterImplQueueDecoupledOneWays
implements HelloWorldOneWayPort {
    @Resource
    private WebServiceContext context;
    private Throwable asyncEx;
    private String request;
    private String reply;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean specCompliant;

    public GreeterImplQueueDecoupledOneWays() {
    }

    public GreeterImplQueueDecoupledOneWays(boolean specCompliant) {
        this.specCompliant = specCompliant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void greetMeOneWay(String value) {
        block11: {
            GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
            synchronized (greeterImplQueueDecoupledOneWays) {
                this.request = value;
                this.notifyAll();
            }
            try {
                if (this.latch.await(2000L, TimeUnit.MILLISECONDS)) break block11;
                greeterImplQueueDecoupledOneWays = this;
                synchronized (greeterImplQueueDecoupledOneWays) {
                    this.asyncEx = new Exception("Time out while waiting for command to send reply");
                    this.notifyAll();
                }
                return;
            }
            catch (InterruptedException e) {
                GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays2 = this;
                synchronized (greeterImplQueueDecoupledOneWays2) {
                    this.asyncEx = e;
                    this.notifyAll();
                }
                return;
            }
        }
        this.sendReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReply() {
        JMSMessageHeadersType headers = (JMSMessageHeadersType)this.context.getMessageContext().get((Object)"org.apache.cxf.jms.server.request.headers");
        if (headers == null || headers.getJMSReplyTo() == null) {
            GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
            synchronized (greeterImplQueueDecoupledOneWays) {
                if (!this.specCompliant) {
                    this.asyncEx = new Exception("ReplyTo header in the server Request context was null");
                }
                this.notifyAll();
            }
            return;
        }
        if (headers != null && headers.getJMSReplyTo() != null && this.specCompliant) {
            GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
            synchronized (greeterImplQueueDecoupledOneWays) {
                this.asyncEx = new Exception("ReplyTo header in the server Request context was not null");
                this.notifyAll();
            }
            return;
        }
        QName serviceName = new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldQueueDecoupledOneWaysService");
        QName portName = new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldQueueDecoupledOneWaysReplyPort");
        Throwable e = null;
        try {
            URL wsdl = this.getClass().getResource("/wsdl/jms_test.wsdl");
            HelloWorldQueueDecoupledOneWaysService service = new HelloWorldQueueDecoupledOneWaysService(wsdl, serviceName);
            HelloWorldOneWayPort greeter = (HelloWorldOneWayPort)service.getPort(portName, HelloWorldOneWayPort.class);
            this.reply = "Re:" + this.request;
            greeter.greetMeOneWay(this.reply);
        }
        catch (Throwable t) {
            e = t;
        }
        GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
        synchronized (greeterImplQueueDecoupledOneWays) {
            this.asyncEx = e;
            this.notifyAll();
        }
    }

    public void proceedWithReply() {
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ackRequestReceived(long timeout) {
        GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
        synchronized (greeterImplQueueDecoupledOneWays) {
            if (this.request != null) {
                return this.request;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.asyncEx = e;
                return null;
            }
        }
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ackReplySent(long timeout) {
        GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
        synchronized (greeterImplQueueDecoupledOneWays) {
            if (this.asyncEx != null) {
                return null;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.asyncEx = e;
                return null;
            }
        }
        return this.reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ackNoReplySent(long timeout) {
        GreeterImplQueueDecoupledOneWays greeterImplQueueDecoupledOneWays = this;
        synchronized (greeterImplQueueDecoupledOneWays) {
            if (this.asyncEx != null) {
                return false;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.asyncEx = e;
            }
        }
        return this.asyncEx == null;
    }

    public Throwable getException() {
        return this.asyncEx;
    }
}

