/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.hello_world_jms.BadRecordLitFault;
import org.apache.cxf.hello_world_jms.HWByteMsgService;
import org.apache.cxf.hello_world_jms.HelloWorldOneWayPort;
import org.apache.cxf.hello_world_jms.HelloWorldOneWayQueueService;
import org.apache.cxf.hello_world_jms.HelloWorldPortType;
import org.apache.cxf.hello_world_jms.HelloWorldPubSubPort;
import org.apache.cxf.hello_world_jms.HelloWorldPubSubService;
import org.apache.cxf.hello_world_jms.HelloWorldQueueDecoupledOneWaysService;
import org.apache.cxf.hello_world_jms.HelloWorldService;
import org.apache.cxf.hello_world_jms.HelloWorldServiceAppCorrelationIDNoPrefix;
import org.apache.cxf.hello_world_jms.HelloWorldServiceAppCorrelationIDStaticPrefix;
import org.apache.cxf.hello_world_jms.HelloWorldServiceRuntimeCorrelationIDDynamicPrefix;
import org.apache.cxf.hello_world_jms.HelloWorldServiceRuntimeCorrelationIDStaticPrefix;
import org.apache.cxf.hello_world_jms.NoSuchCodeLitFault;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.systest.jms.GreeterImplQueueDecoupledOneWays;
import org.apache.cxf.systest.jms.GreeterImplQueueDecoupledOneWaysDeferredReply;
import org.apache.cxf.systest.jms.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSNamingPropertyType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.apache.hello_world_doc_lit.Greeter;
import org.apache.hello_world_doc_lit.PingMeFault;
import org.apache.hello_world_doc_lit.SOAPService2;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JMSClientServerTest
extends AbstractBusClientServerTestBase {
    protected static boolean serversStarted;

    @Before
    public void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        JMSClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        JMSClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSClientServerTest.launchServer(Server.class, (boolean)false));
        serversStarted = true;
    }

    public URL getWSDLURL(String s) throws Exception {
        return ((Object)((Object)this)).getClass().getResource(s);
    }

    public QName getServiceName(QName q) {
        return q;
    }

    public QName getPortName(QName q) {
        return q;
    }

    @Test
    public void testDocBasicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://apache.org/hello_world_doc_lit", "SOAPService2"));
        QName portName = this.getPortName(new QName("http://apache.org/hello_world_doc_lit", "SoapPort2"));
        URL wsdl = this.getWSDLURL("/wsdl/hello_world_doc_lit.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        SOAPService2 service = new SOAPService2(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            Client client = ClientProxy.getClient((Object)greeter);
            EndpointInfo ei = client.getEndpoint().getEndpointInfo();
            AddressType address = (AddressType)ei.getTraversedExtensor((Object)new AddressType(), AddressType.class);
            JMSNamingPropertyType name = new JMSNamingPropertyType();
            JMSNamingPropertyType password = new JMSNamingPropertyType();
            name.setName("java.naming.security.principal");
            name.setValue("ivan");
            password.setName("java.naming.security.credentials");
            password.setValue("the-terrible");
            address.getJMSNamingProperty().add(name);
            address.getJMSNamingProperty().add(password);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("test String");
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.pingMe();
                    JMSClientServerTest.fail((String)"Should have thrown FaultException");
                    continue;
                }
                catch (PingMeFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void docBasicJmsDestinationTest() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://apache.org/hello_world_doc_lit", "SOAPService6"));
        QName portName = this.getPortName(new QName("http://apache.org/hello_world_doc_lit", "SoapPort6"));
        URL wsdl = this.getWSDLURL("/wsdl/hello_world_doc_lit.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        SOAPService2 service = new SOAPService2(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("test String");
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.pingMe();
                    JMSClientServerTest.fail((String)"Should have thrown FaultException");
                    continue;
                }
                catch (PingMeFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testJmsClientWithHandler() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/apache/cxf/systest/jms/JMSClientWithHandler.xml");
        Greeter greeter = (Greeter)context.getBean("myClient");
        try {
            greeter.sayHi();
            JMSClientServerTest.fail((String)"Expect exception here");
        }
        catch (Exception ex) {
            JMSClientServerTest.assertTrue((String)"Get a wrong exception", (boolean)(ex instanceof RuntimeException));
            JMSClientServerTest.assertEquals((String)"Get a wrong exception", (Object)"VRS Exception", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBasicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPort"));
        URL wsdl = this.getWSDLURL("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldService service = new HelloWorldService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            HelloWorldPortType greeter = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
            for (int idx = 0; idx < 5; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.testRpcLitFault("BadRecordLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown BadRecoedLitFault");
                }
                catch (BadRecordLitFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
                try {
                    greeter.testRpcLitFault("NoSuchCodeLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown NoSuchCodeLitFault exception");
                    continue;
                }
                catch (NoSuchCodeLitFault nslf) {
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo());
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo().getCode());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        catch (Exception t) {
            throw t;
        }
    }

    @Test
    public void testByteMessage() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HWByteMsgService"));
        URL wsdl = this.getWSDLURL("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HWByteMsgService service = new HWByteMsgService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            HelloWorldPortType greeter = service.getHWSByteMsgPort();
            for (int idx = 0; idx < 2; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testOneWayTopicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPubSubService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPubSubPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldPubSubService service = new HelloWorldPubSubService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldPubSubPort greeter = (HelloWorldPubSubPort)service.getPort(portName, HelloWorldPubSubPort.class);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("JMS:PubSub:Milestone-" + idx);
            }
            Thread.sleep(100L);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testJmsDestTopicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "JmsDestinationPubSubService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "JmsDestinationPubSubPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldPubSubService service = new HelloWorldPubSubService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldPubSubPort greeter = (HelloWorldPubSubPort)service.getPort(portName, HelloWorldPubSubPort.class);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("JMS:PubSub:Milestone-" + idx);
            }
            Thread.sleep(100L);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testConnectionsWithinSpring() throws Exception {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"/org/apache/cxf/systest/jms/JMSClients.xml"});
        HelloWorldPortType greeter = (HelloWorldPortType)ctx.getBean("jmsRPCClient");
        JMSClientServerTest.assertNotNull((Object)greeter);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            for (int idx = 0; idx < 5; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                String exResponse = response1 + idx;
                JMSClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                String reply = greeter.sayHi();
                JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                JMSClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.testRpcLitFault("BadRecordLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown BadRecoedLitFault");
                }
                catch (BadRecordLitFault ex) {
                    JMSClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
                try {
                    greeter.testRpcLitFault("NoSuchCodeLitFault");
                    JMSClientServerTest.fail((String)"Should have thrown NoSuchCodeLitFault exception");
                    continue;
                }
                catch (NoSuchCodeLitFault nslf) {
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo());
                    JMSClientServerTest.assertNotNull((Object)nslf.getFaultInfo().getCode());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        HelloWorldOneWayPort greeter1 = (HelloWorldOneWayPort)ctx.getBean("jmsQueueOneWayServiceClient");
        JMSClientServerTest.assertNotNull((Object)greeter1);
        try {
            greeter1.greetMeOneWay("hello");
        }
        catch (Exception ex) {
            JMSClientServerTest.fail((String)("There should not throw the exception" + ex));
        }
    }

    @Test
    public void testOneWayQueueConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldOneWayQueueService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldOneWayQueuePort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldOneWayQueueService service = new HelloWorldOneWayQueueService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldOneWayPort greeter = (HelloWorldOneWayPort)service.getPort(portName, HelloWorldOneWayPort.class);
            for (int idx = 0; idx < 5; ++idx) {
                greeter.greetMeOneWay("JMS:Queue:Milestone-" + idx);
            }
            Thread.sleep(100L);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testQueueDecoupledOneWaysConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldQueueDecoupledOneWaysService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldQueueDecoupledOneWaysPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldQueueDecoupledOneWaysService service = new HelloWorldQueueDecoupledOneWaysService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        Endpoint requestEndpoint = null;
        Endpoint replyEndpoint = null;
        try {
            String reply;
            HelloWorldOneWayPort greeter = (HelloWorldOneWayPort)service.getPort(portName, HelloWorldOneWayPort.class);
            GreeterImplQueueDecoupledOneWays requestServant = new GreeterImplQueueDecoupledOneWays();
            requestEndpoint = Endpoint.publish((String)"", (Object)requestServant);
            GreeterImplQueueDecoupledOneWaysDeferredReply replyServant = new GreeterImplQueueDecoupledOneWaysDeferredReply();
            replyEndpoint = Endpoint.publish((String)"", (Object)replyServant);
            InvocationHandler handler = Proxy.getInvocationHandler(greeter);
            BindingProvider bp = (BindingProvider)handler;
            Map requestContext = bp.getRequestContext();
            JMSMessageHeadersType requestHeader = new JMSMessageHeadersType();
            requestHeader.setJMSReplyTo("dynamicQueues/test.jmstransport.oneway.with.set.replyto.reply");
            requestContext.put("org.apache.cxf.jms.client.request.headers", requestHeader);
            String expectedRequest = "JMS:Queue:Request";
            greeter.greetMeOneWay(expectedRequest);
            String request = requestServant.ackRequestReceived(5000L);
            if (request == null) {
                if (requestServant.getException() != null) {
                    JMSClientServerTest.fail((String)requestServant.getException().getMessage());
                } else {
                    JMSClientServerTest.fail((String)"The oneway call didn't reach its intended endpoint");
                }
            }
            JMSClientServerTest.assertEquals((Object)expectedRequest, (Object)request);
            requestServant.proceedWithReply();
            String expectedReply = requestServant.ackReplySent(5000L);
            if (expectedReply == null) {
                if (requestServant.getException() != null) {
                    JMSClientServerTest.fail((String)requestServant.getException().getMessage());
                } else {
                    JMSClientServerTest.fail((String)"The decoupled one-way reply was not sent");
                }
            }
            if ((reply = replyServant.ackRequest(5000L)) == null) {
                if (replyServant.getException() != null) {
                    JMSClientServerTest.fail((String)replyServant.getException().getMessage());
                } else {
                    JMSClientServerTest.fail((String)"The decoupled one-way reply didn't reach its intended endpoint");
                }
            }
            JMSClientServerTest.assertEquals((Object)expectedReply, (Object)reply);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (requestEndpoint != null) {
                requestEndpoint.stop();
            }
            if (replyEndpoint != null) {
                replyEndpoint.stop();
            }
        }
    }

    @Test
    public void testQueueOneWaySpecCompliantConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldQueueDecoupledOneWaysService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldQueueDecoupledOneWaysPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldQueueDecoupledOneWaysService service = new HelloWorldQueueDecoupledOneWaysService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        Endpoint requestEndpoint = null;
        try {
            HelloWorldOneWayPort greeter = (HelloWorldOneWayPort)service.getPort(portName, HelloWorldOneWayPort.class);
            GreeterImplQueueDecoupledOneWays requestServant = new GreeterImplQueueDecoupledOneWays(true);
            requestEndpoint = Endpoint.publish((String)"", (Object)requestServant);
            Client client = ClientProxy.getClient((Object)greeter);
            ((JMSConduit)client.getConduit()).getJmsConfig().setEnforceSpec(true);
            InvocationHandler handler = Proxy.getInvocationHandler(greeter);
            BindingProvider bp = (BindingProvider)handler;
            Map requestContext = bp.getRequestContext();
            JMSMessageHeadersType requestHeader = new JMSMessageHeadersType();
            requestHeader.setJMSReplyTo("dynamicQueues/test.jmstransport.oneway.with.set.replyto.reply");
            requestContext.put("org.apache.cxf.jms.client.request.headers", requestHeader);
            String expectedRequest = "JMS:Queue:Request";
            greeter.greetMeOneWay(expectedRequest);
            String request = requestServant.ackRequestReceived(5000L);
            if (request == null) {
                if (requestServant.getException() != null) {
                    JMSClientServerTest.fail((String)requestServant.getException().getMessage());
                } else {
                    JMSClientServerTest.fail((String)"The oneway call didn't reach its intended endpoint");
                }
            }
            JMSClientServerTest.assertEquals((Object)expectedRequest, (Object)request);
            requestServant.proceedWithReply();
            boolean ack = requestServant.ackNoReplySent(5000L);
            if (!ack) {
                if (requestServant.getException() != null) {
                    JMSClientServerTest.fail((String)requestServant.getException().getMessage());
                } else {
                    JMSClientServerTest.fail((String)"The decoupled one-way reply was sent");
                }
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (requestEndpoint != null) {
                requestEndpoint.stop();
            }
        }
    }

    @Test
    public void testTwoWayQueueAppCorrelationIDStaticPrefix() throws Exception {
        Throwable e;
        Thread[] threads;
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldServiceAppCorrelationIDStaticPrefix"));
        QName portNameEng = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPortAppCorrelationIDStaticPrefixEng"));
        QName portNameSales = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPortAppCorrelationIDStaticPrefixSales"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldServiceAppCorrelationIDStaticPrefix service = new HelloWorldServiceAppCorrelationIDStaticPrefix(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        ClientRunnable engClient = new ClientRunnable((HelloWorldPortType)service.getPort(portNameEng, HelloWorldPortType.class), new CorrelationIDFactory(){
            private int counter;

            public String createCorrealtionID() {
                return "com.mycompany.eng:" + this.counter++;
            }
        });
        ClientRunnable salesClient = new ClientRunnable((HelloWorldPortType)service.getPort(portNameSales, HelloWorldPortType.class), new CorrelationIDFactory(){
            private int counter;

            public String createCorrealtionID() {
                return "com.mycompany.sales:" + this.counter++;
            }
        });
        for (Thread t : threads = new Thread[]{new Thread(engClient), new Thread(salesClient)}) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        Throwable throwable = engClient.getException() != null ? engClient.getException() : (e = salesClient.getException() != null ? salesClient.getException() : null);
        if (e != null) {
            StringBuffer message = new StringBuffer();
            for (StackTraceElement ste : e.getStackTrace()) {
                message.append(ste.toString() + System.getProperty("line.separator"));
            }
            JMSClientServerTest.fail((String)message.toString());
        }
    }

    @Test
    public void testTwoWayQueueAppCorrelationIDNoPrefix() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldServiceAppCorrelationIDNoPrefix"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPortAppCorrelationIDNoPrefix"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldServiceAppCorrelationIDNoPrefix service = new HelloWorldServiceAppCorrelationIDNoPrefix(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<ClientRunnable> clients = new ArrayList<ClientRunnable>();
        HelloWorldPortType port = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
        for (int i = 0; i < 100; ++i) {
            ClientRunnable client = new ClientRunnable(port, new CorrelationIDFactory(){

                public String createCorrealtionID() {
                    return UUID.randomUUID().toString();
                }
            });
            Thread thread = new Thread(client);
            threads.add(thread);
            clients.add(client);
            thread.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (ClientRunnable client : clients) {
            if (client.getException() == null || !client.getException().getMessage().contains("Timeout")) continue;
            return;
        }
        JMSClientServerTest.fail((String)"This is a negative pass. If this test passed this means that the missing QoS has been added to the runtime or an unexpected exception received.  If latter is true, then read method comments for details on missing QoS and change this test to fail on exception");
    }

    @Test
    public void testTwoWayQueueRuntimeCorrelationIDStaticPrefix() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldServiceRuntimeCorrelationIDStaticPrefix"));
        QName portNameEng = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPortRuntimeCorrelationIDStaticPrefixEng"));
        QName portNameSales = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPortRuntimeCorrelationIDStaticPrefixSales"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldServiceRuntimeCorrelationIDStaticPrefix service = new HelloWorldServiceRuntimeCorrelationIDStaticPrefix(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<ClientRunnable> clients = new ArrayList<ClientRunnable>();
        HelloWorldPortType portEng = (HelloWorldPortType)service.getPort(portNameEng, HelloWorldPortType.class);
        HelloWorldPortType portSales = (HelloWorldPortType)service.getPort(portNameSales, HelloWorldPortType.class);
        for (int i = 0; i < 100; ++i) {
            ClientRunnable client = new ClientRunnable(portEng, "com.mycompany.eng:");
            Thread thread = new Thread(client);
            threads.add(thread);
            clients.add(client);
            thread.start();
            client = new ClientRunnable(portSales, "com.mycompany.sales:");
            thread = new Thread(client);
            threads.add(thread);
            clients.add(client);
            thread.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (ClientRunnable client : clients) {
            if (client.getException() == null || !client.getException().getMessage().contains("Timeout")) continue;
            JMSClientServerTest.fail((String)client.getException().getMessage());
        }
    }

    @Test
    public void testTwoWayQueueRuntimeCorrelationDynamicPrefix() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldServiceRuntimeCorrelationIDDynamicPrefix"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPortRuntimeCorrelationIDDynamicPrefix"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldServiceRuntimeCorrelationIDDynamicPrefix service = new HelloWorldServiceRuntimeCorrelationIDDynamicPrefix(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<ClientRunnable> clients = new ArrayList<ClientRunnable>();
        HelloWorldPortType port = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
        for (int i = 0; i < 100; ++i) {
            ClientRunnable client = new ClientRunnable(port);
            Thread thread = new Thread(client);
            threads.add(thread);
            clients.add(client);
            thread.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (ClientRunnable client : clients) {
            if (client.getException() == null) continue;
            JMSClientServerTest.fail((String)client.getException().getMessage());
        }
    }

    @Test
    public void testContextPropogation() throws Exception {
        String testReturnPropertyName = "Test_Prop";
        String testIgnoredPropertyName = "Test_Prop_No_Return";
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPort"));
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/jms_test.wsdl");
        JMSClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldService service = new HelloWorldService(wsdl, serviceName);
        JMSClientServerTest.assertNotNull((Object)service);
        try {
            HelloWorldPortType greeter = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
            InvocationHandler handler = Proxy.getInvocationHandler(greeter);
            BindingProvider bp = null;
            if (handler instanceof BindingProvider) {
                bp = (BindingProvider)handler;
                Map requestContext = bp.getRequestContext();
                JMSMessageHeadersType requestHeader = new JMSMessageHeadersType();
                requestHeader.setJMSCorrelationID("JMS_SAMPLE_CORRELATION_ID");
                requestHeader.setJMSExpiration(3600000L);
                JMSPropertyType propType = new JMSPropertyType();
                propType.setName("Test_Prop");
                propType.setValue("mustReturn");
                requestHeader.getProperty().add(propType);
                propType = new JMSPropertyType();
                propType.setName("Test_Prop_No_Return");
                propType.setValue("mustNotReturn");
                requestContext.put("org.apache.cxf.jms.client.request.headers", requestHeader);
            }
            String greeting = greeter.greetMe("Milestone-");
            JMSClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
            JMSClientServerTest.assertEquals((Object)"Hello Milestone-", (Object)greeting);
            if (bp != null) {
                Map responseContext = bp.getResponseContext();
                JMSMessageHeadersType responseHdr = (JMSMessageHeadersType)responseContext.get("org.apache.cxf.jms.client.response.headers");
                if (responseHdr == null) {
                    JMSClientServerTest.fail((String)"response Header should not be null");
                }
                JMSClientServerTest.assertTrue((String)"CORRELATION ID should match :", (boolean)"JMS_SAMPLE_CORRELATION_ID".equals(responseHdr.getJMSCorrelationID()));
                JMSClientServerTest.assertTrue((String)"response Headers must conain the app property set in request context.", (responseHdr.getProperty() != null ? 1 : 0) != 0);
                boolean found = false;
                for (JMSPropertyType p : responseHdr.getProperty()) {
                    if (!"Test_Prop".equals(p.getName())) continue;
                    found = true;
                }
                JMSClientServerTest.assertTrue((String)"response Headers must match the app property set in request context.", (boolean)found);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    private static class ClientRunnable
    implements Runnable {
        private HelloWorldPortType port;
        private CorrelationIDFactory corrFactory;
        private String prefix;
        private Throwable ex;

        public ClientRunnable(HelloWorldPortType port) {
            this.port = port;
        }

        public ClientRunnable(HelloWorldPortType port, String prefix) {
            this.port = port;
            this.prefix = prefix;
        }

        public ClientRunnable(HelloWorldPortType port, CorrelationIDFactory factory) {
            this.port = port;
            this.corrFactory = factory;
        }

        public Throwable getException() {
            return this.ex;
        }

        public void run() {
            try {
                InvocationHandler handler = Proxy.getInvocationHandler(this.port);
                BindingProvider bp = (BindingProvider)handler;
                Map requestContext = bp.getRequestContext();
                JMSMessageHeadersType requestHeader = new JMSMessageHeadersType();
                requestContext.put("org.apache.cxf.jms.client.request.headers", requestHeader);
                for (int idx = 0; idx < 5; ++idx) {
                    String request = "World" + (this.prefix != null ? ":" + this.prefix : "");
                    String correlationID = null;
                    if (this.corrFactory != null) {
                        correlationID = this.corrFactory.createCorrealtionID();
                        requestHeader.setJMSCorrelationID(correlationID);
                        request = request + ":" + correlationID;
                    }
                    String expected = "Hello " + request;
                    String response = this.port.greetMe(request);
                    Assert.assertEquals((String)"Response didn't match expected request", (Object)expected, (Object)response);
                    if (this.corrFactory == null) continue;
                    Map responseContext = bp.getResponseContext();
                    JMSMessageHeadersType responseHeader = (JMSMessageHeadersType)responseContext.get("org.apache.cxf.jms.client.response.headers");
                    Assert.assertEquals((String)"Request and Response CorrelationID didn't match", (Object)correlationID, (Object)responseHeader.getJMSCorrelationID());
                }
            }
            catch (Throwable e) {
                this.ex = e;
            }
        }
    }

    private static interface CorrelationIDFactory {
        public String createCorrealtionID();
    }
}

