/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms.continuations;

import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuation;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuationService;
import org.apache.cxf.systest.http_jetty.continuations.HelloWorker;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.systest.jms.continuations.Server2;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Before;
import org.junit.Test;

public class HelloWorldContinuationsClientServerTest
extends AbstractBusClientServerTestBase {
    private static boolean serversStarted;
    private static final String CONFIG_FILE = "org/apache/cxf/systest/jms/continuations/jms_test_config.xml";

    @Before
    public void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        HelloWorldContinuationsClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)HelloWorldContinuationsClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        HelloWorldContinuationsClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)HelloWorldContinuationsClientServerTest.launchServer(Server2.class, (boolean)false));
        serversStarted = true;
    }

    @Test
    public void testHttpWrappedContinuatuions() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus(CONFIG_FILE);
        BusFactory.setDefaultBus((Bus)bus);
        QName serviceName = new QName("http://cxf.apache.org/systest/jaxws", "HelloContinuationService");
        URL wsdlURL = ((Object)((Object)this)).getClass().getResource("/org/apache/cxf/systest/jms/continuations/test.wsdl");
        HelloContinuationService service = new HelloContinuationService(wsdlURL, serviceName);
        HelloWorldContinuationsClientServerTest.assertNotNull((Object)((Object)service));
        HelloContinuation helloPort = service.getHelloContinuationPort();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch helloDoneSignal = new CountDownLatch(5);
        executor.execute(new HelloWorker(helloPort, "Fred", "", startSignal, helloDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Barry", "Jameson", startSignal, helloDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Harry", "", startSignal, helloDoneSignal));
        executor.execute(new HelloWorker(helloPort, "Rob", "Davidson", startSignal, helloDoneSignal));
        executor.execute(new HelloWorker(helloPort, "James", "ServiceMix", startSignal, helloDoneSignal));
        startSignal.countDown();
        helloDoneSignal.await(60L, TimeUnit.SECONDS);
        executor.shutdownNow();
        HelloWorldContinuationsClientServerTest.assertEquals((String)"Not all invocations have completed", (Object)0, (Object)helloDoneSignal.getCount());
    }
}

