/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms.continuations;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuation;

@WebService(name="HelloContinuation", serviceName="HelloContinuationService", portName="HelloContinuationPort", targetNamespace="http://cxf.apache.org/systest/jaxws", endpointInterface="org.apache.cxf.systest.http_jetty.continuations.HelloContinuation", wsdlLocation="org/apache/cxf/systest/jms/continuations/test.wsdl")
public class HelloWorldWithContinuationsJMS
implements HelloContinuation {
    private Map<String, Continuation> suspended = new HashMap<String, Continuation>();
    private Executor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
    @Resource
    private WebServiceContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sayHi(String firstName, String secondName) {
        Continuation continuation = this.getContinuation(firstName);
        if (continuation == null) {
            throw new RuntimeException("Failed to get continuation");
        }
        Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (!continuation.isNew()) {
                if (!continuation.isResumed()) {
                    throw new RuntimeException("No timeout expected");
                }
                StringBuilder sb = new StringBuilder();
                sb.append(firstName);
                if (secondName != null && secondName.length() > 0) {
                    String surname = continuation.getObject().toString();
                    sb.append(' ').append(surname);
                }
                System.out.println("Saying hi to " + sb.toString());
                return "Hi " + sb.toString();
            }
            String userObject = secondName != null && secondName.length() > 0 ? secondName : null;
            continuation.setObject((Object)userObject);
            this.suspendInvocation(firstName, continuation);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestSuspended(String name) {
        Map<String, Continuation> map = this.suspended;
        synchronized (map) {
            while (!this.suspended.containsKey(name)) {
                try {
                    this.suspended.wait(1000L);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
        }
        System.out.println("Invocation for " + name + " has been suspended");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRequest(String name) {
        Continuation suspendedCont = null;
        Continuation continuation = this.suspended;
        synchronized (continuation) {
            suspendedCont = this.suspended.get(name);
        }
        if (suspendedCont != null) {
            continuation = suspendedCont;
            synchronized (continuation) {
                suspendedCont.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendInvocation(String name, Continuation cont) {
        Map<String, Continuation> map;
        System.out.println("Suspending invocation for " + name);
        try {
            cont.suspend(500000L);
            map = this.suspended;
        }
        catch (Throwable throwable) {
            Map<String, Continuation> map2 = this.suspended;
            synchronized (map2) {
                this.suspended.put(name, cont);
            }
            this.executor.execute(new Runnable(name){
                final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HelloWorldWithContinuationsJMS.this.resumeRequest(this.val$name);
                }
            });
            throw throwable;
        }
        synchronized (map) {
            this.suspended.put(name, cont);
        }
        this.executor.execute(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Continuation getContinuation(String name) {
        System.out.println("Getting continuation for " + name);
        Map<String, Continuation> map = this.suspended;
        synchronized (map) {
            Continuation suspendedCont = this.suspended.remove(name);
            if (suspendedCont != null) {
                return suspendedCont;
            }
        }
        ContinuationProvider provider = (ContinuationProvider)this.context.getMessageContext().get((Object)ContinuationProvider.class.getName());
        return provider.getContinuation();
    }
}

