/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms.continuations;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.hello_world_jms.HelloWorldPortType;
import org.apache.cxf.hello_world_jms.HelloWorldService;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.systest.jms.continuations.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Before;
import org.junit.Test;

public class JMSContinuationsClientServerTest
extends AbstractBusClientServerTestBase {
    protected static boolean serversStarted;

    @Before
    public void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        JMSContinuationsClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSContinuationsClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        JMSContinuationsClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSContinuationsClientServerTest.launchServer(Server.class, (boolean)false));
        serversStarted = true;
    }

    public URL getWSDLURL(String s) throws Exception {
        return ((Object)((Object)this)).getClass().getResource(s);
    }

    public QName getServiceName(QName q) {
        return q;
    }

    public QName getPortName(QName q) {
        return q;
    }

    @Test
    public void testContinuationWithTimeout() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldService"));
        QName portName = this.getPortName(new QName("http://cxf.apache.org/hello_world_jms", "HelloWorldPort"));
        URL wsdl = this.getWSDLURL("/org/apache/cxf/systest/jms/continuations/jms_test.wsdl");
        JMSContinuationsClientServerTest.assertNotNull((Object)wsdl);
        HelloWorldService service = new HelloWorldService(wsdl, serviceName);
        JMSContinuationsClientServerTest.assertNotNull((Object)service);
        HelloWorldPortType greeter = (HelloWorldPortType)service.getPort(portName, HelloWorldPortType.class);
        JMSContinuationsClientServerTest.assertEquals((Object)"Hi Fred Ruby", (Object)greeter.greetMe("Fred"));
    }
}

