/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jms.tx;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.systest.jms.tx.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_doc_lit.Greeter;
import org.apache.hello_world_doc_lit.PingMeFault;
import org.apache.hello_world_doc_lit.SOAPService2;
import org.junit.Before;
import org.junit.Test;

public class JMSTransactionClientServerTest
extends AbstractBusClientServerTestBase {
    protected static boolean serversStarted;

    @Before
    public void startServers() throws Exception {
        if (serversStarted) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        JMSTransactionClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSTransactionClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        JMSTransactionClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)JMSTransactionClientServerTest.launchServer(Server.class, (boolean)false));
        serversStarted = true;
    }

    public URL getWSDLURL(String s) throws Exception {
        return ((Object)((Object)this)).getClass().getResource(s);
    }

    public QName getServiceName(QName q) {
        return q;
    }

    public QName getPortName(QName q) {
        return q;
    }

    @Test
    public void testDocBasicConnection() throws Exception {
        QName serviceName = this.getServiceName(new QName("http://apache.org/hello_world_doc_lit", "SOAPService2"));
        QName portName = this.getPortName(new QName("http://apache.org/hello_world_doc_lit", "SoapPort2"));
        URL wsdl = this.getWSDLURL("/wsdl/hello_world_doc_lit.wsdl");
        JMSTransactionClientServerTest.assertNotNull((Object)wsdl);
        SOAPService2 service = new SOAPService2(wsdl, serviceName);
        JMSTransactionClientServerTest.assertNotNull((Object)service);
        String response1 = new String("Hello ");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            String greeting = greeter.greetMe("Good guy");
            JMSTransactionClientServerTest.assertNotNull((String)"No response received from service", (Object)greeting);
            String exResponse = response1 + "Good guy";
            JMSTransactionClientServerTest.assertEquals((String)"Get unexcpeted result", (Object)exResponse, (Object)greeting);
            greeting = greeter.greetMe("Bad guy");
            JMSTransactionClientServerTest.assertNotNull((String)"No response received from service", (Object)greeting);
            exResponse = response1 + "[Bad guy]";
            JMSTransactionClientServerTest.assertEquals((String)"Get unexcpeted result", (Object)exResponse, (Object)greeting);
            try {
                greeter.pingMe();
                JMSTransactionClientServerTest.fail((String)"Should have thrown FaultException");
            }
            catch (PingMeFault ex) {
                JMSTransactionClientServerTest.assertNotNull((Object)ex.getFaultInfo());
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }
}

