/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.lifecycle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.greeter_control.ControlImpl;
import org.apache.cxf.systest.ws.addressing.GreeterImpl;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleTest
extends Assert {
    private static final int RECURSIVE_LIMIT = 3;
    private static final String[] ADDRESSES = new String[]{"http://localhost:9056/SoapContext/SoapPort", "http://localhost:9057/SoapContext/SoapPort", "http://localhost:9058/SoapContext/SoapPort", "http://localhost:9059/SoapContext/SoapPort"};
    private static final String CONFIG = "org/apache/cxf/systest/lifecycle/cxf.xml";
    private Bus bus;
    private ServerLifeCycleManager manager;
    private int recursiveCount;
    private javax.xml.ws.Endpoint[] recursiveEndpoints;
    private Map<String, Integer> startNotificationMap;
    private Map<String, Integer> stopNotificationMap;

    @Before
    public void setUp() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus(CONFIG);
        BusFactory.setDefaultBus((Bus)this.bus);
        this.manager = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
        this.recursiveCount = 0;
        this.recursiveEndpoints = new javax.xml.ws.Endpoint[3];
        this.startNotificationMap = new HashMap<String, Integer>();
        this.stopNotificationMap = new HashMap<String, Integer>();
    }

    @After
    public void tearDown() throws Exception {
        this.bus.shutdown(true);
    }

    @Test
    public void testRecursive() {
        LifeCycleTest.assertNotNull((String)"unexpected non-null ServerLifeCycleManager", (Object)this.manager);
        this.manager.registerListener(new ServerLifeCycleListener(){

            public void startServer(Server server) {
                String address = server.getEndpoint().getEndpointInfo().getAddress();
                LifeCycleTest.this.verifyNotification(LifeCycleTest.this.startNotificationMap, address, 0);
                LifeCycleTest.this.updateMap(LifeCycleTest.this.startNotificationMap, address);
                if (LifeCycleTest.this.recursiveCount < 3) {
                    ((LifeCycleTest)LifeCycleTest.this).recursiveEndpoints[((LifeCycleTest)LifeCycleTest.this).recursiveCount++] = javax.xml.ws.Endpoint.publish((String)ADDRESSES[LifeCycleTest.this.recursiveCount], (Object)new GreeterImpl());
                }
            }

            public void stopServer(Server server) {
                String address = server.getEndpoint().getEndpointInfo().getAddress();
                LifeCycleTest.this.verifyNotification(LifeCycleTest.this.stopNotificationMap, address, 0);
                LifeCycleTest.this.updateMap(LifeCycleTest.this.stopNotificationMap, address);
                if (LifeCycleTest.this.recursiveCount > 0) {
                    LifeCycleTest.this.recursiveEndpoints[--LifeCycleTest.this.recursiveCount].stop();
                }
            }
        });
        javax.xml.ws.Endpoint.publish((String)ADDRESSES[0], (Object)new GreeterImpl()).stop();
        for (int i = 0; i < ADDRESSES.length; ++i) {
            this.verifyNotification(this.startNotificationMap, ADDRESSES[i], 1);
            this.verifyNotification(this.stopNotificationMap, ADDRESSES[i], 1);
        }
    }

    @Test
    public void testGetActiveFeatures() {
        LifeCycleTest.assertNotNull((String)"unexpected non-null ServerLifeCycleManager", (Object)this.manager);
        this.manager.registerListener(new ServerLifeCycleListener(){

            public void startServer(Server server) {
                Endpoint endpoint = server.getEndpoint();
                LifeCycleTest.this.updateMap(LifeCycleTest.this.startNotificationMap, endpoint.getEndpointInfo().getAddress());
                String portName = endpoint.getEndpointInfo().getName().getLocalPart();
                if ("SoapPort".equals(portName)) {
                    List active = endpoint.getActiveFeatures();
                    Assert.assertNotNull((Object)active);
                    Assert.assertEquals((Object)1, (Object)active.size());
                    Assert.assertTrue((boolean)(active.get(0) instanceof WSAddressingFeature));
                    Assert.assertSame(active.get(0), (Object)AbstractFeature.getActive((List)active, WSAddressingFeature.class));
                } else {
                    List active = endpoint.getActiveFeatures();
                    Assert.assertNotNull((Object)active);
                    Assert.assertEquals((Object)0, (Object)active.size());
                    Assert.assertNull((Object)AbstractFeature.getActive((List)active, WSAddressingFeature.class));
                }
            }

            public void stopServer(Server server) {
                LifeCycleTest.this.updateMap(LifeCycleTest.this.stopNotificationMap, server.getEndpoint().getEndpointInfo().getAddress());
            }
        });
        javax.xml.ws.Endpoint greeter = javax.xml.ws.Endpoint.publish((String)ADDRESSES[0], (Object)new GreeterImpl());
        javax.xml.ws.Endpoint control = javax.xml.ws.Endpoint.publish((String)ADDRESSES[1], (Object)new ControlImpl());
        greeter.stop();
        control.stop();
        for (int i = 0; i < 2; ++i) {
            this.verifyNotification(this.startNotificationMap, ADDRESSES[0], 1);
            this.verifyNotification(this.stopNotificationMap, ADDRESSES[0], 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNotification(Map<String, Integer> notificationMap, String address, int expected) {
        Map<String, Integer> map = notificationMap;
        synchronized (map) {
            Integer count = notificationMap.get(address);
            if (expected == 0) {
                LifeCycleTest.assertNull((String)("unexpected prior notification for: " + address), (Object)count);
            } else {
                LifeCycleTest.assertEquals((String)("unexpected prior notification for: " + address), (Object)expected, (Object)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMap(Map<String, Integer> notificationMap, String address) {
        Map<String, Integer> map = notificationMap;
        synchronized (map) {
            Integer count = notificationMap.get(address);
            if (count != null) {
                notificationMap.put(address, new Integer(count + 1));
            } else {
                notificationMap.put(address, new Integer(1));
            }
        }
    }
}

