/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.mtom;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.binding.soap.SOAPBindingImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.mime.TestMtom;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.jms.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.systest.mtom.ClientMtomXopTest;
import org.apache.cxf.systest.mtom.ServerWithJMS;
import org.apache.cxf.systest.mtom.TestAttachmentOutInterceptor;
import org.apache.cxf.systest.mtom.TestMultipartMessageInterceptor;
import org.apache.cxf.test.TestUtilities;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientMtomXopWithJMSTest
extends AbstractBusClientServerTestBase {
    public static final QName MTOM_PORT = new QName("http://cxf.apache.org/mime", "TestMtomJMSPort");
    public static final QName MTOM_SERVICE = new QName("http://cxf.apache.org/mime", "TestMtomJMSService");

    @BeforeClass
    public static void startServers() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("activemq.store.dir") != null) {
            props.put("activemq.store.dir", System.getProperty("activemq.store.dir"));
        }
        props.put("java.util.logging.config.file", System.getProperty("java.util.logging.config.file"));
        ClientMtomXopWithJMSTest.assertTrue((String)"server did not launch correctly", (boolean)ClientMtomXopWithJMSTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        TestUtilities.setKeepAliveSystemProperty((boolean)false);
        ClientMtomXopWithJMSTest.assertTrue((String)"server did not launch correctly", (boolean)ClientMtomXopWithJMSTest.launchServer(ServerWithJMS.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() {
        TestUtilities.recoverKeepAliveSystemProperty();
    }

    @Test
    public void testMtomXop() throws Exception {
        TestMtom mtomPort = ClientMtomXopWithJMSTest.createPort(MTOM_SERVICE, MTOM_PORT, TestMtom.class, true);
        try {
            InputStream pre = ((Object)((Object)this)).getClass().getResourceAsStream("/wsdl/mtom_xop.wsdl");
            int fileSize = 0;
            int i = pre.read();
            while (i != -1) {
                ++fileSize;
                i = pre.read();
            }
            Holder param = new Holder();
            int count = 50;
            byte[] data = new byte[fileSize * count];
            for (int x = 0; x < count; ++x) {
                ((Object)((Object)this)).getClass().getResourceAsStream("/wsdl/mtom_xop.wsdl").read(data, fileSize * x, fileSize);
            }
            param.value = new DataHandler((DataSource)new ByteArrayDataSource(data, "application/octet-stream"));
            Holder name = new Holder((Object)"call detail");
            mtomPort.testXop(name, param);
            ClientMtomXopWithJMSTest.assertEquals((String)"name unchanged", (Object)"return detail + call detail", (Object)name.value);
            ClientMtomXopWithJMSTest.assertNotNull((Object)param.value);
            ((DataHandler)param.value).getInputStream().close();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    private static <T> T createPort(QName serviceName, QName portName, Class<T> serviceEndpointInterface, boolean enableMTOM) throws Exception {
        Bus bus = BusFactory.getDefaultBus();
        JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();
        serviceFactory.setBus(bus);
        serviceFactory.setServiceName(serviceName);
        serviceFactory.setServiceClass(serviceEndpointInterface);
        serviceFactory.setWsdlURL(ClientMtomXopTest.class.getResource("/wsdl/mtom_xop.wsdl"));
        Service service = serviceFactory.create();
        EndpointInfo ei = service.getEndpointInfo(portName);
        JaxWsEndpointImpl jaxwsEndpoint = new JaxWsEndpointImpl(bus, service, ei);
        SOAPBindingImpl jaxWsSoapBinding = new SOAPBindingImpl(ei.getBinding());
        jaxWsSoapBinding.setMTOMEnabled(enableMTOM);
        jaxwsEndpoint.getBinding().getInInterceptors().add(new TestMultipartMessageInterceptor());
        jaxwsEndpoint.getBinding().getOutInterceptors().add(new TestAttachmentOutInterceptor());
        ClientImpl client = new ClientImpl(bus, (Endpoint)jaxwsEndpoint);
        JaxWsClientProxy ih = new JaxWsClientProxy((Client)client, jaxwsEndpoint.getJaxwsBinding());
        Object obj = Proxy.newProxyInstance(serviceEndpointInterface.getClassLoader(), new Class[]{serviceEndpointInterface, BindingProvider.class}, (InvocationHandler)ih);
        return serviceEndpointInterface.cast(obj);
    }
}

