/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.mtom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.mtom.EchoService;
import org.apache.cxf.test.AbstractCXFTest;
import org.apache.cxf.test.TestUtilities;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.ws.policy.selector.FirstAlternativeSelector;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MtomPolicyTest
extends AbstractCXFTest {
    String address = "http://localhost:9036/EchoService";

    @BeforeClass
    public static void setKeepAliveProperty() {
        TestUtilities.setKeepAliveSystemProperty((boolean)false);
    }

    @AfterClass
    public static void cleanKeepAliveProperty() {
        TestUtilities.recoverKeepAliveSystemProperty();
    }

    @Test
    public void testRequiredMtom() throws Exception {
        this.setupServer(true);
        this.sendMtomMessage(this.address);
        Node res = this.invoke(this.address, "http://schemas.xmlsoap.org/soap/http", "nonmtom.xml");
        NodeList list = this.assertValid("//faultstring", res);
        String text = list.item(0).getTextContent();
        MtomPolicyTest.assertTrue((boolean)text.contains("These policy alternatives can not be satisfied: "));
        MtomPolicyTest.assertTrue((boolean)text.contains("{http://schemas.xmlsoap.org/ws/2004/09/policy/optimizedmimeserialization}OptimizedMimeSerialization"));
    }

    @Test
    public void testOptionalMtom() throws Exception {
        this.setupServer(false);
        this.sendMtomMessage(this.address);
        Node res = this.invoke(this.address, "http://schemas.xmlsoap.org/soap/http", "nonmtom.xml");
        this.assertNoFault(res);
    }

    public void setupServer(boolean mtomRequired) throws Exception {
        ((PolicyEngine)this.getBus().getExtension(PolicyEngine.class)).setAlternativeSelector((AlternativeSelector)new FirstAlternativeSelector());
        JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setServiceBean((Object)new EchoService());
        sf.setBus(this.getBus());
        sf.setAddress(this.address);
        WSPolicyFeature policyFeature = new WSPolicyFeature();
        ArrayList<Element> policyElements = new ArrayList<Element>();
        if (mtomRequired) {
            policyElements.add(DOMUtils.readXml((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("mtom-policy.xml")).getDocumentElement());
        } else {
            policyElements.add(DOMUtils.readXml((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("mtom-policy-optional.xml")).getDocumentElement());
            ((PolicyConstants)this.getBus().getExtension(PolicyConstants.class)).setNamespace("http://www.w3.org/2006/07/ws-policy");
        }
        policyFeature.setPolicyElements(policyElements);
        sf.getFeatures().add(policyFeature);
        sf.create();
    }

    private void sendMtomMessage(String a) throws Exception {
        EndpointInfo ei = new EndpointInfo(null, "http://schemas.xmlsoap.org/wsdl/http");
        ei.setAddress(a);
        ConduitInitiatorManager conduitMgr = (ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class);
        ConduitInitiator conduitInit = conduitMgr.getConduitInitiator("http://schemas.xmlsoap.org/soap/http");
        Conduit conduit = conduitInit.getConduit(ei);
        AbstractCXFTest.TestMessageObserver obs = new AbstractCXFTest.TestMessageObserver();
        conduit.setMessageObserver((MessageObserver)obs);
        MessageImpl m = new MessageImpl();
        String ct = "multipart/related; type=\"application/xop+xml\"; start=\"<soap.xml@xfire.codehaus.org>\"; start-info=\"text/xml; charset=utf-8\"; boundary=\"----=_Part_4_701508.1145579811786\"";
        m.put((Object)"Content-Type", (Object)ct);
        conduit.prepare((Message)m);
        OutputStream os = (OutputStream)m.getContent(OutputStream.class);
        InputStream is = this.getResourceAsStream("request");
        if (is == null) {
            throw new RuntimeException("Could not find resource request");
        }
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        is.close();
        os.close();
        byte[] res = obs.getResponseStream().toByteArray();
        MessageImpl resMsg = new MessageImpl();
        resMsg.setContent(InputStream.class, (Object)new ByteArrayInputStream(res));
        resMsg.put((Object)"Content-Type", (Object)obs.getResponseContentType());
        resMsg.setExchange((Exchange)new ExchangeImpl());
        AttachmentDeserializer deserializer = new AttachmentDeserializer((Message)resMsg);
        deserializer.initializeAttachments();
        Collection attachments = resMsg.getAttachments();
        MtomPolicyTest.assertNotNull((Object)attachments);
        MtomPolicyTest.assertEquals((Object)1, (Object)attachments.size());
        Attachment inAtt = (Attachment)attachments.iterator().next();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inAtt.getDataHandler().getInputStream(), (OutputStream)out);
        out.close();
        MtomPolicyTest.assertEquals((Object)37448, (Object)out.size());
    }

    protected Bus createBus() throws BusException {
        return BusFactory.getDefaultBus();
    }
}

