/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.mtom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.mtom.EchoService;
import org.apache.cxf.test.AbstractCXFTest;
import org.apache.cxf.test.TestUtilities;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class MtomServerTest
extends AbstractCXFTest {
    private static final String HTTP_ID = "http://schemas.xmlsoap.org/wsdl/http/";

    @BeforeClass
    public static void setKeepAliveProperty() {
        TestUtilities.setKeepAliveSystemProperty((boolean)false);
    }

    @AfterClass
    public static void cleanKeepAliveProperty() {
        TestUtilities.recoverKeepAliveSystemProperty();
    }

    @Test
    public void testMtomRequest() throws Exception {
        JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setServiceBean((Object)new EchoService());
        sf.setBus(this.getBus());
        String address = "http://localhost:9036/EchoService";
        sf.setAddress(address);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("mtom-enabled", "true");
        sf.setProperties(props);
        sf.create();
        EndpointInfo ei = new EndpointInfo(null, HTTP_ID);
        ei.setAddress(address);
        ConduitInitiatorManager conduitMgr = (ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class);
        ConduitInitiator conduitInit = conduitMgr.getConduitInitiator("http://schemas.xmlsoap.org/soap/http");
        Conduit conduit = conduitInit.getConduit(ei);
        AbstractCXFTest.TestMessageObserver obs = new AbstractCXFTest.TestMessageObserver();
        conduit.setMessageObserver((MessageObserver)obs);
        MessageImpl m = new MessageImpl();
        String ct = "multipart/related; type=\"application/xop+xml\"; start=\"<soap.xml@xfire.codehaus.org>\"; start-info=\"text/xml\"; boundary=\"----=_Part_4_701508.1145579811786\"";
        m.put((Object)"Content-Type", (Object)ct);
        conduit.prepare((Message)m);
        OutputStream os = (OutputStream)m.getContent(OutputStream.class);
        InputStream is = this.getResourceAsStream("request");
        if (is == null) {
            throw new RuntimeException("Could not find resource request");
        }
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        is.close();
        os.close();
        byte[] res = obs.getResponseStream().toByteArray();
        MessageImpl resMsg = new MessageImpl();
        resMsg.setContent(InputStream.class, (Object)new ByteArrayInputStream(res));
        resMsg.put((Object)"Content-Type", (Object)obs.getResponseContentType());
        resMsg.setExchange((Exchange)new ExchangeImpl());
        AttachmentDeserializer deserializer = new AttachmentDeserializer((Message)resMsg);
        deserializer.initializeAttachments();
        Collection attachments = resMsg.getAttachments();
        MtomServerTest.assertNotNull((Object)attachments);
        MtomServerTest.assertEquals((Object)1, (Object)attachments.size());
        Attachment inAtt = (Attachment)attachments.iterator().next();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inAtt.getDataHandler().getInputStream(), (OutputStream)out);
        out.close();
        MtomServerTest.assertEquals((Object)37448, (Object)out.size());
    }

    @Test
    public void testURLBasedAttachment() throws Exception {
        JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setServiceBean((Object)new EchoService());
        sf.setBus(this.getBus());
        String address = "http://localhost:9036/EchoService";
        sf.setAddress(address);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("mtom-enabled", "true");
        sf.setProperties(props);
        Server server = sf.create();
        server.getEndpoint().getService().getDataBinding().setMtomThreshold(0);
        this.servStatic(((Object)((Object)this)).getClass().getResource("mtom-policy.xml"), "http://localhost:9036/policy.xsd");
        EndpointInfo ei = new EndpointInfo(null, HTTP_ID);
        ei.setAddress(address);
        ConduitInitiatorManager conduitMgr = (ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class);
        ConduitInitiator conduitInit = conduitMgr.getConduitInitiator("http://schemas.xmlsoap.org/soap/http");
        Conduit conduit = conduitInit.getConduit(ei);
        AbstractCXFTest.TestMessageObserver obs = new AbstractCXFTest.TestMessageObserver();
        conduit.setMessageObserver((MessageObserver)obs);
        MessageImpl m = new MessageImpl();
        String ct = "multipart/related; type=\"application/xop+xml\"; start=\"<soap.xml@xfire.codehaus.org>\"; start-info=\"text/xml; charset=utf-8\"; boundary=\"----=_Part_4_701508.1145579811786\"";
        m.put((Object)"Content-Type", (Object)ct);
        conduit.prepare((Message)m);
        OutputStream os = (OutputStream)m.getContent(OutputStream.class);
        InputStream is = this.getResourceAsStream("request-url-attachment");
        if (is == null) {
            throw new RuntimeException("Could not find resource request");
        }
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        is.close();
        os.close();
        byte[] res = obs.getResponseStream().toByteArray();
        MessageImpl resMsg = new MessageImpl();
        resMsg.setContent(InputStream.class, (Object)new ByteArrayInputStream(res));
        resMsg.put((Object)"Content-Type", (Object)obs.getResponseContentType());
        resMsg.setExchange((Exchange)new ExchangeImpl());
        AttachmentDeserializer deserializer = new AttachmentDeserializer((Message)resMsg);
        deserializer.initializeAttachments();
        Collection attachments = resMsg.getAttachments();
        MtomServerTest.assertNotNull((Object)attachments);
        MtomServerTest.assertEquals((Object)1, (Object)attachments.size());
        Attachment inAtt = (Attachment)attachments.iterator().next();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inAtt.getDataHandler().getInputStream(), (OutputStream)out);
        out.close();
        MtomServerTest.assertTrue((String)("Wrong size: " + out.size() + "\n" + out.toString()), (out.size() > 970 && out.size() < 1020 ? 1 : 0) != 0);
        this.unregisterServStatic("http://localhost:9036/policy.xsd");
    }

    private void unregisterServStatic(String add) throws Exception {
        Bus bus = this.getBus();
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(add);
        Destination d = df.getDestination(ei);
        d.setMessageObserver(null);
    }

    protected Bus createBus() throws BusException {
        return BusFactory.getDefaultBus();
    }

    private void servStatic(final URL resource, String add) throws Exception {
        Bus bus = this.getBus();
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(add);
        Destination d = df.getDestination(ei);
        d.setMessageObserver(new MessageObserver(){

            public void onMessage(Message message) {
                try {
                    ExchangeImpl ex = new ExchangeImpl();
                    ex.setInMessage(message);
                    Conduit backChannel = message.getDestination().getBackChannel(message, null, null);
                    MessageImpl res = new MessageImpl();
                    res.put((Object)"Content-Type", (Object)"text/xml");
                    backChannel.prepare((Message)res);
                    OutputStream out = (OutputStream)res.getContent(OutputStream.class);
                    InputStream is = resource.openStream();
                    IOUtils.copy((InputStream)is, (OutputStream)out, (int)2048);
                    out.flush();
                    out.close();
                    is.close();
                    backChannel.close((Message)res);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

