/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.mtom_bindingtype;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.mtom_bindingtype.Server;
import org.apache.cxf.systest.mtom_feature.Hello;
import org.apache.cxf.systest.mtom_feature.HelloService;
import org.apache.cxf.systest.mtom_feature.ImageHelper;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class MTOMBindingTypeTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/cxf/systest/mtom_feature", "HelloService");

    @Before
    public void setUp() throws Exception {
        this.createBus();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        MTOMBindingTypeTest.assertTrue((String)"server did not launch correctly", (boolean)MTOMBindingTypeTest.launchServer(Server.class, (boolean)true));
    }

    protected ByteArrayOutputStream setupInLogging() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bos, true);
        LoggingInInterceptor in = new LoggingInInterceptor(writer);
        this.bus.getInInterceptors().add(in);
        return bos;
    }

    protected ByteArrayOutputStream setupOutLogging() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bos, true);
        LoggingOutInterceptor out = new LoggingOutInterceptor(writer);
        this.bus.getOutInterceptors().add(out);
        return bos;
    }

    @Test
    public void testDetail() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        Holder photo = new Holder((Object)"CXF".getBytes());
        Holder image = new Holder((Object)this.getImage("/java.jpg"));
        Hello port = this.getPort();
        SOAPBinding binding = (SOAPBinding)((BindingProvider)port).getBinding();
        binding.setMTOMEnabled(true);
        port.detail((Holder<byte[]>)photo, (Holder<Image>)image);
        String expected = "<xop:Include xmlns:xop=";
        MTOMBindingTypeTest.assertTrue((output.toString().indexOf(expected) != -1 ? 1 : 0) != 0);
        MTOMBindingTypeTest.assertTrue((input.toString().indexOf(expected) != -1 ? 1 : 0) != 0);
        MTOMBindingTypeTest.assertEquals((Object)"CXF", (Object)new String((byte[])photo.value));
        MTOMBindingTypeTest.assertNotNull((Object)image.value);
    }

    @Test
    @Ignore
    public void testEcho() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        byte[] bytes = ImageHelper.getImageBytes(this.getImage("/java.jpg"), "image/jpeg");
        Holder image = new Holder((Object)bytes);
        Hello port = this.getPort();
        SOAPBinding binding = (SOAPBinding)((BindingProvider)port).getBinding();
        binding.setMTOMEnabled(true);
        port.echoData((Holder<byte[]>)image);
        MTOMBindingTypeTest.assertNotNull((Object)image);
    }

    private Image getImage(String name) throws Exception {
        return ImageIO.read(((Object)((Object)this)).getClass().getResource(name));
    }

    private Hello getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/mtom.wsdl");
        MTOMBindingTypeTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        HelloService service = new HelloService(wsdl, this.serviceName);
        MTOMBindingTypeTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getHelloPort();
    }
}

