/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.mtom_feature;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public final class ImageHelper {
    private ImageHelper() {
    }

    public static byte[] getImageBytes(Image image, String type) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedImage bufImage = ImageHelper.convertToBufferedImage(image);
        ImageWriter writer = null;
        Iterator<ImageWriter> i = ImageIO.getImageWritersByMIMEType(type);
        if (i.hasNext()) {
            writer = i.next();
        }
        if (writer != null) {
            ImageOutputStream stream = null;
            stream = ImageIO.createImageOutputStream(baos);
            writer.setOutput(stream);
            writer.write(bufImage);
            stream.close();
            return baos.toByteArray();
        }
        return null;
    }

    private static BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(null);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        return bufImage;
    }
}

