/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.mtom_feature;

import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.systest.mtom_feature.Hello;
import org.apache.cxf.systest.mtom_feature.HelloImpl;
import org.apache.cxf.systest.mtom_feature.HelloService;
import org.apache.cxf.systest.mtom_feature.ImageHelper;
import org.apache.cxf.systest.mtom_feature.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.local.LocalConduit;
import org.junit.BeforeClass;
import org.junit.Test;

public class MtomFeatureClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/cxf/systest/mtom_feature", "HelloService");
    private Hello port = this.getPort();

    @BeforeClass
    public static void startServers() throws Exception {
        MtomFeatureClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)MtomFeatureClientServerTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testDetail() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        Holder photo = new Holder((Object)"CXF".getBytes());
        Holder image = new Holder((Object)this.getImage("/java.jpg"));
        this.port.detail((Holder<byte[]>)photo, (Holder<Image>)image);
        MtomFeatureClientServerTest.assertEquals((Object)"CXF", (Object)new String((byte[])photo.value));
        MtomFeatureClientServerTest.assertNotNull((Object)image.value);
    }

    @Test
    public void testEcho() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        byte[] bytes = ImageHelper.getImageBytes(this.getImage("/java.jpg"), "image/jpeg");
        Holder image = new Holder((Object)bytes);
        this.port.echoData((Holder<byte[]>)image);
        MtomFeatureClientServerTest.assertNotNull((Object)image);
    }

    @Test
    public void testWithLocalTransport() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        HelloImpl implementor = new HelloImpl();
        String address = "local://Hello";
        Endpoint.publish((String)address, (Object)implementor);
        QName portName = new QName("http://apache.org/cxf/systest/mtom_feature", "HelloPort");
        Service service = Service.create((QName)this.serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/soap/", "local://Hello");
        this.port = (Hello)service.getPort(portName, Hello.class, new WebServiceFeature[]{new MTOMFeature()});
        ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        ((BindingProvider)this.port).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, Boolean.TRUE);
        Holder photo = new Holder((Object)"CXF".getBytes());
        Holder image = new Holder((Object)this.getImage("/java.jpg"));
        this.port.detail((Holder<byte[]>)photo, (Holder<Image>)image);
        MtomFeatureClientServerTest.assertEquals((Object)"CXF", (Object)new String((byte[])photo.value));
        MtomFeatureClientServerTest.assertNotNull((Object)image.value);
        ((BindingProvider)this.port).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, Boolean.FALSE);
        photo = new Holder((Object)"CXF".getBytes());
        image = new Holder((Object)this.getImage("/java.jpg"));
        this.port.detail((Holder<byte[]>)photo, (Holder<Image>)image);
        MtomFeatureClientServerTest.assertEquals((Object)"CXF", (Object)new String((byte[])photo.value));
        MtomFeatureClientServerTest.assertNotNull((Object)image.value);
    }

    private Image getImage(String name) throws Exception {
        return ImageIO.read(((Object)((Object)this)).getClass().getResource(name));
    }

    private Hello getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/mtom.wsdl");
        MtomFeatureClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        HelloService service = new HelloService(wsdl, this.serviceName);
        MtomFeatureClientServerTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getHelloPort(new WebServiceFeature[]{new MTOMFeature()});
    }
}

