/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.nested_callback;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.systest.nested_callback.CallbackImpl;
import org.apache.cxf.systest.nested_callback.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.nested_callback.NestedCallback;
import org.apache.nested_callback.SOAPService;
import org.apache.nested_callback.ServerPortType;
import org.junit.BeforeClass;
import org.junit.Test;

public class CallbackClientServerTest
extends AbstractBusClientServerTestBase {
    private static final QName SERVICE_NAME = new QName("http://apache.org/nested_callback", "SOAPService");
    private static final QName SERVICE_NAME_CALLBACK = new QName("http://apache.org/nested_callback", "CallbackService");
    private static final QName PORT_NAME = new QName("http://apache.org/nested_callback", "SOAPPort");
    private static final QName PORT_NAME_CALLBACK = new QName("http://apache.org/nested_callback", "CallbackPort");
    private static final QName PORT_TYPE_CALLBACK = new QName("http://apache.org/nested_callback", "CallbackPortType");

    @BeforeClass
    public static void startServers() throws Exception {
        CallbackClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)CallbackClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testCallback() throws Exception {
        CallbackImpl implementor = new CallbackImpl();
        String address = "http://localhost:9005/CallbackContext/NestedCallbackPort";
        Endpoint.publish((String)address, (Object)implementor);
        URL wsdlURL = ((Object)((Object)this)).getClass().getResource("/wsdl/nested_callback.wsdl");
        SOAPService ss = new SOAPService(wsdlURL, SERVICE_NAME);
        ServerPortType port = (ServerPortType)ss.getPort(PORT_NAME, ServerPortType.class);
        EndpointReferenceType ref = null;
        try {
            ref = EndpointReferenceUtils.getEndpointReference((URL)wsdlURL, (QName)SERVICE_NAME_CALLBACK, (String)PORT_NAME_CALLBACK.getLocalPart());
            EndpointReferenceUtils.setInterfaceName((EndpointReferenceType)ref, (QName)PORT_TYPE_CALLBACK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NestedCallback callbackObject = new NestedCallback();
        Source source = EndpointReferenceUtils.convertToXML((EndpointReferenceType)ref);
        W3CEndpointReference w3cEpr = new W3CEndpointReference(source);
        callbackObject.setCallback(w3cEpr);
        String resp = port.registerCallback(callbackObject);
        CallbackClientServerTest.assertEquals((Object)"registerCallback called", (Object)resp);
    }
}

