/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.outofband.header;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.outofband.header.ObjectFactory;
import org.apache.cxf.outofband.header.OutofBandHeader;
import org.apache.cxf.systest.outofband.header.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_doc_lit_bare.PutLastTradedPricePortType;
import org.apache.hello_world_doc_lit_bare.SOAPService;
import org.apache.hello_world_doc_lit_bare.types.TradePriceData;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Node;

public class OOBHeaderTest
extends AbstractBusClientServerTestBase {
    public static final String CONFIG_FILE = "org/apache/cxf/systest/outofband/header/cxf.xml";
    public static final String TEST_HDR_NS = "http://cxf.apache.org/outofband/Header";
    public static final String TEST_HDR_REQUEST_ELEM = "outofbandHeader";
    public static final String TEST_HDR_RESPONSE_ELEM = "outofbandHeader";
    private final QName serviceName = new QName("http://apache.org/hello_world_doc_lit_bare", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_doc_lit_bare", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        System.setProperty("org.apache.cxf.bus.factory", "org.apache.cxf.bus.CXFBusFactory");
        System.setProperty("cxf.config.file", CONFIG_FILE);
        defaultConfigFileName = CONFIG_FILE;
        SpringBusFactory bf = new SpringBusFactory();
        staticBus = bf.createBus(defaultConfigFileName);
        BusFactory.setDefaultBus((Bus)staticBus);
        OOBHeaderTest.assertTrue((String)"server did not launch correctly", (boolean)OOBHeaderTest.launchServer(Server.class, (boolean)true));
    }

    private void addOutOfBoundHeader(PutLastTradedPricePortType portType, boolean invalid) {
        InvocationHandler handler = Proxy.getInvocationHandler(portType);
        BindingProvider bp = null;
        try {
            if (handler instanceof BindingProvider) {
                bp = (BindingProvider)handler;
                Map requestContext = bp.getRequestContext();
                OutofBandHeader ob = new OutofBandHeader();
                ob.setName("testOobHeader");
                ob.setValue("testOobHeaderValue");
                ob.setHdrAttribute(invalid ? "dontProcess" : "testHdrAttribute");
                SoapHeader hdr = new SoapHeader(new QName(TEST_HDR_NS, "outofbandHeader"), (Object)ob, (DataBinding)new JAXBDataBinding(new Class[]{ob.getClass()}));
                hdr.setMustUnderstand(true);
                ArrayList<SoapHeader> holder = new ArrayList<SoapHeader>();
                holder.add(hdr);
                requestContext.put(Header.HEADER_LIST, holder);
            }
        }
        catch (JAXBException ex) {
            // empty catch block
        }
    }

    private void checkReturnedOOBHeader(PutLastTradedPricePortType portType) {
        InvocationHandler handler = Proxy.getInvocationHandler(portType);
        BindingProvider bp = null;
        if (handler instanceof BindingProvider) {
            bp = (BindingProvider)handler;
            Map responseContext = bp.getResponseContext();
            OutofBandHeader hdrToTest = null;
            List oobHdr = (List)responseContext.get(Header.HEADER_LIST);
            if (oobHdr == null) {
                OOBHeaderTest.fail((String)"Should have got List of out-of-band headers ..");
            }
            OOBHeaderTest.assertTrue((String)("HeaderHolder list expected to conain 1 object received " + oobHdr.size()), (oobHdr.size() == 1 ? 1 : 0) != 0);
            if (oobHdr != null & oobHdr instanceof List) {
                for (Object hdr : oobHdr) {
                    Header hdr1;
                    if (!(hdr instanceof Header) || !((hdr1 = (Header)hdr).getObject() instanceof Node)) continue;
                    try {
                        JAXBElement job = (JAXBElement)JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}).createUnmarshaller().unmarshal((Node)hdr1.getObject());
                        hdrToTest = (OutofBandHeader)job.getValue();
                    }
                    catch (JAXBException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            OOBHeaderTest.assertNotNull((String)"out-of-band header should not be null", hdrToTest);
            OOBHeaderTest.assertTrue((String)("Expected out-of-band Header name testOobReturnHeaderName recevied :" + hdrToTest.getName()), (boolean)"testOobReturnHeaderName".equals(hdrToTest.getName()));
            OOBHeaderTest.assertTrue((String)("Expected out-of-band Header value testOobReturnHeaderValue recevied :" + hdrToTest.getValue()), (boolean)"testOobReturnHeaderValue".equals(hdrToTest.getValue()));
            OOBHeaderTest.assertTrue((String)("Expected out-of-band Header attribute testReturnHdrAttribute recevied :" + hdrToTest.getHdrAttribute()), (boolean)"testReturnHdrAttribute".equals(hdrToTest.getHdrAttribute()));
        }
    }

    @Test
    public void testBasicConnection() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/doc_lit_bare.wsdl");
        OOBHeaderTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        OOBHeaderTest.assertNotNull((String)"Service is null", (Object)service);
        PutLastTradedPricePortType putLastTradedPrice = (PutLastTradedPricePortType)service.getPort(this.portName, PutLastTradedPricePortType.class);
        TradePriceData priceData = new TradePriceData();
        priceData.setTickerPrice(1.0f);
        priceData.setTickerSymbol("CELTIX");
        Holder holder = new Holder((Object)priceData);
        this.addOutOfBoundHeader(putLastTradedPrice, false);
        putLastTradedPrice.sayHi(holder);
        this.checkReturnedOOBHeader(putLastTradedPrice);
        this.addOutOfBoundHeader(putLastTradedPrice, true);
        try {
            putLastTradedPrice.sayHi(holder);
            OOBHeaderTest.fail((String)"mustUnderstand header should not have been processed");
        }
        catch (Exception ex) {
            OOBHeaderTest.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("MustUnderstand"));
        }
    }
}

