/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.systest.provider.AttachmentServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentProviderXMLClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        AttachmentProviderXMLClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)AttachmentProviderXMLClientServerTest.launchServer(AttachmentServer.class, (boolean)true));
    }

    @Test
    public void testRequestWithAttachment() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:9033/XMLServiceAttachment").openConnection();
        connection.setRequestMethod("POST");
        String ct = "multipart/related; type=\"text/xml\"; start=\"rootPart\"; boundary=\"----=_Part_4_701508.1145579811786\"";
        connection.addRequestProperty("Content-Type", ct);
        connection.setDoOutput(true);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("attachmentData");
        IOUtils.copy((InputStream)is, (OutputStream)connection.getOutputStream());
        connection.getOutputStream().close();
        is.close();
        AttachmentProviderXMLClientServerTest.assertTrue((String)"wrong content type", (boolean)connection.getContentType().contains("multipart/related"));
        String input = IOUtils.toString((InputStream)connection.getInputStream());
        int idx = input.indexOf("-----");
        int idx2 = input.indexOf("-----", idx + 5);
        String root = input.substring(idx, idx2);
        idx = root.indexOf("\r\n\r\n");
        root = root.substring(idx).trim();
        Document result = XMLUtils.parse((String)root);
        List resList = DOMUtils.findAllElementsByTagName((Element)result.getDocumentElement(), (String)"att");
        AttachmentProviderXMLClientServerTest.assertEquals((String)"Two attachments must've been encoded", (Object)2, (Object)resList.size());
        this.verifyAttachment(resList, "foo", "foobar");
        this.verifyAttachment(resList, "bar", "barbaz");
        input = input.substring(idx2);
        AttachmentProviderXMLClientServerTest.assertTrue((boolean)input.contains("<foo>"));
        AttachmentProviderXMLClientServerTest.assertTrue((boolean)input.contains("ABCDEFGHIJKLMNOP"));
    }

    private void verifyAttachment(List<Element> atts, String contentId, String value) {
        for (Element expElem : atts) {
            String child = expElem.getFirstChild().getNodeValue();
            String contentIdVal = expElem.getAttribute("contentId");
            if (!contentId.equals(contentIdVal) || !Base64Utility.encode((byte[])value.getBytes()).equals(child) && !Base64Utility.encode((byte[])(value + "\n").getBytes()).equals(child)) continue;
            return;
        }
        AttachmentProviderXMLClientServerTest.fail((String)("No encoded attachment with id " + contentId + " found"));
    }
}

