/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(portName="SoapPortProviderRPCLit3", serviceName="SOAPServiceProviderRPCLit", targetNamespace="http://apache.org/hello_world_rpclit", wsdlLocation="/wsdl/hello_world_rpc_lit.wsdl")
public class HWDOMSourcePayloadProvider
implements Provider<DOMSource> {
    private static QName sayHi = new QName("http://apache.org/hello_world_rpclit", "sayHi");
    private static QName greetMe = new QName("http://apache.org/hello_world_rpclit", "greetMe");
    private Document sayHiResponse;
    private Document greetMeResponse;
    private MessageFactory factory;

    public HWDOMSourcePayloadProvider() {
        try {
            this.factory = MessageFactory.newInstance();
            InputStream is = this.getClass().getResourceAsStream("resources/sayHiRpcLiteralResp.xml");
            this.sayHiResponse = this.factory.createMessage(null, is).getSOAPBody().extractContentAsDocument();
            is.close();
            is = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralResp.xml");
            this.greetMeResponse = this.factory.createMessage(null, is).getSOAPBody().extractContentAsDocument();
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DOMSource invoke(DOMSource request) {
        DOMSource response = new DOMSource();
        Node n = request.getNode();
        if (n.getLocalName().equals(sayHi.getLocalPart())) {
            response.setNode(this.sayHiResponse);
        } else if (n.getLocalName().equals(greetMe.getLocalPart())) {
            Element el = DOMUtils.getFirstElement((Node)n);
            String s = DOMUtils.getContent((Node)el);
            if (s.trim().equals("throwFault")) {
                try {
                    SOAPFactory f = SOAPFactory.newInstance();
                    SOAPFault soapFault = f.createFault();
                    soapFault.setFaultString("Test Fault String ****");
                    Detail detail = soapFault.addDetail();
                    detail = soapFault.getDetail();
                    QName qName = new QName("http://www.Hello.org/greeter", "TestFault", "ns");
                    DetailEntry de = detail.addDetailEntry(qName);
                    qName = new QName("http://www.Hello.org/greeter", "ErrorCode", "ns");
                    SOAPElement errorElement = de.addChildElement(qName);
                    errorElement.setTextContent("errorcode");
                    throw new SOAPFaultException(soapFault);
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                }
            }
            response.setNode(this.greetMeResponse);
        }
        return response;
    }
}

