/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(portName="SoapPortProviderRPCLit4", serviceName="SOAPServiceProviderRPCLit", targetNamespace="http://apache.org/hello_world_rpclit", wsdlLocation="/wsdl/hello_world_rpc_lit.wsdl")
@ServiceMode(value=Service.Mode.MESSAGE)
public class HWSAXSourceMessageProvider
implements Provider<SAXSource> {
    private static QName sayHi = new QName("http://apache.org/hello_world_rpclit", "sayHi");
    private static QName greetMe = new QName("http://apache.org/hello_world_rpclit", "greetMe");
    private InputSource sayHiInputSource;
    private InputSource greetMeInputSource;
    private MessageFactory factory;

    public HWSAXSourceMessageProvider() {
        try {
            this.factory = MessageFactory.newInstance();
            InputStream is1 = this.getClass().getResourceAsStream("resources/sayHiRpcLiteralResp.xml");
            this.sayHiInputSource = new InputSource(is1);
            InputStream is2 = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralResp.xml");
            this.greetMeInputSource = new InputSource(is2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SAXSource invoke(SAXSource request) {
        SAXSource response = new SAXSource();
        try {
            SOAPMessage msg = this.factory.createMessage();
            msg.getSOAPPart().setContent((Source)request);
            SOAPBody body = msg.getSOAPBody();
            Node n = body.getFirstChild();
            while (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            if (n.getLocalName().equals(sayHi.getLocalPart())) {
                response.setInputSource(this.sayHiInputSource);
            } else if (n.getLocalName().equals(greetMe.getLocalPart())) {
                response.setInputSource(this.greetMeInputSource);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

