/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.systest.provider.HWSoapMessageDocProvider;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProviderClientServerTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ProviderClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)ProviderClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testSOAPMessageModeDocLit() throws Exception {
        QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPProviderService");
        QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapProviderPort");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ProviderClientServerTest.assertNotNull((Object)wsdl);
        SOAPService service = new SOAPService(wsdl, serviceName);
        ProviderClientServerTest.assertNotNull((Object)service);
        String response1 = new String("TestSOAPOutputPMessage");
        String response2 = new String("Bonjour");
        try {
            Greeter greeter = (Greeter)service.getPort(portName, Greeter.class);
            for (int idx = 0; idx < 2; ++idx) {
                String greeting = greeter.greetMe("Milestone-" + idx);
                ProviderClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                ProviderClientServerTest.assertEquals((Object)response1, (Object)greeting);
                String reply = greeter.sayHi();
                ProviderClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                ProviderClientServerTest.assertEquals((Object)response2, (Object)reply);
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            HWSoapMessageDocProvider implementor = new HWSoapMessageDocProvider();
            String address = "http://localhost:9003/SoapContext/SoapProviderPort";
            Endpoint.publish((String)address, (Object)implementor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

