/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.provider;

import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLogicalHandler
implements LogicalHandler<LogicalMessageContext> {
    public boolean handleMessage(LogicalMessageContext ctx) {
        try {
            LogicalMessage msg = ctx.getMessage();
            Source payload = msg.getPayload();
            String request = TestLogicalHandler.getSourceAsString(payload);
            if (request.indexOf("ServerSOAPHandler") >= 0) {
                InputStream greetMeInputStream = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralReqLogical.xml");
                StreamSource source = new StreamSource();
                source.setInputStream(greetMeInputStream);
                msg.setPayload((Source)source);
            } else if (request.indexOf("TestGreetMeResponse") >= 0) {
                InputStream greetMeInputStream = this.getClass().getResourceAsStream("resources/GreetMeRpcLiteralRespLogical.xml");
                StreamSource source = new StreamSource();
                source.setInputStream(greetMeInputStream);
                msg.setPayload((Source)source);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean handleFault(LogicalMessageContext ctx) {
        return true;
    }

    public void close(MessageContext arg0) {
    }

    public static String getSourceAsString(Source s) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        StringWriter out = new StringWriter();
        StreamResult streamResult = new StreamResult();
        streamResult.setWriter(out);
        transformer.transform(s, streamResult);
        return streamResult.getWriter().toString();
    }
}

