/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.rest;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.customer.book.Book;
import org.apache.cxf.customer.book.BookService;
import org.apache.cxf.customer.book.BookServiceWrapped;
import org.apache.cxf.customer.book.GetAnotherBook;
import org.apache.cxf.customer.book.GetBook;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.systest.rest.BookServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RestClientServerBookTest
extends AbstractBusClientServerTestBase {
    static final Logger LOG = LogUtils.getLogger(RestClientServerBookTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        RestClientServerBookTest.assertTrue((String)"server did not launch correctly", (boolean)RestClientServerBookTest.launchServer(BookServer.class));
    }

    @Test
    public void testGetBookWithXmlRootElement() throws Exception {
        JaxWsProxyFactoryBean sf = new JaxWsProxyFactoryBean();
        sf.setServiceClass(BookService.class);
        sf.getServiceFactory().setWrapped(false);
        sf.getClientFactoryBean().setBindingId("http://apache.org/cxf/binding/http");
        sf.setAddress("http://localhost:9080/xml/");
        BookService bs = (BookService)sf.create();
        GetBook getBook = new GetBook();
        getBook.setId(123L);
        Book book = bs.getBook(getBook);
        RestClientServerBookTest.assertEquals((Object)book.getId(), (Object)123L);
        RestClientServerBookTest.assertEquals((Object)book.getName(), (Object)"CXF in Action");
    }

    @Test
    public void testGetBookWithOutXmlRootElement() throws Exception {
        JaxWsProxyFactoryBean sf = new JaxWsProxyFactoryBean();
        sf.setServiceClass(BookService.class);
        sf.getServiceFactory().setWrapped(false);
        sf.getClientFactoryBean().setBindingId("http://apache.org/cxf/binding/http");
        sf.setAddress("http://localhost:9080/xml/");
        BookService bs = (BookService)sf.create();
        GetAnotherBook getAnotherBook = new GetAnotherBook();
        getAnotherBook.setId(123L);
        Book book = bs.getAnotherBook(getAnotherBook);
        RestClientServerBookTest.assertEquals((Object)book.getId(), (Object)123L);
        RestClientServerBookTest.assertEquals((Object)book.getName(), (Object)"CXF in Action");
    }

    @Test
    public void testGetBookWrapped() throws Exception {
        JaxWsProxyFactoryBean sf = new JaxWsProxyFactoryBean();
        sf.setServiceClass(BookServiceWrapped.class);
        sf.getServiceFactory().setWrapped(true);
        sf.getClientFactoryBean().setBindingId("http://apache.org/cxf/binding/http");
        sf.setAddress("http://localhost:9080/xmlwrapped/");
        BookServiceWrapped bs = (BookServiceWrapped)sf.create();
        Book book = bs.getBook(123L);
        RestClientServerBookTest.assertEquals((Object)book.getId(), (Object)123L);
        RestClientServerBookTest.assertEquals((Object)book.getName(), (Object)"CXF in Action");
    }

    @Test
    public void testGetBookWrappedUsingURL() throws Exception {
        String endpointAddress = "http://localhost:9080/xmlwrapped/books/123";
        URL url = new URL(endpointAddress);
        InputStream in = url.openStream();
        RestClientServerBookTest.assertNotNull((Object)in);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("a1", "http://book.acme.com");
        ns.put("a2", "http://book.customer.cxf.apache.org/");
        Document doc = XMLUtils.parse((InputStream)in);
        XPathUtils xp = new XPathUtils(ns);
        RestClientServerBookTest.assertTrue((boolean)xp.isExist("/a2:getBookResponse", (Node)doc.getDocumentElement(), XPathConstants.NODE));
        RestClientServerBookTest.assertTrue((boolean)xp.isExist("/a2:getBookResponse/a2:Book", (Node)doc.getDocumentElement(), XPathConstants.NODE));
        RestClientServerBookTest.assertTrue((boolean)xp.isExist("/a2:getBookResponse/a2:Book/a1:id", (Node)doc.getDocumentElement(), XPathConstants.NODE));
        RestClientServerBookTest.assertEquals((Object)"123", (Object)xp.getValue("/a2:getBookResponse/a2:Book/a1:id", (Node)doc.getDocumentElement(), XPathConstants.STRING));
        RestClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)xp.getValue("/a2:getBookResponse/a2:Book/a1:name", (Node)doc.getDocumentElement(), XPathConstants.STRING));
    }

    @Test
    public void testGetBooksJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/json/books";
        URL url = new URL(endpointAddress);
        InputStream in = url.openStream();
        RestClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_json_books.txt");
        RestClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetBookJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/json/books/123";
        URL url = new URL(endpointAddress);
        InputStream in = url.openStream();
        RestClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_json_book123.txt");
        RestClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddBookJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/json/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/add_book_json.txt").toURI());
        PostMethod post = new PostMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/plain; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            RestClientServerBookTest.assertEquals((Object)200, (Object)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book_json.txt");
            RestClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

