/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.rest;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.cxf.systest.rest.HttpBindingServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class RestClientServerHttpBindingTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_xml_http/wrapped", "XMLService");
    private final QName portName = new QName("http://apache.org/hello_world_xml_http/wrapped", "RestProviderPort");
    private final String endpointAddress = "http://localhost:9024/XMLService/RestProviderPort/Customer";

    @BeforeClass
    public static void startServers() throws Exception {
        RestClientServerHttpBindingTest.assertTrue((String)"server did not launch correctly", (boolean)RestClientServerHttpBindingTest.launchServer(HttpBindingServer.class));
    }

    @Test
    public void testHttpGET() throws Exception {
        URL url = new URL("http://localhost:9024/XMLService/RestProviderPort/Customer?name=john&address=20");
        InputStream in = url.openStream();
        RestClientServerHttpBindingTest.assertNotNull((Object)in);
    }

    @Test
    public void testHttpPOSTDispatchHTTPBinding() throws Exception {
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.portName, "http://www.w3.org/2004/08/wsdl/http", "http://localhost:9024/XMLService/RestProviderPort/Customer");
        Dispatch dispatcher = service.createDispatch(this.portName, Source.class, Service.Mode.MESSAGE);
        Map requestContext = dispatcher.getRequestContext();
        requestContext.put("javax.xml.ws.http.request.method", "POST");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("resources/CustomerJohnReq.xml");
        Source result = (Source)dispatcher.invoke((Object)new StreamSource(is));
        String tempstring = this.source2String(result);
        RestClientServerHttpBindingTest.assertTrue((String)"Result should start with Customer", (boolean)tempstring.startsWith("<ns4:Customer"));
        RestClientServerHttpBindingTest.assertTrue((String)"Result should have CustomerID", (tempstring.lastIndexOf(">123456<") > 0 ? 1 : 0) != 0);
    }

    private String source2String(Source source) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(bos);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        Properties oprops = new Properties();
        oprops.put("omit-xml-declaration", "yes");
        trans.setOutputProperties(oprops);
        trans.transform(source, sr);
        return bos.toString();
    }
}

