/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.rest;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.helpers.CastUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider
@ServiceMode(value=Service.Mode.PAYLOAD)
@BindingType(value="http://cxf.apache.org/bindings/xformat")
public class RestSourcePayloadProvider
implements Provider<DOMSource> {
    @Resource
    protected WebServiceContext wsContext;

    public DOMSource invoke(DOMSource request) {
        MessageContext mc = this.wsContext.getMessageContext();
        String path = (String)mc.get((Object)"javax.xml.ws.http.request.pathinfo");
        String query = (String)mc.get((Object)"javax.xml.ws.http.request.querystring");
        String httpMethod = (String)mc.get((Object)"javax.xml.ws.http.request.method");
        HashMap responseHeader = CastUtils.cast((Map)((Map)mc.get((Object)"javax.xml.ws.http.response.headers")));
        if (responseHeader == null) {
            responseHeader = new HashMap();
            mc.put((Object)"javax.xml.ws.http.response.headers", responseHeader);
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add("hello1");
        values.add("hello2");
        responseHeader.put("REST", values);
        if (httpMethod.equalsIgnoreCase("POST")) {
            return this.getCustomer(null);
        }
        if (httpMethod.equalsIgnoreCase("GET")) {
            if ("/XMLService/RestProviderPort/Customer".equals(path) && query == null) {
                return this.getAllCustomers();
            }
            if ("/XMLService/RestProviderPort/Customer".equals(path) && query != null) {
                return this.getCustomer(query);
            }
        }
        return null;
    }

    private DOMSource getAllCustomers() {
        return this.createDOMSource("resources/CustomerAllResp.xml");
    }

    private DOMSource getCustomer(String customerID) {
        return this.createDOMSource("resources/CustomerJohnResp.xml");
    }

    private DOMSource createDOMSource(String fileName) {
        Document document = null;
        DOMSource response = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream greetMeResponse = this.getClass().getResourceAsStream(fileName);
            document = builder.parse(greetMeResponse);
            response = new DOMSource(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }
}

