/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.systest.jaxws.Hello;
import org.apache.cxf.systest.servlet.NoSpringServletServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.BeforeClass;
import org.junit.Test;

public class NoSpringServletClientTest
extends AbstractBusClientServerTestBase {
    private final QName portName = new QName("http://apache.org/hello_world_soap_http", "SoapPort");
    private final String serviceURL = "http://localhost:9000/soap/";

    @BeforeClass
    public static void startServers() throws Exception {
        NoSpringServletClientTest.assertTrue((String)"server did not launch correctly", (boolean)NoSpringServletClientTest.launchServer(NoSpringServletServer.class));
    }

    @Test
    public void testBasicConnection() throws Exception {
        SOAPService service = new SOAPService(new URL("http://localhost:9000/soap/Greeter?wsdl"));
        Greeter greeter = (Greeter)service.getPort(this.portName, Greeter.class);
        try {
            String reply = greeter.greetMe("test");
            NoSpringServletClientTest.assertNotNull((String)"no response received from service", (Object)reply);
            NoSpringServletClientTest.assertEquals((Object)"Hello test", (Object)reply);
            reply = greeter.sayHi();
            NoSpringServletClientTest.assertNotNull((String)"no response received from service", (Object)reply);
            NoSpringServletClientTest.assertEquals((Object)"Bonjour", (Object)reply);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testHelloService() throws Exception {
        JaxWsProxyFactoryBean cpfb = new JaxWsProxyFactoryBean();
        String address = "http://localhost:9000/soap/Hello";
        cpfb.setServiceClass(Hello.class);
        cpfb.setAddress(address);
        Hello hello = (Hello)cpfb.create();
        String reply = hello.sayHi(" Willem");
        NoSpringServletClientTest.assertEquals((String)"Get the wrongreply ", (Object)reply, (Object)"get Willem");
    }

    @Test
    public void testGetServiceList() throws Exception {
        WebConversation client = new WebConversation();
        WebResponse res = client.getResponse("http://localhost:9000/soap/");
        WebLink[] links = res.getLinks();
        NoSpringServletClientTest.assertEquals((String)"There should get two links for the service", (Object)2, (Object)links.length);
        NoSpringServletClientTest.assertEquals((Object)"http://localhost:9000/soap/Greeter?wsdl", (Object)links[0].getURLString());
        NoSpringServletClientTest.assertEquals((Object)"text/html", (Object)res.getContentType());
    }
}

