/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import javax.servlet.Servlet;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.systest.jaxws.HelloImpl;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class NoSpringServletServer
extends AbstractBusTestServerBase {
    Server httpServer;

    protected void run() {
        String busFactory = System.getProperty("org.apache.cxf.bus.factory");
        System.setProperty("org.apache.cxf.bus.factory", "org.apache.cxf.bus.CXFBusFactory");
        try {
            this.httpServer = new Server(9000);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            this.httpServer.setHandler((Handler)contexts);
            Context root = new Context((HandlerContainer)contexts, "/", 1);
            CXFNonSpringServlet cxf = new CXFNonSpringServlet();
            ServletHolder servlet = new ServletHolder((Servlet)cxf);
            servlet.setName("soap");
            servlet.setForcedPath("soap");
            root.addServlet(servlet, "/soap/*");
            this.httpServer.start();
            Bus bus = cxf.getBus();
            this.setBus(bus);
            BusFactory.setDefaultBus((Bus)bus);
            GreeterImpl impl = new GreeterImpl();
            Endpoint.publish((String)"/Greeter", (Object)impl);
            HelloImpl helloImpl = new HelloImpl();
            Endpoint.publish((String)"/Hello", (Object)helloImpl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (busFactory != null) {
                System.setProperty("org.apache.cxf.bus.factory", busFactory);
            } else {
                System.clearProperty("org.apache.cxf.bus.factory");
            }
        }
    }

    public void tearDown() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            NoSpringServletServer s = new NoSpringServletServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

