/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.soap;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapBindingConfiguration;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.systest.soap.SoapActionGreeterImpl;
import org.apache.hello_world_soap_action.Greeter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SoapActionTest
extends Assert {
    static Bus bus;
    static String add11;
    static String add12;

    @BeforeClass
    public static void createServers() throws Exception {
        bus = BusFactory.getDefaultBus();
        JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setServiceBean((Object)new SoapActionGreeterImpl());
        sf.setAddress(add11);
        sf.setBus(bus);
        sf.create();
        sf = new JaxWsServerFactoryBean();
        sf.setServiceBean((Object)new SoapActionGreeterImpl());
        sf.setAddress(add12);
        sf.setBus(bus);
        SoapBindingConfiguration config = new SoapBindingConfiguration();
        config.setVersion((SoapVersion)Soap12.getInstance());
        sf.setBindingConfig((BindingConfiguration)config);
        sf.create();
    }

    @AfterClass
    public static void shutdown() throws Exception {
        bus.shutdown(true);
    }

    @Test
    public void testEndpoint() throws Exception {
        JaxWsProxyFactoryBean pf = new JaxWsProxyFactoryBean();
        pf.setServiceClass(Greeter.class);
        pf.setAddress(add11);
        pf.setBus(bus);
        Greeter greeter = (Greeter)pf.create();
        SoapActionTest.assertEquals((Object)"sayHi", (Object)greeter.sayHi("test"));
        SoapActionTest.assertEquals((Object)"sayHi2", (Object)greeter.sayHi2("test"));
    }

    @Test
    public void testSoap12Endpoint() throws Exception {
        JaxWsProxyFactoryBean pf = new JaxWsProxyFactoryBean();
        pf.setServiceClass(Greeter.class);
        pf.setAddress(add12);
        SoapBindingConfiguration config = new SoapBindingConfiguration();
        config.setVersion((SoapVersion)Soap12.getInstance());
        pf.setBindingConfig((BindingConfiguration)config);
        pf.setBus(bus);
        Greeter greeter = (Greeter)pf.create();
        SoapActionTest.assertEquals((Object)"sayHi", (Object)greeter.sayHi("test"));
        SoapActionTest.assertEquals((Object)"sayHi2", (Object)greeter.sayHi2("test"));
    }

    static {
        add11 = "http://localhost:9036/test11";
        add12 = "http://localhost:9036/test12";
    }
}

