/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.soap12;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.systest.soap12.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_soap12_http.Greeter;
import org.apache.hello_world_soap12_http.PingMeFault;
import org.apache.hello_world_soap12_http.SOAPService;
import org.apache.hello_world_soap12_http.types.FaultDetail;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Soap12ClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/hello_world_soap12_http", "SOAPService");
    private final QName portName = new QName("http://apache.org/hello_world_soap12_http", "SoapPort");

    @BeforeClass
    public static void startServers() throws Exception {
        Soap12ClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)Soap12ClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testBasicConnection() throws Exception {
        Greeter greeter = this.getGreeter();
        for (int i = 0; i < 5; ++i) {
            String echo = greeter.sayHi();
            Soap12ClientServerTest.assertEquals((Object)"Bonjour", (Object)echo);
        }
    }

    @Test
    public void testPingMeFault() throws Exception {
        Greeter greeter = this.getGreeter();
        try {
            greeter.pingMe();
            Soap12ClientServerTest.fail((String)"Should throw Exception!");
        }
        catch (PingMeFault ex) {
            FaultDetail detail = ex.getFaultInfo();
            Soap12ClientServerTest.assertEquals((Object)2, (Object)detail.getMajor());
            Soap12ClientServerTest.assertEquals((Object)1, (Object)detail.getMinor());
            Soap12ClientServerTest.assertEquals((Object)"PingMeFault raised by server", (Object)ex.getMessage());
        }
    }

    @Test
    public void testGetSayHi() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9012/SoapContext/SoapPort/sayHi");
        httpConnection.connect();
        InputStream in = httpConnection.getInputStream();
        Soap12ClientServerTest.assertNotNull((Object)in);
        Soap12ClientServerTest.assertEquals((Object)"application/soap+xml; charset=utf-8", (Object)httpConnection.getContentType().toLowerCase());
        Document doc = XMLUtils.parse((InputStream)in);
        Soap12ClientServerTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("soap12", "http://www.w3.org/2003/05/soap-envelope");
        ns.put("ns2", "http://apache.org/hello_world_soap12_http/types");
        XPathUtils xu = new XPathUtils(ns);
        Node body = (Node)xu.getValue("/soap12:Envelope/soap12:Body", (Node)doc, XPathConstants.NODE);
        Soap12ClientServerTest.assertNotNull((Object)body);
        String response = (String)xu.getValue("//ns2:sayHiResponse/ns2:responseType/text()", body, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"Bonjour", (Object)response);
    }

    @Test
    public void testGetPingMe() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9012/SoapContext/SoapPort/pingMe");
        httpConnection.connect();
        Soap12ClientServerTest.assertEquals((Object)500, (Object)httpConnection.getResponseCode());
        Soap12ClientServerTest.assertEquals((Object)"Internal Server Error", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getErrorStream();
        Soap12ClientServerTest.assertNotNull((Object)in);
        Soap12ClientServerTest.assertEquals((Object)"application/soap+xml; charset=utf-8", (Object)httpConnection.getContentType().toLowerCase());
        Document doc = XMLUtils.parse((InputStream)in);
        Soap12ClientServerTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("s", "http://www.w3.org/2003/05/soap-envelope");
        ns.put("ns2", "http://apache.org/hello_world_soap12_http/types");
        XPathUtils xu = new XPathUtils(ns);
        String codeValue = (String)xu.getValue("/s:Envelope/s:Body/s:Fault/s:Code/s:Value/text()", (Node)doc, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"soap:Receiver", (Object)codeValue);
        String reason = (String)xu.getValue("//s:Reason//text()", (Node)doc, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"PingMeFault raised by server", (Object)reason);
        String minor = (String)xu.getValue("//s:Detail//ns2:faultDetail/ns2:minor/text()", (Node)doc, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"1", (Object)minor);
        String major = (String)xu.getValue("//s:Detail//ns2:faultDetail/ns2:major/text()", (Node)doc, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"2", (Object)major);
    }

    @Test
    public void testGetMethodNotExist() throws Exception {
        HttpURLConnection httpConnection = this.getHttpConnection("http://localhost:9012/SoapContext/SoapPort/greetMe");
        httpConnection.connect();
        Soap12ClientServerTest.assertEquals((Object)500, (Object)httpConnection.getResponseCode());
        Soap12ClientServerTest.assertEquals((Object)"application/soap+xml; charset=utf-8", (Object)httpConnection.getContentType().toLowerCase());
        Soap12ClientServerTest.assertEquals((Object)"Internal Server Error", (Object)httpConnection.getResponseMessage());
        InputStream in = httpConnection.getErrorStream();
        Soap12ClientServerTest.assertNotNull((Object)in);
        Document doc = XMLUtils.parse((InputStream)in);
        Soap12ClientServerTest.assertNotNull((Object)doc);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("s", "http://www.w3.org/2003/05/soap-envelope");
        ns.put("ns2", "http://apache.org/hello_world_soap12_http/types");
        XPathUtils xu = new XPathUtils(ns);
        String codeValue = (String)xu.getValue("/s:Envelope/s:Body/s:Fault/s:Code/s:Value/text()", (Node)doc, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"soap:Receiver", (Object)codeValue);
        String reason = (String)xu.getValue("//s:Reason//text()", (Node)doc, XPathConstants.STRING);
        Soap12ClientServerTest.assertEquals((Object)"No such operation: greetMe", (Object)reason);
    }

    private Greeter getGreeter() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_soap12.wsdl");
        Soap12ClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        Soap12ClientServerTest.assertNotNull((String)"Service is ull ", (Object)service);
        return (Greeter)service.getPort(this.portName, Greeter.class);
    }
}

