/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.soapheader;

import java.net.URL;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import org.apache.cxf.pizza.Pizza;
import org.apache.cxf.pizza.PizzaService;
import org.apache.cxf.pizza.types.CallerIDHeaderType;
import org.apache.cxf.pizza.types.ObjectFactory;
import org.apache.cxf.pizza.types.OrderPizzaResponseType;
import org.apache.cxf.pizza.types.OrderPizzaType;
import org.apache.cxf.pizza.types.ToppingsListType;
import org.apache.cxf.systest.soapheader.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class HeaderClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://cxf.apache.org/pizza", "PizzaService");

    @BeforeClass
    public static void startServers() throws Exception {
        HeaderClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)HeaderClientServerTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testBasicConnection() throws Exception {
        Pizza port = this.getPort();
        OrderPizzaType req = new OrderPizzaType();
        ToppingsListType t = new ToppingsListType();
        t.getTopping().add("test");
        req.setToppings(t);
        CallerIDHeaderType header = new CallerIDHeaderType();
        header.setName("mao");
        header.setPhoneNumber("108");
        OrderPizzaResponseType res = port.orderPizza(req, header);
        HeaderClientServerTest.assertEquals((Object)208, (Object)res.getMinutesUntilReady());
    }

    @Test
    public void testBasicConnectionNoHeader() throws Exception {
        PizzaNoHeader port = this.getPortNoHeader();
        OrderPizzaType req = new OrderPizzaType();
        ToppingsListType t = new ToppingsListType();
        t.getTopping().add("NoHeader!");
        t.getTopping().add("test");
        req.setToppings(t);
        OrderPizzaResponseType res = port.orderPizza(req);
        HeaderClientServerTest.assertEquals((Object)100, (Object)res.getMinutesUntilReady());
    }

    private Pizza getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/pizza_service.wsdl");
        HeaderClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        PizzaService service = new PizzaService(wsdl, this.serviceName);
        HeaderClientServerTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getPizzaPort();
    }

    private PizzaNoHeader getPortNoHeader() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/pizza_service.wsdl");
        HeaderClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        PizzaService service = new PizzaService(wsdl, this.serviceName);
        HeaderClientServerTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return (PizzaNoHeader)service.getPort(PizzaNoHeader.class);
    }

    @WebService(targetNamespace="http://cxf.apache.org/pizza", name="Pizza")
    @XmlSeeAlso(value={ObjectFactory.class})
    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
    public static interface PizzaNoHeader {
        @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
        @WebResult(name="OrderResponse", targetNamespace="http://cxf.apache.org/pizza/types", partName="body")
        @WebMethod(operationName="OrderPizza")
        public OrderPizzaResponseType orderPizza(@WebParam(partName="body", name="OrderRequest", targetNamespace="http://cxf.apache.org/pizza/types") OrderPizzaType var1);
    }
}

