/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.stringarray;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.stringarray.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.stringarray.SOAPServiceRPCLit;
import org.apache.stringarray.StringListTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class StringArrayTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        StringArrayTest.assertTrue((String)"server did not launch correctly", (boolean)StringArrayTest.launchServer(Server.class));
    }

    @AfterClass
    public static void stopAllServers() throws Exception {
    }

    @Test
    public void testStringArrayList() throws Exception {
        SpringBusFactory factory = new SpringBusFactory();
        Bus bus = factory.createBus();
        BusFactory.setDefaultBus((Bus)bus);
        this.setBus(bus);
        StringWriter swin = new StringWriter();
        PrintWriter pwin = new PrintWriter(swin);
        LoggingInInterceptor logIn = new LoggingInInterceptor(pwin);
        StringWriter swout = new StringWriter();
        PrintWriter pwout = new PrintWriter(swout);
        LoggingOutInterceptor logOut = new LoggingOutInterceptor(pwout);
        this.getBus().getInInterceptors().add(logIn);
        this.getBus().getOutInterceptors().add(logOut);
        SOAPServiceRPCLit service = new SOAPServiceRPCLit();
        StringListTest port = service.getSoapPortRPCLit();
        Object[] strs = new String[]{"org", "apache", "cxf"};
        Object[] res = port.stringListTest((String[])strs);
        StringArrayTest.assertArrayEquals((Object[])strs, (Object[])res);
        StringArrayTest.assertTrue((String)"Request message is not marshalled correctly and @XmlList does not take effect", (swout.toString().indexOf("<in>org apache cxf</in>") > -1 ? 1 : 0) != 0);
        StringArrayTest.assertTrue((String)"Response message is not marshalled correctly and @XmlList does not take effect", (swin.toString().indexOf("<out>org apache cxf</out>") > -1 ? 1 : 0) != 0);
    }
}

