/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.swa;

import java.io.InputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.swa.SwAServiceInterface;
import org.apache.cxf.swa.types.DataStruct;
import org.apache.cxf.swa.types.OutputResponseAll;
import org.apache.cxf.swa_nomime.SwAService;
import org.apache.cxf.swa_nomime.types.VoidRequest;
import org.apache.cxf.systest.swa.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientServerSwaTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerSwaTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerSwaTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testSwaNoMimeCodeGen() throws Exception {
        SwAService service = new SwAService();
        org.apache.cxf.swa_nomime.SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder textHolder = new Holder((Object)"Hi");
        Holder data = new Holder((Object)"foobar".getBytes());
        port.echoData(textHolder, data);
        String string = IOUtils.newStringFromBytes((byte[])((byte[])data.value));
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
        ClientServerSwaTest.assertEquals((Object)"Hi", (Object)textHolder.value);
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        URL url1 = ((Object)((Object)this)).getClass().getResource("resources/attach.text");
        URL url2 = ((Object)((Object)this)).getClass().getResource("resources/attach.html");
        URL url3 = ((Object)((Object)this)).getClass().getResource("resources/attach.xml");
        URL url4 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg1");
        URL url5 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg2");
        Holder attach1 = new Holder((Object)IOUtils.toString((InputStream)url1.openStream()));
        Holder attach2 = new Holder((Object)IOUtils.toString((InputStream)url2.openStream()));
        Holder attach3 = new Holder((Object)IOUtils.toString((InputStream)url3.openStream()));
        Holder attach4 = new Holder((Object)IOUtils.readBytesFromStream((InputStream)url4.openStream()));
        Holder attach5 = new Holder((Object)IOUtils.readBytesFromStream((InputStream)url5.openStream()));
        VoidRequest request = new VoidRequest();
        org.apache.cxf.swa_nomime.types.OutputResponseAll response = port.echoAllAttachmentTypes(request, attach1, attach2, attach3, attach4, attach5);
        ClientServerSwaTest.assertNotNull((Object)response);
    }

    @Test
    public void testSwa() throws Exception {
        org.apache.cxf.swa.SwAService service = new org.apache.cxf.swa.SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder textHolder = new Holder();
        Holder data = new Holder();
        ByteArrayDataSource source = new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)source);
        data.value = handler;
        textHolder.value = "Hi";
        port.echoData(textHolder, data);
        InputStream bis = null;
        bis = ((DataHandler)data.value).getDataSource().getInputStream();
        byte[] b = new byte[10];
        bis.read(b, 0, 10);
        String string = IOUtils.newStringFromBytes((byte[])b);
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
        ClientServerSwaTest.assertEquals((Object)"Hi", (Object)textHolder.value);
    }

    @Test
    public void testSwaWithHeaders() throws Exception {
        org.apache.cxf.swa.SwAService service = new org.apache.cxf.swa.SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder textHolder = new Holder();
        Holder headerHolder = new Holder();
        Holder data = new Holder();
        ByteArrayDataSource source = new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)source);
        data.value = handler;
        textHolder.value = "Hi";
        headerHolder.value = "Header";
        port.echoDataWithHeader(textHolder, data, headerHolder);
        InputStream bis = null;
        bis = ((DataHandler)data.value).getDataSource().getInputStream();
        byte[] b = new byte[10];
        bis.read(b, 0, 10);
        String string = IOUtils.newStringFromBytes((byte[])b);
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
        ClientServerSwaTest.assertEquals((Object)"Hi", (Object)textHolder.value);
        ClientServerSwaTest.assertEquals((Object)"Header", (Object)headerHolder.value);
    }

    @Test
    public void testSwaDataStruct() throws Exception {
        org.apache.cxf.swa.SwAService service = new org.apache.cxf.swa.SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        Holder structHolder = new Holder();
        ByteArrayDataSource source = new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream");
        DataHandler handler = new DataHandler((DataSource)source);
        DataStruct struct = new DataStruct();
        struct.setDataRef(handler);
        structHolder.value = struct;
        port.echoDataRef(structHolder);
        handler = ((DataStruct)structHolder.value).getDataRef();
        InputStream bis = null;
        bis = handler.getDataSource().getInputStream();
        byte[] b = new byte[10];
        bis.read(b, 0, 10);
        String string = IOUtils.newStringFromBytes((byte[])b);
        ClientServerSwaTest.assertEquals((Object)"testfoobar", (Object)string);
    }

    @Test
    public void testSwaTypes() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        org.apache.cxf.swa.SwAService service = new org.apache.cxf.swa.SwAService();
        SwAServiceInterface port = service.getSwAServiceHttpPort();
        URL url1 = ((Object)((Object)this)).getClass().getResource("resources/attach.text");
        URL url2 = ((Object)((Object)this)).getClass().getResource("resources/attach.html");
        URL url3 = ((Object)((Object)this)).getClass().getResource("resources/attach.xml");
        URL url4 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg1");
        URL url5 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg2");
        DataHandler dh1 = new DataHandler(url1);
        DataHandler dh2 = new DataHandler(url2);
        DataHandler dh3 = new DataHandler(url3);
        Holder attach1 = new Holder();
        attach1.value = dh1;
        Holder attach2 = new Holder();
        attach2.value = dh2;
        Holder attach3 = new Holder();
        attach3.value = new StreamSource(dh3.getInputStream());
        Holder attach4 = new Holder();
        Holder attach5 = new Holder();
        attach4.value = ImageIO.read(url4);
        attach5.value = ImageIO.read(url5);
        org.apache.cxf.swa.types.VoidRequest request = new org.apache.cxf.swa.types.VoidRequest();
        OutputResponseAll response = port.echoAllAttachmentTypes(request, attach1, attach2, attach3, attach4, attach5);
        ClientServerSwaTest.assertNotNull((Object)response);
    }

    @Test
    public void testSwaTypesWithDispatchAPI() throws Exception {
        if (Boolean.getBoolean("java.awt.headless")) {
            System.out.println("Running headless. Skipping test as Images may not work.");
            return;
        }
        URL url1 = ((Object)((Object)this)).getClass().getResource("resources/attach.text");
        URL url2 = ((Object)((Object)this)).getClass().getResource("resources/attach.html");
        URL url3 = ((Object)((Object)this)).getClass().getResource("resources/attach.xml");
        URL url4 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg1");
        URL url5 = ((Object)((Object)this)).getClass().getResource("resources/attach.jpeg2");
        byte[] bytes = IOUtils.readBytesFromStream((InputStream)url1.openStream());
        byte[] bigBytes = new byte[bytes.length * 50];
        for (int x = 0; x < 50; ++x) {
            System.arraycopy(bytes, 0, bigBytes, x * bytes.length, bytes.length);
        }
        DataHandler dh1 = new DataHandler((DataSource)new ByteArrayDataSource(bigBytes, "text/plain"));
        DataHandler dh2 = new DataHandler(url2);
        DataHandler dh3 = new DataHandler(url3);
        DataHandler dh4 = new DataHandler(url4);
        DataHandler dh5 = new DataHandler(url5);
        org.apache.cxf.swa.SwAService service = new org.apache.cxf.swa.SwAService();
        Dispatch disp = service.createDispatch(org.apache.cxf.swa.SwAService.SwAServiceHttpPort, SOAPMessage.class, Service.Mode.MESSAGE);
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        SOAPBody body = msg.getSOAPPart().getEnvelope().getBody();
        body.addBodyElement(new QName("http://cxf.apache.org/swa/types", "VoidRequest"));
        AttachmentPart att = msg.createAttachmentPart(dh1);
        att.setContentId("<attach1=c187f5da-fa5d-4ab9-81db-33c2bb855201@apache.org>");
        msg.addAttachmentPart(att);
        att = msg.createAttachmentPart(dh2);
        att.setContentId("<attach2=c187f5da-fa5d-4ab9-81db-33c2bb855202@apache.org>");
        msg.addAttachmentPart(att);
        att = msg.createAttachmentPart(dh3);
        att.setContentId("<attach3=c187f5da-fa5d-4ab9-81db-33c2bb855203@apache.org>");
        msg.addAttachmentPart(att);
        att = msg.createAttachmentPart(dh4);
        att.setContentId("<attach4=c187f5da-fa5d-4ab9-81db-33c2bb855204@apache.org>");
        msg.addAttachmentPart(att);
        att = msg.createAttachmentPart(dh5);
        att.setContentId("<attach5=c187f5da-fa5d-4ab9-81db-33c2bb855205@apache.org>");
        msg.addAttachmentPart(att);
        msg = (SOAPMessage)disp.invoke((Object)msg);
        ClientServerSwaTest.assertEquals((Object)5, (Object)msg.countAttachments());
    }
}

