/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_substitution;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceException;
import org.apache.type_substitution.Car;
import org.apache.type_substitution.CarDealer;
import org.apache.type_substitution.Porsche;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="CarDealer")
public class CarDealerImpl
implements CarDealer {
    public List<Car> getSedans(String carType) {
        if (carType.equalsIgnoreCase("Porsche")) {
            ArrayList<Car> cars = new ArrayList<Car>();
            cars.add((Car)this.newPorsche("Boxster", "1998", "white"));
            cars.add((Car)this.newPorsche("BoxsterS", "1999", "red"));
            return cars;
        }
        throw new WebServiceException("Not a dealer of: " + carType);
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
    public Car tradeIn(Car oldCar) {
        if (!(oldCar instanceof Porsche)) {
            throw new WebServiceException("Expected Porsche, received, " + oldCar.getClass().getName());
        }
        Porsche porsche = (Porsche)oldCar;
        if (porsche.getMake().equals("Porsche") && porsche.getModel().equals("GT2000") && porsche.getYear().equals("2000") && porsche.getColor().equals("white")) {
            return this.newPorsche("911GT3", "2007", "black");
        }
        throw new WebServiceException("Invalid Porsche Car");
    }

    private Porsche newPorsche(String model, String year, String color) {
        Porsche porsche = new Porsche();
        porsche.setMake("Porsche");
        porsche.setModel(model);
        porsche.setYear(year);
        porsche.setColor(color);
        return porsche;
    }
}

