/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_substitution;

import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.systest.type_substitution.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.type_substitution.Car;
import org.apache.type_substitution.CarDealer;
import org.apache.type_substitution.CarDealerService;
import org.apache.type_substitution.Porsche;
import org.junit.BeforeClass;
import org.junit.Test;

public class TypeSubClientServerTest
extends AbstractBusClientServerTestBase {
    private final QName serviceName = new QName("http://apache.org/type_substitution/", "CarDealerService");

    @BeforeClass
    public static void startServers() throws Exception {
        TypeSubClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)TypeSubClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testBasicConnection() throws Exception {
        CarDealer dealer = this.getCardealer();
        List cars = dealer.getSedans("porsche");
        TypeSubClientServerTest.assertEquals((Object)2, (Object)cars.size());
        Porsche car = (Porsche)cars.get(0);
        TypeSubClientServerTest.assertNotNull((Object)car);
        if (!(car != null && "Porsche".equals(car.getMake()) && "Boxster".equals(car.getModel()) && "1998".equals(car.getYear()) && "white".equals(car.getColor()))) {
            TypeSubClientServerTest.fail((String)"Get the wrong car!");
        }
        Porsche oldCar = new Porsche();
        oldCar.setMake("Porsche");
        oldCar.setColor("white");
        oldCar.setModel("GT2000");
        oldCar.setYear("2000");
        Porsche newCar = (Porsche)dealer.tradeIn((Car)oldCar);
        TypeSubClientServerTest.assertNotNull((Object)newCar);
        if (!(newCar != null && "Porsche".equals(newCar.getMake()) && "911GT3".equals(newCar.getModel()) && "2007".equals(newCar.getYear()) && "black".equals(newCar.getColor()))) {
            TypeSubClientServerTest.fail((String)"Get the wrong car!");
        }
    }

    private CarDealer getCardealer() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/cardealer.wsdl");
        TypeSubClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        CarDealerService service = new CarDealerService(wsdl, this.serviceName);
        TypeSubClientServerTest.assertNotNull((String)"Service is null ", (Object)service);
        return service.getCarDealerPort();
    }
}

