/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.type_test.I18NStrings;
import org.apache.cxf.systest.type_test.TypeTestTester;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.type_test.rpc.SOAPService;
import org.apache.type_test.types1.AnyURIEnum;
import org.apache.type_test.types1.ColourEnum;
import org.apache.type_test.types1.DecimalEnum;
import org.apache.type_test.types1.NMTokenEnum;
import org.apache.type_test.types1.NumberEnum;
import org.apache.type_test.types1.StringEnum;
import org.apache.type_test.xml.TypeTestPortType;
import org.apache.type_test.xml.XMLService;
import org.junit.Test;

public abstract class AbstractTypeTestClient
extends AbstractBusClientServerTestBase
implements TypeTestTester {
    protected static org.apache.type_test.doc.TypeTestPortType docClient;
    protected static TypeTestPortType xmlClient;
    protected static org.apache.type_test.rpc.TypeTestPortType rpcClient;
    protected static boolean testDocLiteral;
    protected static boolean testXMLBinding;
    protected boolean perfTestOnly;

    public void setPerformanceTestOnly() {
        this.perfTestOnly = true;
    }

    public boolean shouldRunTest(String name) {
        return true;
    }

    public static void initClient(Class clz, QName serviceName, QName portName, String wsdlPath) throws Exception {
        URL wsdlLocation = clz.getResource(wsdlPath);
        AbstractTypeTestClient.assertNotNull((String)("Could not load wsdl " + wsdlPath), (Object)wsdlLocation);
        testDocLiteral = wsdlPath.contains("doclit") || wsdlPath.contains("-corba");
        testXMLBinding = wsdlPath.contains("_xml");
        if (testXMLBinding) {
            XMLService xmlService = new XMLService(wsdlLocation, serviceName);
            xmlClient = (TypeTestPortType)xmlService.getPort(portName, TypeTestPortType.class);
            AbstractTypeTestClient.assertNotNull((String)"Could not create xmlClient", (Object)xmlClient);
        } else if (testDocLiteral) {
            org.apache.type_test.doc.SOAPService docService = new org.apache.type_test.doc.SOAPService(wsdlLocation, serviceName);
            docClient = (org.apache.type_test.doc.TypeTestPortType)docService.getPort(portName, org.apache.type_test.doc.TypeTestPortType.class);
            AbstractTypeTestClient.assertNotNull((String)"Could not create docClient", (Object)docClient);
        } else {
            SOAPService rpcService = new SOAPService(wsdlLocation, serviceName);
            rpcClient = (org.apache.type_test.rpc.TypeTestPortType)rpcService.getPort(portName, org.apache.type_test.rpc.TypeTestPortType.class);
            AbstractTypeTestClient.assertNotNull((String)"Could not create rpcClient", (Object)rpcClient);
        }
    }

    protected boolean equalsDate(XMLGregorianCalendar orig, XMLGregorianCalendar actual) {
        boolean result = false;
        if (orig.getYear() == actual.getYear() && orig.getMonth() == actual.getMonth() && orig.getDay() == actual.getDay() && actual.getHour() == Integer.MIN_VALUE && actual.getMinute() == Integer.MIN_VALUE && actual.getSecond() == Integer.MIN_VALUE && actual.getMillisecond() == Integer.MIN_VALUE) {
            result = orig.getTimezone() == actual.getTimezone();
        }
        return result;
    }

    protected boolean equalsTime(XMLGregorianCalendar orig, XMLGregorianCalendar actual) {
        boolean result = false;
        if (orig.getHour() == actual.getHour() && orig.getMinute() == actual.getMinute() && orig.getSecond() == actual.getSecond() && orig.getMillisecond() == actual.getMillisecond() && orig.getTimezone() == actual.getTimezone()) {
            result = true;
        }
        return result;
    }

    protected boolean equalsDateTime(XMLGregorianCalendar orig, XMLGregorianCalendar actual) {
        boolean result = false;
        if (orig.getYear() == actual.getYear() && orig.getMonth() == actual.getMonth() && orig.getDay() == actual.getDay() && orig.getHour() == actual.getHour() && orig.getMinute() == actual.getMinute() && orig.getSecond() == actual.getSecond() && orig.getMillisecond() == actual.getMillisecond()) {
            result = orig.getTimezone() == actual.getTimezone();
        }
        return result;
    }

    @Test
    public void testVoid() throws Exception {
        if (!this.shouldRunTest("Void")) {
            return;
        }
        if (testDocLiteral) {
            docClient.testVoid();
        } else if (testXMLBinding) {
            xmlClient.testVoid();
        } else {
            rpcClient.testVoid();
        }
    }

    @Test
    public void testOneway() throws Exception {
        if (!this.shouldRunTest("Oneway")) {
            return;
        }
        String x = "hello";
        String y = "oneway";
        if (testDocLiteral) {
            docClient.testOneway(x, y);
        } else if (testXMLBinding) {
            xmlClient.testOneway(x, y);
        } else {
            rpcClient.testOneway(x, y);
        }
    }

    @Test
    public void testByte() throws Exception {
        if (!this.shouldRunTest("Byte")) {
            return;
        }
        byte[][] valueSets = new byte[][]{{0, 1}, {-1, 0}, {-128, 127}};
        for (int i = 0; i < valueSets.length; ++i) {
            byte x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            byte ret = testDocLiteral ? docClient.testByte(x, y, z) : (testXMLBinding ? xmlClient.testByte(x, y, z) : rpcClient.testByte(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testByte(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testByte(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testByte(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testShort() throws Exception {
        if (!this.shouldRunTest("Short")) {
            return;
        }
        short[][] valueSets = new short[][]{{0, 1}, {-1, 0}, {Short.MIN_VALUE, Short.MAX_VALUE}};
        for (int i = 0; i < valueSets.length; ++i) {
            short x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            short ret = testDocLiteral ? docClient.testShort(x, y, z) : (testXMLBinding ? xmlClient.testShort(x, y, z) : rpcClient.testShort(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testShort(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testShort(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testShort(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testUnsignedShort() throws Exception {
        if (!this.shouldRunTest("UnsignedShort")) {
            return;
        }
        int[][] valueSets = new int[][]{{0, 1}, {1, 0}, {0, 65535}};
        for (int i = 0; i < valueSets.length; ++i) {
            int x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            int ret = testDocLiteral ? docClient.testUnsignedShort(x, y, z) : (testXMLBinding ? xmlClient.testUnsignedShort(x, y, z) : rpcClient.testUnsignedShort(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testUnsignedShort(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedShort(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedShort(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testInt() throws Exception {
        if (!this.shouldRunTest("Int")) {
            return;
        }
        int[][] valueSets = new int[][]{{5, 10}, {-10, 50}, {Integer.MIN_VALUE, Integer.MAX_VALUE}};
        for (int i = 0; i < valueSets.length; ++i) {
            int x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            int ret = testDocLiteral ? docClient.testInt(x, y, z) : (testXMLBinding ? xmlClient.testInt(x, y, z) : rpcClient.testInt(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testInt(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testInt(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testInt(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testUnsignedInt() throws Exception {
        if (!this.shouldRunTest("UnsignedInt")) {
            return;
        }
        long[][] valueSets = new long[][]{{0L, 0xFFFFFFFFL}, {11L, 20L}, {1L, 0L}};
        for (int i = 0; i < valueSets.length; ++i) {
            long x = valueSets[i][0];
            long yOrig = valueSets[i][1];
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            long ret = testDocLiteral ? docClient.testUnsignedInt(x, y, z) : (testXMLBinding ? xmlClient.testUnsignedInt(x, y, z) : rpcClient.testUnsignedInt(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testUnsignedInt(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedInt(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedInt(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testLong() throws Exception {
        if (!this.shouldRunTest("Long")) {
            return;
        }
        long[][] valueSets = new long[][]{{0L, 1L}, {-1L, 0L}, {Long.MIN_VALUE, Long.MAX_VALUE}};
        for (int i = 0; i < valueSets.length; ++i) {
            long x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            long ret = testDocLiteral ? docClient.testLong(x, y, z) : (testXMLBinding ? xmlClient.testLong(x, y, z) : rpcClient.testLong(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testLong(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testLong(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testLong(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testUnsignedLong() throws Exception {
        if (!this.shouldRunTest("UnsignedLong")) {
            return;
        }
        BigInteger[][] valueSets = new BigInteger[][]{{new BigInteger("0"), new BigInteger("1")}, {new BigInteger("1"), new BigInteger("0")}, {new BigInteger("0"), new BigInteger(String.valueOf(1L))}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigInteger x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigInteger ret = testDocLiteral ? docClient.testUnsignedLong(x, y, z) : (testXMLBinding ? xmlClient.testUnsignedLong(x, y, z) : rpcClient.testUnsignedLong(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testUnsignedLong(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedLong(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedLong(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    protected float[][] getTestFloatData() {
        return new float[][]{{0.0f, 1.0f}, {-1.0f, (float)Math.PI}, {-100.0f, 100.0f}, {Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY}};
    }

    @Test
    public void testFloat() throws Exception {
        if (!this.shouldRunTest("Float")) {
            return;
        }
        float delta = 0.0f;
        float[][] valueSets = this.getTestFloatData();
        for (int i = 0; i < valueSets.length; ++i) {
            float x = valueSets[i][0];
            Holder yOrig = new Holder((Object)Float.valueOf(valueSets[i][1]));
            Holder y = new Holder((Object)Float.valueOf(valueSets[i][1]));
            Holder z = new Holder();
            float ret = testDocLiteral ? docClient.testFloat(x, y, z) : (testXMLBinding ? xmlClient.testFloat(x, y, z) : rpcClient.testFloat(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)(i + ": testFloat(): Wrong value for inout param"), (double)x, (double)((Float)y.value).floatValue(), (double)delta);
            AbstractTypeTestClient.assertEquals((String)(i + ": testFloat(): Wrong value for out param"), (double)((Float)yOrig.value).floatValue(), (double)((Float)z.value).floatValue(), (double)delta);
            AbstractTypeTestClient.assertEquals((String)(i + ": testFloat(): Wrong return value"), (double)x, (double)ret, (double)delta);
        }
        float x = Float.NaN;
        Holder yOrig = new Holder((Object)Float.valueOf(0.0f));
        Holder y = new Holder((Object)Float.valueOf(0.0f));
        Holder z = new Holder();
        float ret = testDocLiteral ? docClient.testFloat(x, y, z) : (testXMLBinding ? xmlClient.testFloat(x, y, z) : rpcClient.testFloat(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testFloat(): Incorrect value for inout param", (boolean)Float.isNaN(((Float)y.value).floatValue()));
            AbstractTypeTestClient.assertEquals((String)"testFloat(): Incorrect value for out param", (double)((Float)yOrig.value).floatValue(), (double)((Float)z.value).floatValue(), (double)delta);
            AbstractTypeTestClient.assertTrue((String)"testFloat(): Incorrect return value", (boolean)Float.isNaN(ret));
        }
    }

    protected double[][] getTestDoubleData() {
        return new double[][]{{0.0, 1.0}, {-1.0, Math.PI}, {-100.0, 100.0}, {Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}};
    }

    @Test
    public void testDouble() throws Exception {
        if (!this.shouldRunTest("Double")) {
            return;
        }
        double delta = 0.0;
        double[][] valueSets = this.getTestDoubleData();
        for (int i = 0; i < valueSets.length; ++i) {
            double x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            double ret = testDocLiteral ? docClient.testDouble(x, y, z) : (testXMLBinding ? xmlClient.testDouble(x, y, z) : rpcClient.testDouble(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testDouble(): Incorrect value for inout param", (double)x, (double)((Double)y.value), (double)delta);
            AbstractTypeTestClient.assertEquals((String)"testDouble(): Incorrect value for out param", (double)((Double)yOrig.value), (double)((Double)z.value), (double)delta);
            AbstractTypeTestClient.assertEquals((String)"testDouble(): Incorrect return value", (double)x, (double)ret, (double)delta);
        }
        double x = Double.NaN;
        Holder yOrig = new Holder((Object)0.0);
        Holder y = new Holder((Object)0.0);
        Holder z = new Holder();
        double ret = testDocLiteral ? docClient.testDouble(x, y, z) : (testXMLBinding ? xmlClient.testDouble(x, y, z) : rpcClient.testDouble(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testDouble(): Incorrect value for inout param", (boolean)Double.isNaN((Double)y.value));
            AbstractTypeTestClient.assertEquals((String)"testDouble(): Incorrect value for out param", (double)((Double)yOrig.value), (double)((Double)z.value), (double)delta);
            AbstractTypeTestClient.assertTrue((String)"testDouble(): Incorrect return value", (boolean)Double.isNaN(ret));
        }
    }

    @Test
    public void testUnsignedByte() throws Exception {
        if (!this.shouldRunTest("UnsignedByte")) {
            return;
        }
        short[][] valueSets = new short[][]{{0, 1}, {1, 0}, {0, 255}};
        for (int i = 0; i < valueSets.length; ++i) {
            short x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            short ret = testDocLiteral ? docClient.testUnsignedByte(x, y, z) : (testXMLBinding ? xmlClient.testUnsignedByte(x, y, z) : rpcClient.testUnsignedByte(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testUnsignedByte(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedByte(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testUnsignedByte(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testBoolean() throws Exception {
        if (!this.shouldRunTest("Boolean")) {
            return;
        }
        boolean[][] valueSets = new boolean[][]{{true, false}, {true, true}, {false, true}, {false, false}};
        for (int i = 0; i < valueSets.length; ++i) {
            boolean x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            boolean ret = testDocLiteral ? docClient.testBoolean(x, y, z) : (testXMLBinding ? xmlClient.testBoolean(x, y, z) : rpcClient.testBoolean(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testBoolean(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testBoolean(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testBoolean(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testString() throws Exception {
        if (!this.shouldRunTest("String")) {
            return;
        }
        int bufferSize = 1000;
        StringBuffer buffer = new StringBuffer(bufferSize);
        StringBuffer buffer2 = new StringBuffer(bufferSize);
        for (int x = 0; x < bufferSize; ++x) {
            buffer.append((char)(97 + x % 26));
            buffer2.append((char)(65 + x % 26));
        }
        String[][] valueSets = new String[][]{{"hello", "world"}, {"is pi > 3 ?", " is pi < 4\\\""}, {"<illegal_tag/>", ""}, {buffer.toString(), buffer2.toString()}};
        for (int i = 0; i < valueSets.length; ++i) {
            String x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            String ret = testDocLiteral ? docClient.testString(x, y, z) : (testXMLBinding ? xmlClient.testString(x, y, z) : rpcClient.testString(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testString(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testString(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testString(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testStringI18N() throws Exception {
        if (!this.shouldRunTest("StringI18N")) {
            return;
        }
        String[][] valueSets = new String[][]{{"hello", I18NStrings.CHINESE_COMPLEX_STRING}, {"hello", I18NStrings.JAP_SIMPLE_STRING}};
        for (int i = 0; i < valueSets.length; ++i) {
            String x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            String ret = testDocLiteral ? docClient.testString(x, y, z) : (testXMLBinding ? xmlClient.testString(x, y, z) : rpcClient.testString(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testStringI18N(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testStringI18N(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testStringI18N(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testQName() throws Exception {
        if (!this.shouldRunTest("QName")) {
            return;
        }
        String[][] valueSets = new String[][]{{"NoNamespaceService", ""}, {"HelloWorldService", "http://www.iona.com/services"}, {I18NStrings.JAP_SIMPLE_STRING, "http://www.iona.com/iona"}, {"MyService", "http://www.iona.com/iona"}};
        for (int i = 0; i < valueSets.length; ++i) {
            QName x = new QName(valueSets[i][1], valueSets[i][0]);
            QName yOrig = new QName("http://www.iona.com/inoutqname", "InOutQName");
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            QName ret = testDocLiteral ? docClient.testQName(x, y, z) : (testXMLBinding ? xmlClient.testQName(x, y, z) : rpcClient.testQName(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testQName(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testQName(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testQName(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testDate() throws Exception {
        if (!this.shouldRunTest("Date")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar();
        x.setYear(1975);
        x.setMonth(5);
        x.setDay(5);
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar();
        yOrig.setYear(2004);
        yOrig.setMonth(4);
        yOrig.setDay(1);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testDate(x, y, z) : (testXMLBinding ? xmlClient.testDate(x, y, z) : rpcClient.testDate(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)("testDate(): Incorrect value for inout param " + x + " != " + y.value), (boolean)this.equalsDate(x, (XMLGregorianCalendar)y.value));
            AbstractTypeTestClient.assertTrue((String)"testDate(): Incorrect value for out param", (boolean)this.equalsDate(yOrig, (XMLGregorianCalendar)z.value));
            AbstractTypeTestClient.assertTrue((String)"testDate(): Incorrect return value", (boolean)this.equalsDate(x, ret));
        }
        x = datatypeFactory.newXMLGregorianCalendar();
        yOrig = datatypeFactory.newXMLGregorianCalendar();
        y = new Holder((Object)yOrig);
        z = new Holder();
        try {
            ret = testDocLiteral ? docClient.testDate(x, y, z) : rpcClient.testDate(x, y, z);
            AbstractTypeTestClient.fail((String)"Expected to catch WebServiceException when calling testDate() with uninitialized parameters.");
        }
        catch (RuntimeException re) {
            AbstractTypeTestClient.assertNotNull((Object)re);
        }
    }

    @Test
    public void testDateTime() throws Exception {
        if (!this.shouldRunTest("DateTime")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar();
        x.setYear(1975);
        x.setMonth(5);
        x.setDay(5);
        x.setHour(12);
        x.setMinute(30);
        x.setSecond(15);
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar();
        yOrig.setYear(2005);
        yOrig.setMonth(4);
        yOrig.setDay(1);
        yOrig.setHour(17);
        yOrig.setMinute(59);
        yOrig.setSecond(30);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testDateTime(x, y, z) : (testXMLBinding ? xmlClient.testDateTime(x, y, z) : rpcClient.testDateTime(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testDateTime(): Incorrect value for inout param", (boolean)this.equalsDateTime(x, (XMLGregorianCalendar)y.value));
            AbstractTypeTestClient.assertTrue((String)"testDateTime(): Incorrect value for out param", (boolean)this.equalsDateTime(yOrig, (XMLGregorianCalendar)z.value));
            AbstractTypeTestClient.assertTrue((String)"testDateTime(): Incorrect return value", (boolean)this.equalsDateTime(x, ret));
        }
    }

    @Test
    public void testTime() throws Exception {
        if (!this.shouldRunTest("Time")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar();
        x.setHour(12);
        x.setMinute(14);
        x.setSecond(5);
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar();
        yOrig.setHour(22);
        yOrig.setMinute(4);
        yOrig.setSecond(15);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testTime(x, y, z) : (testXMLBinding ? xmlClient.testTime(x, y, z) : rpcClient.testTime(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testTime(): Incorrect value for inout param", (boolean)this.equalsTime(x, (XMLGregorianCalendar)y.value));
            AbstractTypeTestClient.assertTrue((String)"testTime(): Incorrect value for out param", (boolean)this.equalsTime(yOrig, (XMLGregorianCalendar)z.value));
            AbstractTypeTestClient.assertTrue((String)"testTime(): Incorrect return value", (boolean)this.equalsTime(x, ret));
        }
    }

    @Test
    public void testGYear() throws Exception {
        if (!this.shouldRunTest("GYear")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar("2004");
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar("2003+05:00");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testGYear(x, y, z) : (testXMLBinding ? xmlClient.testGYear(x, y, z) : rpcClient.testGYear(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testGYear(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testGYear(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testGYear(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testGYearMonth() throws Exception {
        if (!this.shouldRunTest("GYearMonth")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar("2004-08");
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar("2003-12+05:00");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testGYearMonth(x, y, z) : (testXMLBinding ? xmlClient.testGYearMonth(x, y, z) : rpcClient.testGYearMonth(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testGYearMonth(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testGYearMonth(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testGYearMonth(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testGMonth() throws Exception {
        XMLGregorianCalendar yOrig;
        XMLGregorianCalendar x;
        if (!this.shouldRunTest("GMonth")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        try {
            x = datatypeFactory.newXMLGregorianCalendar("--08");
            yOrig = datatypeFactory.newXMLGregorianCalendar("--12+05:00");
        }
        catch (IllegalArgumentException iae) {
            x = datatypeFactory.newXMLGregorianCalendar("--08--");
            yOrig = datatypeFactory.newXMLGregorianCalendar("--12--+05:00");
        }
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testGMonth(x, y, z) : (testXMLBinding ? xmlClient.testGMonth(x, y, z) : rpcClient.testGMonth(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testGMonth(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testGMonth(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testGMonth(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testGMonthDay() throws Exception {
        if (!this.shouldRunTest("GMonthDay")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar("--08-21");
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar("--12-05+05:00");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testGMonthDay(x, y, z) : (testXMLBinding ? xmlClient.testGMonthDay(x, y, z) : rpcClient.testGMonthDay(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testGMonthDay(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testGMonthDay(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testGMonthDay(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testGDay() throws Exception {
        if (!this.shouldRunTest("GDay")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar x = datatypeFactory.newXMLGregorianCalendar("---21");
        XMLGregorianCalendar yOrig = datatypeFactory.newXMLGregorianCalendar("---05+05:00");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        XMLGregorianCalendar ret = testDocLiteral ? docClient.testGDay(x, y, z) : (testXMLBinding ? xmlClient.testGDay(x, y, z) : rpcClient.testGDay(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testGDay(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testGDay(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testGDay(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testDuration() throws Exception {
        if (!this.shouldRunTest("Duration")) {
            return;
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        Duration x = datatypeFactory.newDuration("P1Y35DT60M60.500S");
        Duration yOrig = datatypeFactory.newDuration("-P2MT24H60S");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        Duration ret = testDocLiteral ? docClient.testDuration(x, y, z) : (testXMLBinding ? xmlClient.testDuration(x, y, z) : rpcClient.testDuration(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testDuration(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testDuration(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testDuration(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testNormalizedString() throws Exception {
        if (!this.shouldRunTest("NormalizedString")) {
            return;
        }
        String x = "  normalized string ";
        String yOrig = "  another normalized  string ";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testNormalizedString(x, y, z) : (testXMLBinding ? xmlClient.testNormalizedString(x, y, z) : rpcClient.testNormalizedString(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testNormalizedString(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testNormalizedString(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testNormalizedString(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testToken() throws Exception {
        if (!this.shouldRunTest("Token")) {
            return;
        }
        String x = "token";
        String yOrig = "another token";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testToken(x, y, z) : (testXMLBinding ? xmlClient.testToken(x, y, z) : rpcClient.testToken(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testToken(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testToken(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testToken(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testLanguage() throws Exception {
        if (!this.shouldRunTest("Language")) {
            return;
        }
        String x = "abc";
        String yOrig = "abc-def";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testLanguage(x, y, z) : (testXMLBinding ? xmlClient.testLanguage(x, y, z) : rpcClient.testLanguage(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testLanguage(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testLanguage(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testLanguage(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testNMTOKEN() throws Exception {
        if (!this.shouldRunTest("NMTOKEN")) {
            return;
        }
        String x = "123:abc";
        String yOrig = "abc.-_:";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testNMTOKEN(x, y, z) : (testXMLBinding ? xmlClient.testNMTOKEN(x, y, z) : rpcClient.testNMTOKEN(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testNMTOKEN(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testNMTOKEN(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testNMTOKEN(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testNMTOKENS() throws Exception {
        if (!this.shouldRunTest("NMTOKENS")) {
            return;
        }
        if (testDocLiteral) {
            List<String> x = Arrays.asList("123:abc");
            List<String> yOrig = Arrays.asList("abc.-_:", "a");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List ret = docClient.testNMTOKENS(x, y, z);
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect return value", (boolean)((Object)x).equals(ret));
        } else if (testXMLBinding) {
            List<String> x = Arrays.asList("123:abc");
            List<String> yOrig = Arrays.asList("abc.-_:", "a");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List ret = xmlClient.testNMTOKENS(x, y, z);
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect return value", (boolean)((Object)x).equals(ret));
        } else {
            Object[] x = new String[]{"123:abc"};
            Object[] yOrig = new String[]{"abc.-_:", "a"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            Object[] ret = rpcClient.testNMTOKENS((String[])x, y, z);
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect value for inout param", (boolean)Arrays.equals(x, (Object[])y.value));
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect value for out param", (boolean)Arrays.equals(yOrig, (Object[])z.value));
            AbstractTypeTestClient.assertTrue((String)"testNMTOKENS(): Incorrect return value", (boolean)Arrays.equals(x, ret));
        }
    }

    @Test
    public void testName() throws Exception {
        if (!this.shouldRunTest("Name")) {
            return;
        }
        String x = "abc:123";
        String yOrig = "abc.-_";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testName(x, y, z) : (testXMLBinding ? xmlClient.testName(x, y, z) : rpcClient.testName(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testName(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testName(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testName(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testNCName() throws Exception {
        if (!this.shouldRunTest("NCName")) {
            return;
        }
        String x = "abc-123";
        String yOrig = "abc.-";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testNCName(x, y, z) : (testXMLBinding ? xmlClient.testNCName(x, y, z) : rpcClient.testNCName(x, y, z));
        AbstractTypeTestClient.assertTrue((String)"testNCName(): Incorrect value for inout param", (boolean)x.equals(y.value));
        AbstractTypeTestClient.assertTrue((String)"testNCName(): Incorrect value for out param", (boolean)yOrig.equals(z.value));
        AbstractTypeTestClient.assertTrue((String)"testNCName(): Incorrect return value", (boolean)x.equals(ret));
    }

    @Test
    public void testID() throws Exception {
        if (!this.shouldRunTest("ID")) {
            return;
        }
        String[][] valueSets = new String[][]{{"root.id-testartix.2", "L.-type_test"}, {"_iona.com", "zoo-5_wolf"}, {"x-_liberty", "_-.-_"}};
        for (int i = 0; i < valueSets.length; ++i) {
            String x = valueSets[i][0];
            String yOrig = valueSets[i][1];
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            if (testDocLiteral) {
                docClient.testID(x, y, z);
            } else if (testXMLBinding) {
                xmlClient.testID(x, y, z);
            } else {
                rpcClient.testID(x, y, z);
            }
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testID(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testID(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
        }
    }

    @Test
    public void testDecimal() throws Exception {
        if (!this.shouldRunTest("Decimal")) {
            return;
        }
        BigDecimal[][] valueSets = new BigDecimal[][]{{new BigDecimal("-1234567890.000000"), new BigDecimal("1234567890.000000")}, {new BigDecimal("-" + String.valueOf(1L) + ".000000"), new BigDecimal(String.valueOf(1L) + ".000000")}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigDecimal x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigDecimal ret = testDocLiteral ? docClient.testDecimal(x, y, z) : (testXMLBinding ? xmlClient.testDecimal(x, y, z) : rpcClient.testDecimal(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testDecimal(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testDecimal(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testDecimal(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testInteger() throws Exception {
        if (!this.shouldRunTest("Integer")) {
            return;
        }
        BigInteger[][] valueSets = new BigInteger[][]{{new BigInteger("-1234567890"), new BigInteger("1234567890")}, {new BigInteger("-" + String.valueOf(1L)), new BigInteger(String.valueOf(1L))}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigInteger x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigInteger ret = testDocLiteral ? docClient.testInteger(x, y, z) : (testXMLBinding ? xmlClient.testInteger(x, y, z) : rpcClient.testInteger(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testInteger(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testInteger(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testInteger(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testPositiveInteger() throws Exception {
        if (!this.shouldRunTest("PositiveInteger")) {
            return;
        }
        BigInteger[][] valueSets = new BigInteger[][]{{new BigInteger("1"), new BigInteger("1234567890")}, {new BigInteger(String.valueOf(1)), new BigInteger(String.valueOf(1L))}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigInteger x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigInteger ret = testDocLiteral ? docClient.testPositiveInteger(x, y, z) : (testXMLBinding ? xmlClient.testPositiveInteger(x, y, z) : rpcClient.testPositiveInteger(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testPositiveInteger(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testPositiveInteger(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testPositiveInteger(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testNonPositiveInteger() throws Exception {
        if (!this.shouldRunTest("NonPositiveInteger")) {
            return;
        }
        BigInteger[][] valueSets = new BigInteger[][]{{new BigInteger("0"), new BigInteger("-1234567890")}, {new BigInteger("-" + String.valueOf(1)), new BigInteger("-" + String.valueOf(1L))}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigInteger x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigInteger ret = testDocLiteral ? docClient.testNonPositiveInteger(x, y, z) : (testXMLBinding ? xmlClient.testNonPositiveInteger(x, y, z) : rpcClient.testNonPositiveInteger(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testNonPositiveInteger(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testNonPositiveInteger(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testNonPositiveInteger(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testNegativeInteger() throws Exception {
        if (!this.shouldRunTest("NegativeInteger")) {
            return;
        }
        BigInteger[][] valueSets = new BigInteger[][]{{new BigInteger("-1"), new BigInteger("-1234567890")}, {new BigInteger("-" + String.valueOf(1)), new BigInteger("-" + String.valueOf(1L))}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigInteger x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigInteger ret = testDocLiteral ? docClient.testNegativeInteger(x, y, z) : (testXMLBinding ? xmlClient.testNegativeInteger(x, y, z) : rpcClient.testNegativeInteger(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testNegativeInteger(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testNegativeInteger(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testNegativeInteger(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testNonNegativeInteger() throws Exception {
        if (!this.shouldRunTest("NonNegativeInteger")) {
            return;
        }
        BigInteger[][] valueSets = new BigInteger[][]{{new BigInteger("0"), new BigInteger("1234567890")}, {new BigInteger(String.valueOf(1)), new BigInteger(String.valueOf(1L))}};
        for (int i = 0; i < valueSets.length; ++i) {
            BigInteger x = valueSets[i][0];
            Holder yOrig = new Holder((Object)valueSets[i][1]);
            Holder y = new Holder((Object)valueSets[i][1]);
            Holder z = new Holder();
            BigInteger ret = testDocLiteral ? docClient.testNonNegativeInteger(x, y, z) : (testXMLBinding ? xmlClient.testNonNegativeInteger(x, y, z) : rpcClient.testNonNegativeInteger(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testNonNegativeInteger(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testNonNegativeInteger(): Incorrect value for out param", (Object)yOrig.value, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testNonNegativeInteger(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testHexBinary() throws Exception {
        if (!this.shouldRunTest("HexBinary")) {
            return;
        }
        byte[] x = "hello".getBytes();
        Holder y = new Holder((Object)"goodbye".getBytes());
        Holder yOriginal = new Holder((Object)"goodbye".getBytes());
        Holder z = new Holder();
        byte[] ret = testDocLiteral ? docClient.testHexBinary(x, y, z) : (testXMLBinding ? xmlClient.testHexBinary(x, y, z) : rpcClient.testHexBinary(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testHexBinary(): Incorrect value for inout param", (boolean)Arrays.equals(x, (byte[])y.value));
            AbstractTypeTestClient.assertTrue((String)"testHexBinary(): Incorrect value for out param", (boolean)Arrays.equals((byte[])yOriginal.value, (byte[])z.value));
            AbstractTypeTestClient.assertTrue((String)"testHexBinary(): Incorrect return value", (boolean)Arrays.equals(x, ret));
        }
    }

    @Test
    public void testBase64Binary() throws Exception {
        if (!this.shouldRunTest("Base64Binary")) {
            return;
        }
        byte[] x = "hello".getBytes();
        Holder y = new Holder((Object)"goodbye".getBytes());
        Holder yOriginal = new Holder((Object)"goodbye".getBytes());
        Holder z = new Holder();
        byte[] ret = testDocLiteral ? docClient.testBase64Binary(x, y, z) : (testXMLBinding ? xmlClient.testBase64Binary(x, y, z) : rpcClient.testBase64Binary(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testBase64Binary(): Incorrect value for inout param", (boolean)Arrays.equals(x, (byte[])y.value));
            AbstractTypeTestClient.assertTrue((String)"testBase64Binary(): Incorrect value for out param", (boolean)Arrays.equals((byte[])yOriginal.value, (byte[])z.value));
            AbstractTypeTestClient.assertTrue((String)"testBase64Binary(): Incorrect return value", (boolean)Arrays.equals(x, ret));
        }
        try {
            y = new Holder();
            z = new Holder();
            if (testDocLiteral) {
                docClient.testBase64Binary(x, y, z);
            } else if (testXMLBinding) {
                xmlClient.testBase64Binary(x, y, z);
            } else {
                rpcClient.testBase64Binary(x, y, z);
            }
            AbstractTypeTestClient.fail((String)"Uninitialized Holder for inout parameter should have thrown an error.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testAnyURI() throws Exception {
        if (!this.shouldRunTest("AnyURI")) {
            return;
        }
        String[][] valueSets = new String[][]{{"file:///root%20%20/-;?&+", "file:///w:/test!artix~java*"}, {"http://iona.com/", "file:///z:/mail_iona=com,'xmlbus'"}, {"mailto:windows@systems", "file:///"}};
        for (int i = 0; i < valueSets.length; ++i) {
            String x = new String(valueSets[i][0]);
            String yOrig = new String(valueSets[i][1]);
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            String ret = testDocLiteral ? docClient.testAnyURI(x, y, z) : (testXMLBinding ? xmlClient.testAnyURI(x, y, z) : rpcClient.testAnyURI(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testAnyURI(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testAnyURI(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testAnyURI(): Incorrect return value", (Object)x, (Object)ret);
        }
    }

    @Test
    public void testColourEnum() throws Exception {
        if (!this.shouldRunTest("ColourEnum")) {
            return;
        }
        String[] xx = new String[]{"RED", "GREEN", "BLUE"};
        String[] yy = new String[]{"GREEN", "BLUE", "RED"};
        Holder z = new Holder();
        for (int i = 0; i < 3; ++i) {
            ColourEnum x = ColourEnum.fromValue((String)xx[i]);
            ColourEnum yOrig = ColourEnum.fromValue((String)yy[i]);
            Holder y = new Holder((Object)yOrig);
            ColourEnum ret = testDocLiteral ? docClient.testColourEnum(x, y, z) : (testXMLBinding ? xmlClient.testColourEnum(x, y, z) : rpcClient.testColourEnum(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testColourEnum(): Incorrect value for inout param", (Object)x.value(), (Object)((ColourEnum)y.value).value());
            AbstractTypeTestClient.assertEquals((String)"testColourEnum(): Incorrect value for out param", (Object)yOrig.value(), (Object)((ColourEnum)z.value).value());
            AbstractTypeTestClient.assertEquals((String)"testColourEnum(): Incorrect return value", (Object)x.value(), (Object)ret.value());
        }
    }

    @Test
    public void testNumberEnum() throws Exception {
        if (!this.shouldRunTest("NumberEnum")) {
            return;
        }
        int[] xx = new int[]{1, 2, 3};
        int[] yy = new int[]{3, 1, 2};
        Holder z = new Holder();
        for (int i = 0; i < 3; ++i) {
            NumberEnum x = NumberEnum.fromValue((int)xx[i]);
            NumberEnum yOrig = NumberEnum.fromValue((int)yy[i]);
            Holder y = new Holder((Object)yOrig);
            NumberEnum ret = testDocLiteral ? docClient.testNumberEnum(x, y, z) : (testXMLBinding ? xmlClient.testNumberEnum(x, y, z) : rpcClient.testNumberEnum(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testNumberEnum(): Incorrect value for inout param", (Object)x.value(), (Object)((NumberEnum)y.value).value());
            AbstractTypeTestClient.assertEquals((String)"testNumberEnum(): Incorrect value for out param", (Object)yOrig.value(), (Object)((NumberEnum)z.value).value());
            AbstractTypeTestClient.assertEquals((String)"testNumberEnum(): Incorrect return value", (Object)x.value(), (Object)ret.value());
        }
    }

    @Test
    public void testStringEnum() throws Exception {
        if (!this.shouldRunTest("StringEnum")) {
            return;
        }
        String[] xx = new String[]{"a b c", "d e f", "g h i"};
        String[] yy = new String[]{"g h i", "a b c", "d e f"};
        Holder z = new Holder();
        for (int i = 0; i < 3; ++i) {
            StringEnum x = StringEnum.fromValue((String)xx[i]);
            StringEnum yOrig = StringEnum.fromValue((String)yy[i]);
            Holder y = new Holder((Object)yOrig);
            StringEnum ret = testDocLiteral ? docClient.testStringEnum(x, y, z) : (testXMLBinding ? xmlClient.testStringEnum(x, y, z) : rpcClient.testStringEnum(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testStringEnum(): Incorrect value for inout param", (Object)x.value(), (Object)((StringEnum)y.value).value());
            AbstractTypeTestClient.assertEquals((String)"testStringEnum(): Incorrect value for out param", (Object)yOrig.value(), (Object)((StringEnum)z.value).value());
            AbstractTypeTestClient.assertEquals((String)"testStringEnum(): Incorrect return value", (Object)x.value(), (Object)ret.value());
        }
    }

    @Test
    public void testDecimalEnum() throws Exception {
        if (!this.shouldRunTest("DecimalEnum")) {
            return;
        }
        BigDecimal[] xx = new BigDecimal[]{new BigDecimal("-10.34"), new BigDecimal("11.22"), new BigDecimal("14.55")};
        BigDecimal[] yy = new BigDecimal[]{new BigDecimal("14.55"), new BigDecimal("-10.34"), new BigDecimal("11.22")};
        Holder z = new Holder();
        for (int i = 0; i < 3; ++i) {
            DecimalEnum x = DecimalEnum.fromValue((BigDecimal)xx[i]);
            DecimalEnum yOrig = DecimalEnum.fromValue((BigDecimal)yy[i]);
            Holder y = new Holder((Object)yOrig);
            DecimalEnum ret = testDocLiteral ? docClient.testDecimalEnum(x, y, z) : (testXMLBinding ? xmlClient.testDecimalEnum(x, y, z) : rpcClient.testDecimalEnum(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testDecimalEnum(): Incorrect value for inout param", (Object)x.value(), (Object)((DecimalEnum)y.value).value());
            AbstractTypeTestClient.assertEquals((String)"testDecimalEnum(): Incorrect value for out param", (Object)yOrig.value(), (Object)((DecimalEnum)z.value).value());
            AbstractTypeTestClient.assertEquals((String)"testDecimalEnum(): Incorrect return value", (Object)x.value(), (Object)ret.value());
        }
    }

    @Test
    public void testNMTokenEnum() throws Exception {
        if (!this.shouldRunTest("NMTokenEnum")) {
            return;
        }
        String[] xx = new String[]{"hello", "there"};
        String[] yy = new String[]{"there", "hello"};
        Holder z = new Holder();
        for (int i = 0; i < 2; ++i) {
            NMTokenEnum x = NMTokenEnum.fromValue((String)xx[i]);
            NMTokenEnum yOrig = NMTokenEnum.fromValue((String)yy[i]);
            Holder y = new Holder((Object)yOrig);
            NMTokenEnum ret = testDocLiteral ? docClient.testNMTokenEnum(x, y, z) : (testXMLBinding ? xmlClient.testNMTokenEnum(x, y, z) : rpcClient.testNMTokenEnum(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testNMTokenEnum(): Incorrect value for inout param", (Object)x.value(), (Object)((NMTokenEnum)y.value).value());
            AbstractTypeTestClient.assertEquals((String)"testNMTokenEnum(): Incorrect value for out param", (Object)yOrig.value(), (Object)((NMTokenEnum)z.value).value());
            AbstractTypeTestClient.assertEquals((String)"testNMTokenEnum(): Incorrect return value", (Object)x.value(), (Object)ret.value());
        }
    }

    @Test
    public void testAnyURIEnum() throws Exception {
        if (!this.shouldRunTest("AnyURIEnum")) {
            return;
        }
        String[] xx = new String[]{"http://www.iona.com", "http://www.google.com"};
        String[] yy = new String[]{"http://www.google.com", "http://www.iona.com"};
        Holder z = new Holder();
        for (int i = 0; i < 2; ++i) {
            AnyURIEnum x = AnyURIEnum.fromValue((String)xx[i]);
            AnyURIEnum yOrig = AnyURIEnum.fromValue((String)yy[i]);
            Holder y = new Holder((Object)yOrig);
            AnyURIEnum ret = testDocLiteral ? docClient.testAnyURIEnum(x, y, z) : (testXMLBinding ? xmlClient.testAnyURIEnum(x, y, z) : rpcClient.testAnyURIEnum(x, y, z));
            if (this.perfTestOnly) continue;
            AbstractTypeTestClient.assertEquals((String)"testAnyURIEnum(): Incorrect value for inout param", (Object)x.value(), (Object)((AnyURIEnum)y.value).value());
            AbstractTypeTestClient.assertEquals((String)"testAnyURIEnum(): Incorrect value for out param", (Object)yOrig.value(), (Object)((AnyURIEnum)z.value).value());
            AbstractTypeTestClient.assertEquals((String)"testAnyURIEnum(): Incorrect return value", (Object)x.value(), (Object)ret.value());
        }
    }

    @Test
    public void testSimpleRestriction() throws Exception {
        if (!this.shouldRunTest("SimpleRestriction")) {
            return;
        }
        String x = "string_x";
        String yOrig = "string_y";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testSimpleRestriction(x, y, z) : (testXMLBinding ? xmlClient.testSimpleRestriction(x, y, z) : rpcClient.testSimpleRestriction(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            x = "string_xxxxx";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = docClient.testSimpleRestriction(x, y, z);
                AbstractTypeTestClient.fail((String)"x parameter maxLength=10 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
            x = "string_x";
            yOrig = "string_yyyyyy";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleRestriction(x, y, z) : xmlClient.testSimpleRestriction(x, y, z);
                AbstractTypeTestClient.fail((String)"y parameter maxLength=10 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleRestriction2() throws Exception {
        if (!this.shouldRunTest("SimpleRestriction2")) {
            return;
        }
        String x = "str_x";
        String yOrig = "string_yyy";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testSimpleRestriction2(x, y, z) : (testXMLBinding ? xmlClient.testSimpleRestriction2(x, y, z) : rpcClient.testSimpleRestriction2(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction2(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction2(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction2(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            x = "str";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleRestriction2(x, y, z) : xmlClient.testSimpleRestriction2(x, y, z);
                AbstractTypeTestClient.fail((String)"minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleRestriction3() throws Exception {
        if (!this.shouldRunTest("SimpleRestriction3")) {
            return;
        }
        String x = "str_x";
        String yOrig = "string_yyy";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testSimpleRestriction3(x, y, z) : (testXMLBinding ? xmlClient.testSimpleRestriction3(x, y, z) : rpcClient.testSimpleRestriction3(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction3(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction3(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction3(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            x = "str";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = docClient.testSimpleRestriction3(x, y, z);
                AbstractTypeTestClient.fail((String)"x parameter maxLength=10 && minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
            x = "string_x";
            yOrig = "string_yyyyyy";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleRestriction3(x, y, z) : xmlClient.testSimpleRestriction3(x, y, z);
                AbstractTypeTestClient.fail((String)"y parameter maxLength=10 && minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleRestriction4() throws Exception {
        if (!this.shouldRunTest("SimpleRestriction4")) {
            return;
        }
        String x = "x";
        String yOrig = "y";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testSimpleRestriction4(x, y, z) : (testXMLBinding ? xmlClient.testSimpleRestriction4(x, y, z) : rpcClient.testSimpleRestriction4(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction4(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction4(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction4(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            x = "str";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleRestriction4(x, y, z) : xmlClient.testSimpleRestriction4(x, y, z);
                AbstractTypeTestClient.fail((String)"x parameter minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleRestriction5() throws Exception {
        if (!this.shouldRunTest("SimpleRestriction5")) {
            return;
        }
        String x = "str_x";
        String yOrig = "string_yyy";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testSimpleRestriction5(x, y, z) : (testXMLBinding ? xmlClient.testSimpleRestriction5(x, y, z) : rpcClient.testSimpleRestriction5(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction5(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction5(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction5(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            x = "str";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = docClient.testSimpleRestriction5(x, y, z);
                AbstractTypeTestClient.fail((String)"maxLength=10 && minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
            x = "string_x";
            yOrig = "string_yyyyyy";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleRestriction5(x, y, z) : xmlClient.testSimpleRestriction5(x, y, z);
                AbstractTypeTestClient.fail((String)"maxLength=10 && minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleRestriction6() throws Exception {
        if (!this.shouldRunTest("SimpleRestriction6")) {
            return;
        }
        String x = "str_x";
        String yOrig = "y";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testSimpleRestriction6(x, y, z) : (testXMLBinding ? xmlClient.testSimpleRestriction6(x, y, z) : rpcClient.testSimpleRestriction6(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction6(): Incorrect value for inout param", (Object)x, (Object)y.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction6(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
            AbstractTypeTestClient.assertEquals((String)"testSimpleRestriction6(): Incorrect return value", (Object)x, (Object)ret);
        }
        if (testDocLiteral || testXMLBinding) {
            x = "string_x";
            yOrig = "string_y";
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleRestriction6(x, y, z) : xmlClient.testSimpleRestriction6(x, y, z);
                AbstractTypeTestClient.fail((String)"maxLength=10 && minLength=5 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testHexBinaryRestriction() throws Exception {
        if (!this.shouldRunTest("HexBinaryRestriction")) {
            return;
        }
        byte[] x = "x".getBytes();
        byte[] yOrig = "string_yyy".getBytes();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        byte[] ret = testDocLiteral ? docClient.testHexBinaryRestriction(x, y, z) : (testXMLBinding ? xmlClient.testHexBinaryRestriction(x, y, z) : rpcClient.testHexBinaryRestriction(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testHexBinaryRestriction(): Incorrect value for inout param", (boolean)this.equals(x, (byte[])y.value));
            AbstractTypeTestClient.assertTrue((String)"testHexBinaryRestriction(): Incorrect value for out param", (boolean)this.equals(yOrig, (byte[])z.value));
            AbstractTypeTestClient.assertTrue((String)"testHexBinaryRestriction(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        if (testDocLiteral || testXMLBinding) {
            x = "".getBytes();
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = docClient.testHexBinaryRestriction(x, y, z);
                AbstractTypeTestClient.fail((String)"maxLength=10 && minLength=1 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
            x = "string_x".getBytes();
            yOrig = "string_yyyyyy".getBytes();
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testHexBinaryRestriction(x, y, z) : xmlClient.testHexBinaryRestriction(x, y, z);
                AbstractTypeTestClient.fail((String)"maxLength=10 && minLength=1 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected boolean equals(byte[] x, byte[] y) {
        String xx = IOUtils.newStringFromBytes((byte[])x);
        String yy = IOUtils.newStringFromBytes((byte[])y);
        return xx.equals(yy);
    }

    @Test
    public void testBase64BinaryRestriction() throws Exception {
        if (!this.shouldRunTest("Base64BinaryRestriction")) {
            return;
        }
        byte[] x = "string_xxx".getBytes();
        byte[] yOrig = "string_yyy".getBytes();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        byte[] ret = testDocLiteral ? docClient.testBase64BinaryRestriction(x, y, z) : (testXMLBinding ? xmlClient.testBase64BinaryRestriction(x, y, z) : rpcClient.testBase64BinaryRestriction(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient.assertTrue((String)"testBase64BinaryRestriction(): Incorrect value for inout param", (boolean)this.equals(x, (byte[])y.value));
            AbstractTypeTestClient.assertTrue((String)"testBase64BinaryRestriction(): Incorrect value for out param", (boolean)this.equals(yOrig, (byte[])z.value));
            AbstractTypeTestClient.assertTrue((String)"testBase64BinaryRestriction(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        if (testDocLiteral) {
            x = "string_xxxxx".getBytes();
            y = new Holder((Object)yOrig);
            z = new Holder();
            try {
                ret = docClient.testBase64BinaryRestriction(x, y, z);
                AbstractTypeTestClient.fail((String)"length=10 restriction is violated.");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSimpleListRestriction2() throws Exception {
        if (!this.shouldRunTest("SimpleListRestriction2")) {
            return;
        }
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<String> x = Arrays.asList("I", "am", "SimpleList");
            List<String> yOrig = Arrays.asList("Does", "SimpleList", "Work");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testSimpleListRestriction2(x, y, z) : xmlClient.testSimpleListRestriction2(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient.assertTrue((String)"testStringList(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
                AbstractTypeTestClient.assertTrue((String)"testStringList(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
                AbstractTypeTestClient.assertTrue((String)"testStringList(): Incorrect return value", (boolean)((Object)x).equals(ret));
            }
            x = new ArrayList<String>();
            y = new Holder(yOrig);
            z = new Holder();
            try {
                ret = testDocLiteral ? docClient.testSimpleListRestriction2(x, y, z) : xmlClient.testSimpleListRestriction2(x, y, z);
                AbstractTypeTestClient.fail((String)"length=10 restriction is violated.");
            }
            catch (Exception ex) {}
        } else {
            String[] x = new String[]{"I", "am", "SimpleList"};
            String[] yOrig = new String[]{"Does", "SimpleList", "Work"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            String[] ret = rpcClient.testSimpleListRestriction2(x, y, z);
            AbstractTypeTestClient.assertTrue((((String[])y.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((((String[])z.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((ret.length == 3 ? 1 : 0) != 0);
            if (!this.perfTestOnly) {
                for (int i = 0; i < 3; ++i) {
                    AbstractTypeTestClient.assertEquals((String)"testStringList(): Incorrect value for inout param", (Object)x[i], (Object)((String[])y.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testStringList(): Incorrect value for out param", (Object)yOrig[i], (Object)((String[])z.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testStringList(): Incorrect return value", (Object)x[i], (Object)ret[i]);
                }
            }
        }
    }

    @Test
    public void testStringList() throws Exception {
        if (!this.shouldRunTest("StringList")) {
            return;
        }
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<String> x = Arrays.asList("I", "am", "SimpleList");
            List<String> yOrig = Arrays.asList("Does", "SimpleList", "Work");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testStringList(x, y, z) : xmlClient.testStringList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient.assertTrue((String)"testStringList(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
                AbstractTypeTestClient.assertTrue((String)"testStringList(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
                AbstractTypeTestClient.assertTrue((String)"testStringList(): Incorrect return value", (boolean)((Object)x).equals(ret));
            }
            if (testDocLiteral) {
                try {
                    ret = docClient.testStringList(null, y, z);
                }
                catch (SOAPFaultException ex) {
                    AbstractTypeTestClient.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("Unmarshalling"));
                }
            }
        } else {
            String[] x = new String[]{"I", "am", "SimpleList"};
            String[] yOrig = new String[]{"Does", "SimpleList", "Work"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            String[] ret = rpcClient.testStringList(x, y, z);
            AbstractTypeTestClient.assertTrue((((String[])y.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((((String[])z.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((ret.length == 3 ? 1 : 0) != 0);
            if (!this.perfTestOnly) {
                for (int i = 0; i < 3; ++i) {
                    AbstractTypeTestClient.assertEquals((String)"testStringList(): Incorrect value for inout param", (Object)x[i], (Object)((String[])y.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testStringList(): Incorrect value for out param", (Object)yOrig[i], (Object)((String[])z.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testStringList(): Incorrect return value", (Object)x[i], (Object)ret[i]);
                }
            }
        }
    }

    @Test
    public void testNumberList() throws Exception {
        if (!this.shouldRunTest("NumberList")) {
            return;
        }
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<Integer> x = Arrays.asList(1, 2, 3);
            List<Integer> yOrig = Arrays.asList(10, 100, 1000);
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testNumberList(x, y, z) : xmlClient.testNumberList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient.assertTrue((String)"testNumberList(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
                AbstractTypeTestClient.assertTrue((String)"testNumberList(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
                AbstractTypeTestClient.assertTrue((String)"testNumberList(): Incorrect return value", (boolean)((Object)x).equals(ret));
            }
        } else {
            Integer[] x = new Integer[]{1, 2, 3};
            Integer[] yOrig = new Integer[]{10, 100, 1000};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            Integer[] ret = rpcClient.testNumberList(x, y, z);
            AbstractTypeTestClient.assertTrue((((Integer[])y.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((((Integer[])z.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((ret.length == 3 ? 1 : 0) != 0);
            if (!this.perfTestOnly) {
                for (int i = 0; i < 3; ++i) {
                    AbstractTypeTestClient.assertEquals((String)"testNumberList(): Incorrect value for inout param", (Object)x[i], (Object)((Integer[])y.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testNumberList(): Incorrect value for out param", (Object)yOrig[i], (Object)((Integer[])z.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testNumberList(): Incorrect return value", (Object)x[i], (Object)ret[i]);
                }
            }
        }
    }

    @Test
    public void testQNameList() throws Exception {
        if (!this.shouldRunTest("QNameList")) {
            return;
        }
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<QName> x = Arrays.asList(new QName("http://schemas.iona.com/type_test", "testqname1"), new QName("http://schemas.iona.com/type_test", "testqname2"), new QName("http://schemas.iona.com/type_test", "testqname3"));
            List<QName> yOrig = Arrays.asList(new QName("http://schemas.iona.com/type_test", "testqname4"), new QName("http://schemas.iona.com/type_test", "testqname5"), new QName("http://schemas.iona.com/type_test", "testqname6"));
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testQNameList(x, y, z) : xmlClient.testQNameList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient.assertTrue((String)"testQNameList(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
                AbstractTypeTestClient.assertTrue((String)"testQNameList(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
                AbstractTypeTestClient.assertTrue((String)"testQNameList(): Incorrect return value", (boolean)((Object)x).equals(ret));
            }
        } else {
            QName[] x = new QName[]{new QName("http://schemas.iona.com/type_test", "testqname1"), new QName("http://schemas.iona.com/type_test", "testqname2"), new QName("http://schemas.iona.com/type_test", "testqname3")};
            QName[] yOrig = new QName[]{new QName("http://schemas.iona.com/type_test", "testqname4"), new QName("http://schemas.iona.com/type_test", "testqname5"), new QName("http://schemas.iona.com/type_test", "testqname6")};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            QName[] ret = rpcClient.testQNameList(x, y, z);
            AbstractTypeTestClient.assertTrue((((QName[])y.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((((QName[])z.value).length == 3 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((ret.length == 3 ? 1 : 0) != 0);
            if (!this.perfTestOnly) {
                for (int i = 0; i < 3; ++i) {
                    AbstractTypeTestClient.assertEquals((String)"testQNameList(): Incorrect value for inout param", (Object)x[i], (Object)((QName[])y.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testQNameList(): Incorrect value for out param", (Object)yOrig[i], (Object)((QName[])z.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testQNameList(): Incorrect return value", (Object)x[i], (Object)ret[i]);
                }
            }
        }
    }

    @Test
    public void testSimpleUnionList() throws Exception {
        if (!this.shouldRunTest("SimpleUnionList")) {
            return;
        }
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<String> x = Arrays.asList("5", "-7");
            List<String> yOrig = Arrays.asList("-9", "7");
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testSimpleUnionList(x, y, z) : xmlClient.testSimpleUnionList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient.assertTrue((String)"testSimpleUnionList(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
                AbstractTypeTestClient.assertTrue((String)"testSimpleUnionList(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
                AbstractTypeTestClient.assertTrue((String)"testSimpleUnionList(): Incorrect return value", (boolean)((Object)x).equals(ret));
            }
        } else {
            String[] x = new String[]{"5", "-7"};
            String[] yOrig = new String[]{"-9", "7"};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            String[] ret = rpcClient.testSimpleUnionList(x, y, z);
            AbstractTypeTestClient.assertTrue((((String[])y.value).length == 2 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((((String[])z.value).length == 2 ? 1 : 0) != 0);
            AbstractTypeTestClient.assertTrue((ret.length == 2 ? 1 : 0) != 0);
            if (!this.perfTestOnly) {
                for (int i = 0; i < 2; ++i) {
                    AbstractTypeTestClient.assertEquals((String)"testSimpleUnionList(): Incorrect value for inout param", (Object)x[i], (Object)((String[])y.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testSimpleUnionList(): Incorrect value for out param", (Object)yOrig[i], (Object)((String[])z.value)[i]);
                    AbstractTypeTestClient.assertEquals((String)"testSimpleUnionList(): Incorrect return value", (Object)x[i], (Object)ret[i]);
                }
            }
        }
    }
}

