/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.type_test;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.Holder;
import org.apache.cxf.systest.type_test.AbstractTypeTestClient2;
import org.apache.type_test.types1.DerivedChoiceBaseArray;
import org.apache.type_test.types1.DerivedChoiceBaseChoice;
import org.apache.type_test.types1.DerivedChoiceBaseStruct;
import org.apache.type_test.types1.DerivedEmptyBaseEmptyAll;
import org.apache.type_test.types1.DerivedEmptyBaseEmptyChoice;
import org.apache.type_test.types1.DerivedNoContent;
import org.apache.type_test.types1.DerivedStructBaseChoice;
import org.apache.type_test.types1.DerivedStructBaseEmpty;
import org.apache.type_test.types1.DerivedStructBaseStruct;
import org.apache.type_test.types1.RestrictedChoiceBaseChoice;
import org.apache.type_test.types1.SimpleChoice;
import org.apache.type_test.types1.SimpleStruct;
import org.apache.type_test.types1.UnboundedArray;
import org.apache.type_test.types2.ChoiceOfChoice;
import org.apache.type_test.types2.ChoiceOfSeq;
import org.apache.type_test.types2.ChoiceWithAnyAttribute;
import org.apache.type_test.types2.ChoiceWithBinary;
import org.apache.type_test.types2.ChoiceWithGroupChoice;
import org.apache.type_test.types2.ChoiceWithGroupSeq;
import org.apache.type_test.types2.ChoiceWithGroups;
import org.apache.type_test.types2.ComplexTypeWithAttributeGroup;
import org.apache.type_test.types2.ComplexTypeWithAttributeGroup1;
import org.apache.type_test.types2.ComplexTypeWithAttributes;
import org.apache.type_test.types2.ExtBase64Binary;
import org.apache.type_test.types2.GroupDirectlyInComplexType;
import org.apache.type_test.types2.IDTypeAttribute;
import org.apache.type_test.types2.MultipleOccursSequenceInSequence;
import org.apache.type_test.types2.SequenceWithGroupChoice;
import org.apache.type_test.types2.SequenceWithGroupSeq;
import org.apache.type_test.types2.SequenceWithGroups;
import org.apache.type_test.types2.SequenceWithOccuringGroup;
import org.apache.type_test.types2.StructWithAny;
import org.apache.type_test.types2.StructWithAnyArray;
import org.apache.type_test.types2.StructWithAnyAttribute;
import org.apache.type_test.types2.StructWithBinary;
import org.apache.type_test.types3.OccuringChoice;
import org.apache.type_test.types3.OccuringChoice1;
import org.apache.type_test.types3.OccuringChoice2;
import org.apache.type_test.types3.OccuringStruct;
import org.apache.type_test.types3.OccuringStruct1;
import org.apache.type_test.types3.OccuringStruct2;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeTestClient3
extends AbstractTypeTestClient2 {
    protected boolean equals(ChoiceOfChoice x, ChoiceOfChoice y) {
        if (x.getVarInt() != null && y.getVarInt() != null) {
            return x.getVarInt().equals(y.getVarInt());
        }
        if (x.getVarFloat() != null && y.getVarFloat() != null) {
            return x.getVarFloat().equals(y.getVarFloat());
        }
        if (x.getVarOtherInt() != null && y.getVarOtherInt() != null) {
            return x.getVarOtherInt().equals(y.getVarOtherInt());
        }
        if (x.getVarString() != null && y.getVarString() != null) {
            return x.getVarString().equals(y.getVarString());
        }
        return false;
    }

    @Test
    public void testChoiceOfChoice() throws Exception {
        if (!this.shouldRunTest("ChoiceOfChoice")) {
            return;
        }
        ChoiceOfChoice x = new ChoiceOfChoice();
        ChoiceOfChoice yOrig = new ChoiceOfChoice();
        x.setVarFloat(Float.valueOf(3.14f));
        yOrig.setVarString("y456");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceOfChoice ret = testDocLiteral ? docClient.testChoiceOfChoice(x, y, z) : (testXMLBinding ? xmlClient.testChoiceOfChoice(x, y, z) : rpcClient.testChoiceOfChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceOfChoice(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceOfChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceOfChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceOfChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceOfChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceOfSeq x, ChoiceOfSeq y) {
        if (x.getVarFloat() != null && x.getVarInt() != null && y.getVarFloat() != null && y.getVarInt() != null) {
            return x.getVarInt().equals(y.getVarInt()) && x.getVarFloat().compareTo(y.getVarFloat()) == 0;
        }
        if (x.getVarOtherInt() != null && y.getVarOtherInt() != null && x.getVarString() != null && y.getVarString() != null) {
            return x.getVarOtherInt().equals(y.getVarOtherInt()) && x.getVarString().equals(y.getVarString());
        }
        return false;
    }

    @Test
    public void testChoiceOfSeq() throws Exception {
        if (!this.shouldRunTest("ChoiceOfSeq")) {
            return;
        }
        ChoiceOfSeq x = new ChoiceOfSeq();
        x.setVarInt(Integer.valueOf(123));
        x.setVarFloat(Float.valueOf(3.14f));
        ChoiceOfSeq yOrig = new ChoiceOfSeq();
        yOrig.setVarOtherInt(Integer.valueOf(456));
        yOrig.setVarString("y456");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceOfSeq ret = testDocLiteral ? docClient.testChoiceOfSeq(x, y, z) : (testXMLBinding ? xmlClient.testChoiceOfSeq(x, y, z) : rpcClient.testChoiceOfSeq(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceOfSeq(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceOfSeq)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceOfSeq(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceOfSeq)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceOfSeq(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(DerivedStructBaseStruct x, DerivedStructBaseStruct y) {
        return this.equals((SimpleStruct)x, (SimpleStruct)y) && x.getVarFloatExt() == y.getVarFloatExt() && x.getVarStringExt().equals(y.getVarStringExt()) && x.getAttrString1().equals(y.getAttrString1()) && x.getAttrString2().equals(y.getAttrString2());
    }

    @Test
    public void testDerivedStructBaseStruct() throws Exception {
        if (!this.shouldRunTest("DerivedStructBaseStruct")) {
            return;
        }
        DerivedStructBaseStruct x = new DerivedStructBaseStruct();
        x.setVarFloat((double)3.14f);
        x.setVarInt(new BigInteger("42"));
        x.setVarString("BaseStruct-x");
        x.setVarAttrString("BaseStructAttr-x");
        x.setVarFloatExt(-3.14f);
        x.setVarStringExt("DerivedStruct-x");
        x.setAttrString1("DerivedAttr1-x");
        x.setAttrString2("DerivedAttr2-x");
        DerivedStructBaseStruct yOrig = new DerivedStructBaseStruct();
        yOrig.setVarFloat((double)-9.14f);
        yOrig.setVarInt(new BigInteger("10"));
        yOrig.setVarString("BaseStruct-y");
        yOrig.setVarAttrString("BaseStructAttr-y");
        yOrig.setVarFloatExt(1.414f);
        yOrig.setVarStringExt("DerivedStruct-y");
        yOrig.setAttrString1("DerivedAttr1-y");
        yOrig.setAttrString2("DerivedAttr2-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedStructBaseStruct ret = testDocLiteral ? docClient.testDerivedStructBaseStruct(x, y, z) : (testXMLBinding ? xmlClient.testDerivedStructBaseStruct(x, y, z) : rpcClient.testDerivedStructBaseStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseStruct(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedStructBaseStruct)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedStructBaseStruct)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(DerivedStructBaseChoice x, DerivedStructBaseChoice y) {
        return this.equals((SimpleChoice)x, (SimpleChoice)y) && Float.compare(x.getVarFloatExt(), y.getVarFloatExt()) == 0 && x.getVarStringExt().equals(y.getVarStringExt()) && x.getAttrString().equals(y.getAttrString());
    }

    @Test
    public void testDerivedStructBaseChoice() throws Exception {
        if (!this.shouldRunTest("DerivedStructBaseChoice")) {
            return;
        }
        DerivedStructBaseChoice x = new DerivedStructBaseChoice();
        x.setVarString("BaseChoice-x");
        x.setVarFloatExt(-3.14f);
        x.setVarStringExt("DerivedStruct-x");
        x.setAttrString("DerivedAttr-x");
        DerivedStructBaseChoice yOrig = new DerivedStructBaseChoice();
        yOrig.setVarFloat(Float.valueOf(-9.14f));
        yOrig.setVarFloatExt(1.414f);
        yOrig.setVarStringExt("DerivedStruct-y");
        yOrig.setAttrString("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedStructBaseChoice ret = testDocLiteral ? docClient.testDerivedStructBaseChoice(x, y, z) : (testXMLBinding ? xmlClient.testDerivedStructBaseChoice(x, y, z) : rpcClient.testDerivedStructBaseChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseChoice(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedStructBaseChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedStructBaseChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(DerivedChoiceBaseStruct x, DerivedChoiceBaseStruct y) {
        boolean isEquals = x.getAttrString().equals(y.getAttrString());
        isEquals = x.getVarStringExt() != null && y.getVarStringExt() != null ? (isEquals &= x.getVarStringExt().equals(y.getVarStringExt())) : (isEquals &= x.getVarFloatExt() != null && y.getVarFloatExt() != null && x.getVarFloatExt().compareTo(y.getVarFloatExt()) == 0);
        return isEquals && this.equals((SimpleStruct)x, (SimpleStruct)y);
    }

    @Test
    public void testDerivedChoiceBaseStruct() throws Exception {
        if (!this.shouldRunTest("DerivedChoiceBaseStruct")) {
            return;
        }
        DerivedChoiceBaseStruct x = new DerivedChoiceBaseStruct();
        x.setVarFloat((double)3.14f);
        x.setVarInt(new BigInteger("42"));
        x.setVarString("BaseStruct-x");
        x.setVarAttrString("BaseStructAttr-x");
        x.setVarStringExt("DerivedChoice-x");
        x.setAttrString("DerivedAttr-x");
        DerivedChoiceBaseStruct yOrig = new DerivedChoiceBaseStruct();
        yOrig.setVarFloat((double)-9.14f);
        yOrig.setVarInt(new BigInteger("10"));
        yOrig.setVarString("BaseStruct-y");
        yOrig.setVarAttrString("BaseStructAttr-y");
        yOrig.setVarFloatExt(Float.valueOf(1.414f));
        yOrig.setAttrString("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedChoiceBaseStruct ret = testDocLiteral ? docClient.testDerivedChoiceBaseStruct(x, y, z) : (testXMLBinding ? xmlClient.testDerivedChoiceBaseStruct(x, y, z) : rpcClient.testDerivedChoiceBaseStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseStruct(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedChoiceBaseStruct)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseStruct(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedChoiceBaseStruct)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(DerivedChoiceBaseArray x, DerivedChoiceBaseArray y) {
        boolean isEquals = x.getAttrStringExt().equals(y.getAttrStringExt());
        isEquals = x.getVarFloatExt() != null && y.getVarFloatExt() != null ? (isEquals &= x.getVarFloatExt().compareTo(y.getVarFloatExt()) == 0) : (isEquals &= x.getVarStringExt() != null && y.getVarStringExt() != null && x.getVarStringExt().equals(y.getVarStringExt()));
        return isEquals && this.equals((UnboundedArray)x, (UnboundedArray)y);
    }

    @Test
    public void testDerivedChoiceBaseArray() throws Exception {
        if (!this.shouldRunTest("DerivedChoiceBaseArray")) {
            return;
        }
        DerivedChoiceBaseArray x = new DerivedChoiceBaseArray();
        x.getItem().addAll(Arrays.asList("AAA", "BBB", "CCC"));
        x.setVarStringExt("DerivedChoice-x");
        x.setAttrStringExt("DerivedAttr-x");
        DerivedChoiceBaseArray yOrig = new DerivedChoiceBaseArray();
        yOrig.getItem().addAll(Arrays.asList("XXX", "YYY", "ZZZ"));
        yOrig.setVarFloatExt(Float.valueOf(1.414f));
        yOrig.setAttrStringExt("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedChoiceBaseArray ret = testDocLiteral ? docClient.testDerivedChoiceBaseArray(x, y, z) : (testXMLBinding ? xmlClient.testDerivedChoiceBaseArray(x, y, z) : rpcClient.testDerivedChoiceBaseArray(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseArray(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedChoiceBaseArray)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseArray(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedChoiceBaseArray)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseArray(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(DerivedChoiceBaseChoice x, DerivedChoiceBaseChoice y) {
        boolean isEquals = x.getAttrString().equals(y.getAttrString());
        isEquals = x.getVarStringExt() != null && y.getVarStringExt() != null ? (isEquals &= x.getVarStringExt().equals(y.getVarStringExt())) : (isEquals &= x.getVarFloatExt() != null && y.getVarFloatExt() != null && x.getVarFloatExt().compareTo(y.getVarFloatExt()) == 0);
        return isEquals && this.equals((SimpleChoice)x, (SimpleChoice)y);
    }

    @Test
    public void testDerivedChoiceBaseChoice() throws Exception {
        if (!this.shouldRunTest("DerivedChoiceBaseChoice")) {
            return;
        }
        DerivedChoiceBaseChoice x = new DerivedChoiceBaseChoice();
        x.setVarString("BaseChoice-x");
        x.setVarStringExt("DerivedChoice-x");
        x.setAttrString("DerivedAttr-x");
        DerivedChoiceBaseChoice yOrig = new DerivedChoiceBaseChoice();
        yOrig.setVarFloat(Float.valueOf(-9.14f));
        yOrig.setVarFloatExt(Float.valueOf(1.414f));
        yOrig.setAttrString("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedChoiceBaseChoice ret = testDocLiteral ? docClient.testDerivedChoiceBaseChoice(x, y, z) : (testXMLBinding ? xmlClient.testDerivedChoiceBaseChoice(x, y, z) : rpcClient.testDerivedChoiceBaseChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseChoice(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedChoiceBaseChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedChoiceBaseChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedChoiceBaseChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(DerivedNoContent x, DerivedNoContent y) {
        return this.equals((SimpleStruct)x, (SimpleStruct)y) && x.getVarAttrString().equals(y.getVarAttrString());
    }

    @Test
    public void testDerivedNoContent() throws Exception {
        if (!this.shouldRunTest("DerivedNoContent")) {
            return;
        }
        DerivedNoContent x = new DerivedNoContent();
        x.setVarFloat((double)3.14f);
        x.setVarInt(new BigInteger("42"));
        x.setVarString("BaseStruct-x");
        x.setVarAttrString("BaseStructAttr-x");
        DerivedNoContent yOrig = new DerivedNoContent();
        yOrig.setVarFloat((double)1.414f);
        yOrig.setVarInt(new BigInteger("13"));
        yOrig.setVarString("BaseStruct-y");
        yOrig.setVarAttrString("BaseStructAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedNoContent ret = testDocLiteral ? docClient.testDerivedNoContent(x, y, z) : (testXMLBinding ? xmlClient.testDerivedNoContent(x, y, z) : rpcClient.testDerivedNoContent(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedNoContent(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedNoContent)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedNoContent(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedNoContent)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedNoContent(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(DerivedStructBaseEmpty x, DerivedStructBaseEmpty y) {
        return x.getVarFloatExt() == y.getVarFloatExt() && x.getVarStringExt().equals(y.getVarStringExt()) && x.getAttrString().equals(y.getAttrString());
    }

    @Test
    public void testDerivedStructBaseEmpty() throws Exception {
        if (!this.shouldRunTest("DerivedStructBaseEmpty")) {
            return;
        }
        DerivedStructBaseEmpty x = new DerivedStructBaseEmpty();
        x.setVarFloatExt(-3.14f);
        x.setVarStringExt("DerivedStruct-x");
        x.setAttrString("DerivedAttr-x");
        DerivedStructBaseEmpty yOrig = new DerivedStructBaseEmpty();
        yOrig.setVarFloatExt(1.414f);
        yOrig.setVarStringExt("DerivedStruct-y");
        yOrig.setAttrString("DerivedAttr-y");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedStructBaseEmpty ret = testDocLiteral ? docClient.testDerivedStructBaseEmpty(x, y, z) : (testXMLBinding ? xmlClient.testDerivedStructBaseEmpty(x, y, z) : rpcClient.testDerivedStructBaseEmpty(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseEmpty(): Incorrect value for inout param", (boolean)this.equals(x, (DerivedStructBaseEmpty)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseEmpty(): Incorrect value for out param", (boolean)this.equals(yOrig, (DerivedStructBaseEmpty)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testDerivedStructBaseEmpty(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testDerivedEmptyBaseEmptyAll() throws Exception {
        if (!this.shouldRunTest("DerivedEmptyBaseEmptyAll")) {
            return;
        }
        DerivedEmptyBaseEmptyAll x = new DerivedEmptyBaseEmptyAll();
        DerivedEmptyBaseEmptyAll yOrig = new DerivedEmptyBaseEmptyAll();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedEmptyBaseEmptyAll ret = testDocLiteral ? docClient.testDerivedEmptyBaseEmptyAll(x, y, z) : (testXMLBinding ? xmlClient.testDerivedEmptyBaseEmptyAll(x, y, z) : rpcClient.testDerivedEmptyBaseEmptyAll(x, y, z));
        AbstractTypeTestClient3.assertNotNull((Object)y.value);
        AbstractTypeTestClient3.assertNotNull((Object)z.value);
        AbstractTypeTestClient3.assertNotNull((Object)ret);
        AbstractTypeTestClient3.assertTrue((boolean)(y.value instanceof DerivedEmptyBaseEmptyAll));
        AbstractTypeTestClient3.assertTrue((boolean)(z.value instanceof DerivedEmptyBaseEmptyAll));
        AbstractTypeTestClient3.assertTrue((boolean)(ret instanceof DerivedEmptyBaseEmptyAll));
    }

    @Test
    public void testDerivedEmptyBaseEmptyChoice() throws Exception {
        if (!this.shouldRunTest("DerivedEmptyBaseEmptyChoice")) {
            return;
        }
        DerivedEmptyBaseEmptyChoice x = new DerivedEmptyBaseEmptyChoice();
        DerivedEmptyBaseEmptyChoice yOrig = new DerivedEmptyBaseEmptyChoice();
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        DerivedEmptyBaseEmptyChoice ret = testDocLiteral ? docClient.testDerivedEmptyBaseEmptyChoice(x, y, z) : (testXMLBinding ? xmlClient.testDerivedEmptyBaseEmptyChoice(x, y, z) : rpcClient.testDerivedEmptyBaseEmptyChoice(x, y, z));
        AbstractTypeTestClient3.assertNotNull((Object)y.value);
        AbstractTypeTestClient3.assertNotNull((Object)z.value);
        AbstractTypeTestClient3.assertNotNull((Object)ret);
        AbstractTypeTestClient3.assertTrue((boolean)(y.value instanceof DerivedEmptyBaseEmptyChoice));
        AbstractTypeTestClient3.assertTrue((boolean)(z.value instanceof DerivedEmptyBaseEmptyChoice));
        AbstractTypeTestClient3.assertTrue((boolean)(ret instanceof DerivedEmptyBaseEmptyChoice));
    }

    protected boolean equals(RestrictedChoiceBaseChoice x, RestrictedChoiceBaseChoice y) {
        if (x.getVarFloat() != null && y.getVarFloat() != null) {
            return x.getVarFloat().compareTo(y.getVarFloat()) == 0;
        }
        return x.getVarInt() != null && y.getVarInt() != null && x.getVarInt().compareTo(y.getVarInt()) == 0;
    }

    @Test
    public void testRestrictedChoiceBaseChoice() throws Exception {
        if (!this.shouldRunTest("RestrictedChoiceBaseChoice")) {
            return;
        }
        RestrictedChoiceBaseChoice x = new RestrictedChoiceBaseChoice();
        x.setVarInt(Integer.valueOf(12));
        RestrictedChoiceBaseChoice yOrig = new RestrictedChoiceBaseChoice();
        yOrig.setVarFloat(Float.valueOf(-9.14f));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        RestrictedChoiceBaseChoice ret = testDocLiteral ? docClient.testRestrictedChoiceBaseChoice(x, y, z) : (testXMLBinding ? xmlClient.testRestrictedChoiceBaseChoice(x, y, z) : rpcClient.testRestrictedChoiceBaseChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testRestrictedChoiceBaseChoice(): Incorrect value for inout param", (boolean)this.equals(x, (RestrictedChoiceBaseChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testRestrictedChoiceBaseChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (RestrictedChoiceBaseChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testRestrictedChoiceBaseChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ComplexTypeWithAttributeGroup x, ComplexTypeWithAttributeGroup y) {
        return x.getAttrInt().compareTo(y.getAttrInt()) == 0 && x.getAttrString().equals(y.getAttrString());
    }

    @Test
    public void testComplexTypeWithAttributeGroup() throws Exception {
        if (!this.shouldRunTest("ComplexTypeWithAttributeGroup")) {
            return;
        }
        ComplexTypeWithAttributeGroup x = new ComplexTypeWithAttributeGroup();
        x.setAttrInt(new BigInteger("123"));
        x.setAttrString("x123");
        ComplexTypeWithAttributeGroup yOrig = new ComplexTypeWithAttributeGroup();
        yOrig.setAttrInt(new BigInteger("456"));
        yOrig.setAttrString("x456");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ComplexTypeWithAttributeGroup ret = testDocLiteral ? docClient.testComplexTypeWithAttributeGroup(x, y, z) : (testXMLBinding ? xmlClient.testComplexTypeWithAttributeGroup(x, y, z) : rpcClient.testComplexTypeWithAttributeGroup(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributeGroup(): Incorrect value for inout param", (boolean)this.equals(x, (ComplexTypeWithAttributeGroup)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributeGroup(): Incorrect value for out param", (boolean)this.equals(yOrig, (ComplexTypeWithAttributeGroup)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributeGroup(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ComplexTypeWithAttributeGroup1 x, ComplexTypeWithAttributeGroup1 y) {
        return x.getAttrInt().compareTo(y.getAttrInt()) == 0 && x.getAttrFloat().compareTo(y.getAttrFloat()) == 0 && x.getAttrString().equals(y.getAttrString());
    }

    @Test
    public void testComplexTypeWithAttributeGroup1() throws Exception {
        if (!this.shouldRunTest("ComplexTypeWithAttributeGroup1")) {
            return;
        }
        ComplexTypeWithAttributeGroup1 x = new ComplexTypeWithAttributeGroup1();
        x.setAttrInt(new BigInteger("123"));
        x.setAttrString("x123");
        x.setAttrFloat(new Float(3.14f));
        ComplexTypeWithAttributeGroup1 yOrig = new ComplexTypeWithAttributeGroup1();
        yOrig.setAttrInt(new BigInteger("456"));
        yOrig.setAttrString("x456");
        yOrig.setAttrFloat(new Float(6.28f));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ComplexTypeWithAttributeGroup1 ret = testDocLiteral ? docClient.testComplexTypeWithAttributeGroup1(x, y, z) : (testXMLBinding ? xmlClient.testComplexTypeWithAttributeGroup1(x, y, z) : rpcClient.testComplexTypeWithAttributeGroup1(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributeGroup1(): Incorrect value for inout param", (boolean)this.equals(x, (ComplexTypeWithAttributeGroup1)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributeGroup1(): Incorrect value for out param", (boolean)this.equals(yOrig, (ComplexTypeWithAttributeGroup1)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributeGroup1(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(SequenceWithGroupSeq x, SequenceWithGroupSeq y) {
        return x.getVarInt() == y.getVarInt() && Float.compare(x.getVarFloat(), y.getVarFloat()) == 0 && x.getVarString().equals(y.getVarString()) && x.getVarOtherInt() == y.getVarOtherInt() && Float.compare(x.getVarOtherFloat(), y.getVarOtherFloat()) == 0 && x.getVarOtherString().equals(y.getVarOtherString());
    }

    @Test
    public void testSequenceWithGroupSeq() throws Exception {
        if (!this.shouldRunTest("SequenceWithGroupSeq")) {
            return;
        }
        SequenceWithGroupSeq x = new SequenceWithGroupSeq();
        x.setVarInt(100);
        x.setVarString("hello");
        x.setVarFloat(1.1f);
        x.setVarOtherInt(11);
        x.setVarOtherString("world");
        x.setVarOtherFloat(10.1f);
        SequenceWithGroupSeq yOrig = new SequenceWithGroupSeq();
        yOrig.setVarInt(11);
        yOrig.setVarString("world");
        yOrig.setVarFloat(10.1f);
        yOrig.setVarOtherInt(100);
        yOrig.setVarOtherString("hello");
        yOrig.setVarOtherFloat(1.1f);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SequenceWithGroupSeq ret = testDocLiteral ? docClient.testSequenceWithGroupSeq(x, y, z) : (testXMLBinding ? xmlClient.testSequenceWithGroupSeq(x, y, z) : rpcClient.testSequenceWithGroupSeq(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroupSeq(): Incorrect value for inout param", (boolean)this.equals(x, (SequenceWithGroupSeq)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroupSeq(): Incorrect value for out param", (boolean)this.equals(yOrig, (SequenceWithGroupSeq)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroupSeq(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(SequenceWithGroupChoice x, SequenceWithGroupChoice y) {
        if (x.getVarInt() != null && y.getVarInt() != null) {
            if (x.getVarInt().compareTo(y.getVarInt()) != 0) {
                return false;
            }
        } else if (x.getVarFloat() != null && y.getVarFloat() != null) {
            if (x.getVarFloat().compareTo(y.getVarFloat()) != 0) {
                return false;
            }
        } else if (x.getVarString() != null && y.getVarString() != null) {
            if (!x.getVarString().equals(y.getVarString())) {
                return false;
            }
        } else {
            return false;
        }
        if (x.getVarOtherInt() != null && y.getVarOtherInt() != null) {
            if (x.getVarOtherInt().compareTo(y.getVarOtherInt()) != 0) {
                return false;
            }
        } else if (x.getVarOtherFloat() != null && y.getVarOtherFloat() != null) {
            if (x.getVarOtherFloat().compareTo(y.getVarOtherFloat()) != 0) {
                return false;
            }
        } else {
            if (x.getVarOtherString() != null && y.getVarOtherString() != null) {
                return x.getVarOtherString().equals(y.getVarOtherString());
            }
            return false;
        }
        return true;
    }

    @Test
    public void testSequenceWithGroupChoice() throws Exception {
        if (!this.shouldRunTest("SequenceWithGroupChoice")) {
            return;
        }
        SequenceWithGroupChoice x = new SequenceWithGroupChoice();
        x.setVarFloat(Float.valueOf(1.1f));
        x.setVarOtherString("world");
        SequenceWithGroupChoice yOrig = new SequenceWithGroupChoice();
        yOrig.setVarOtherFloat(Float.valueOf(2.2f));
        yOrig.setVarString("world");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SequenceWithGroupChoice ret = testDocLiteral ? docClient.testSequenceWithGroupChoice(x, y, z) : (testXMLBinding ? xmlClient.testSequenceWithGroupChoice(x, y, z) : rpcClient.testSequenceWithGroupChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroupChoice(): Incorrect value for inout param", (boolean)this.equals(x, (SequenceWithGroupChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroupChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (SequenceWithGroupChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroupChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(SequenceWithGroups x, SequenceWithGroups y) {
        if (x.getVarOtherInt() != null && y.getVarOtherInt() != null) {
            if (x.getVarOtherInt().compareTo(y.getVarOtherInt()) != 0) {
                return false;
            }
        } else if (x.getVarOtherFloat() != null && y.getVarOtherFloat() != null) {
            if (x.getVarOtherFloat().compareTo(y.getVarOtherFloat()) != 0) {
                return false;
            }
        } else if (x.getVarOtherString() != null && y.getVarOtherString() != null) {
            if (!x.getVarOtherString().equals(y.getVarOtherString())) {
                return false;
            }
        } else {
            return false;
        }
        return x.getVarInt() == y.getVarInt() && Float.compare(x.getVarFloat(), y.getVarFloat()) == 0 && x.getVarString().equals(y.getVarString());
    }

    @Test
    public void testSequenceWithGroups() throws Exception {
        if (!this.shouldRunTest("SequenceWithGroups")) {
            return;
        }
        SequenceWithGroups x = new SequenceWithGroups();
        x.setVarInt(100);
        x.setVarString("hello");
        x.setVarFloat(1.1f);
        x.setVarOtherFloat(Float.valueOf(1.1f));
        SequenceWithGroups yOrig = new SequenceWithGroups();
        yOrig.setVarInt(11);
        yOrig.setVarString("world");
        yOrig.setVarFloat(10.1f);
        yOrig.setVarOtherString("world");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SequenceWithGroups ret = testDocLiteral ? docClient.testSequenceWithGroups(x, y, z) : (testXMLBinding ? xmlClient.testSequenceWithGroups(x, y, z) : rpcClient.testSequenceWithGroups(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroups(): Incorrect value for inout param", (boolean)this.equals(x, (SequenceWithGroups)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroups(): Incorrect value for out param", (boolean)this.equals(yOrig, (SequenceWithGroups)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testSequenceWithGroups(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(SequenceWithOccuringGroup x, SequenceWithOccuringGroup y) {
        return this.equalsFloatIntStringList(x.getBatchElementsSeq(), y.getBatchElementsSeq());
    }

    @Test
    public void testSequenceWithOccuringGroup() throws Exception {
        if (!this.shouldRunTest("SequenceWithOccuringGroup")) {
            return;
        }
        SequenceWithOccuringGroup x = new SequenceWithOccuringGroup();
        x.getBatchElementsSeq().add(Float.valueOf(1.1f));
        x.getBatchElementsSeq().add(100);
        x.getBatchElementsSeq().add("hello");
        SequenceWithOccuringGroup yOrig = new SequenceWithOccuringGroup();
        yOrig.getBatchElementsSeq().add(Float.valueOf(2.2f));
        yOrig.getBatchElementsSeq().add(200);
        yOrig.getBatchElementsSeq().add("world");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        SequenceWithOccuringGroup ret = testDocLiteral ? docClient.testSequenceWithOccuringGroup(x, y, z) : (testXMLBinding ? xmlClient.testSequenceWithOccuringGroup(x, y, z) : rpcClient.testSequenceWithOccuringGroup(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testGroupDirectlyInComplexType(): Incorrect value for inout param", (boolean)this.equals(x, (SequenceWithOccuringGroup)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testGroupDirectlyInComplexType(): Incorrect value for out param", (boolean)this.equals(yOrig, (SequenceWithOccuringGroup)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testGroupDirectlyInComplexType(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(GroupDirectlyInComplexType x, GroupDirectlyInComplexType y) {
        return x.getVarInt() == y.getVarInt() && x.getVarString().equals(y.getVarString()) && Float.compare(x.getVarFloat(), y.getVarFloat()) == 0 && x.getAttr1().equals(y.getAttr1());
    }

    @Test
    public void testGroupDirectlyInComplexType() throws Exception {
        if (!this.shouldRunTest("GroupDirectlyInComplexType")) {
            return;
        }
        GroupDirectlyInComplexType x = new GroupDirectlyInComplexType();
        x.setVarInt(100);
        x.setVarString("hello");
        x.setVarFloat(1.1f);
        x.setAttr1(new Integer(1));
        GroupDirectlyInComplexType yOrig = new GroupDirectlyInComplexType();
        yOrig.setVarInt(11);
        yOrig.setVarString("world");
        yOrig.setVarFloat(10.1f);
        yOrig.setAttr1(new Integer(2));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        GroupDirectlyInComplexType ret = testDocLiteral ? docClient.testGroupDirectlyInComplexType(x, y, z) : (testXMLBinding ? xmlClient.testGroupDirectlyInComplexType(x, y, z) : rpcClient.testGroupDirectlyInComplexType(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testGroupDirectlyInComplexType(): Incorrect value for inout param", (boolean)this.equals(x, (GroupDirectlyInComplexType)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testGroupDirectlyInComplexType(): Incorrect value for out param", (boolean)this.equals(yOrig, (GroupDirectlyInComplexType)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testGroupDirectlyInComplexType(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ComplexTypeWithAttributes x, ComplexTypeWithAttributes y) {
        return x.getAttrInt().equals(y.getAttrInt()) && x.getAttrString().equals(y.getAttrString());
    }

    @Test
    public void testComplexTypeWithAttributes() throws Exception {
        if (!this.shouldRunTest("ComplexTypeWithAttributes")) {
            return;
        }
        ComplexTypeWithAttributes x = new ComplexTypeWithAttributes();
        x.setAttrInt(new BigInteger("123"));
        x.setAttrString("x123");
        ComplexTypeWithAttributes yOrig = new ComplexTypeWithAttributes();
        yOrig.setAttrInt(new BigInteger("456"));
        yOrig.setAttrString("x456");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ComplexTypeWithAttributes ret = testDocLiteral ? docClient.testComplexTypeWithAttributes(x, y, z) : (testXMLBinding ? xmlClient.testComplexTypeWithAttributes(x, y, z) : rpcClient.testComplexTypeWithAttributes(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributes(): Incorrect value for inout param", (boolean)this.equals(x, (ComplexTypeWithAttributes)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributes(): Incorrect value for out param", (boolean)this.equals(yOrig, (ComplexTypeWithAttributes)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testComplexTypeWithAttributes(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    public void assertEqualsStructWithAny(StructWithAny a, StructWithAny b) throws Exception {
        AbstractTypeTestClient3.assertEquals((String)"StructWithAny names don't match", (Object)a.getName(), (Object)b.getName());
        AbstractTypeTestClient3.assertEquals((String)"StructWithAny addresses don't match", (Object)a.getAddress(), (Object)b.getAddress());
        this.assertEquals(a.getAny(), b.getAny());
    }

    public void assertEquals(Element elA, Element elB) throws Exception {
        if (elA instanceof SOAPElement && elB instanceof SOAPElement) {
            SOAPElement soapA = (SOAPElement)elA;
            SOAPElement soapB = (SOAPElement)elB;
            AbstractTypeTestClient3.assertEquals((String)"StructWithAny soap element names don't match", (Object)soapA.getElementName(), (Object)soapB.getElementName());
            AbstractTypeTestClient3.assertEquals((String)"StructWithAny soap element text nodes don't match", (Object)soapA.getValue(), (Object)soapB.getValue());
            Iterator itExp = soapA.getChildElements();
            Iterator itGen = soapB.getChildElements();
            while (itExp.hasNext()) {
                if (!itGen.hasNext()) {
                    AbstractTypeTestClient3.fail((String)"Incorrect number of child elements inside any");
                }
                Object objA = itExp.next();
                Object objB = itGen.next();
                if (!(objA instanceof SOAPElement)) continue;
                if (objB instanceof SOAPElement) {
                    this.assertEquals((Element)((SOAPElement)objA), (Element)((SOAPElement)objB));
                    continue;
                }
                AbstractTypeTestClient3.fail((String)"No matching soap element.");
            }
        }
    }

    @Test
    public void testStructWithAny() throws Exception {
        if (!this.shouldRunTest("StructWithAny")) {
            return;
        }
        StructWithAny swa = new StructWithAny();
        swa.setName("Name");
        swa.setAddress("Some Address");
        StructWithAny yOrig = new StructWithAny();
        yOrig.setName("Name2");
        yOrig.setAddress("Some Other Address");
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement x = factory.createElement("hello", "foo", "http://some.url.com");
        x.addNamespaceDeclaration("foo", "http://some.url.com");
        x.addTextNode("This is the text of the node");
        SOAPElement x2 = factory.createElement("hello2", "foo", "http://some.url.com");
        x2.addNamespaceDeclaration("foo", "http://some.url.com");
        x2.addTextNode("This is the text of the node for the second struct");
        swa.setAny((Element)x);
        yOrig.setAny((Element)x2);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAny ret = testDocLiteral ? docClient.testStructWithAny(swa, y, z) : (testXMLBinding ? xmlClient.testStructWithAny(swa, y, z) : rpcClient.testStructWithAny(swa, y, z));
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAny(swa, (StructWithAny)y.value);
            this.assertEqualsStructWithAny(yOrig, (StructWithAny)z.value);
            this.assertEqualsStructWithAny(swa, ret);
        }
    }

    @Test
    public void testStructWithAnyXsi() throws Exception {
        if (!this.shouldRunTest("StructWithAnyXsi")) {
            return;
        }
        StructWithAny swa = new StructWithAny();
        swa.setName("Name");
        swa.setAddress("Some Address");
        StructWithAny yOrig = new StructWithAny();
        yOrig.setName("Name2");
        yOrig.setAddress("Some Other Address");
        SOAPFactory sf = SOAPFactory.newInstance();
        Name elementName = sf.createName("UKAddress", "", "http://apache.org/type_test");
        Name xsiAttrName = sf.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        SOAPElement x = sf.createElement(elementName);
        x.addNamespaceDeclaration("tns", "http://apache.org/type_test");
        x.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        x.addAttribute(xsiAttrName, "tns:UKAddressType11");
        x.addTextNode("This is the text of the node for the first struct");
        Name elementName2 = sf.createName("UKAddress", "", "http://apache.org/type_test");
        Name xsiAttrName2 = sf.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        SOAPElement x2 = sf.createElement(elementName2);
        x2.addNamespaceDeclaration("tns", "http://apache.org/type_test");
        x2.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        x2.addAttribute(xsiAttrName2, "tns:UKAddressType22");
        x2.addTextNode("This is the text of the node for the second struct");
        swa.setAny((Element)x);
        yOrig.setAny((Element)x2);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAny ret = testDocLiteral ? docClient.testStructWithAny(swa, y, z) : (testXMLBinding ? xmlClient.testStructWithAny(swa, y, z) : rpcClient.testStructWithAny(swa, y, z));
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAny(swa, (StructWithAny)y.value);
            this.assertEqualsStructWithAny(yOrig, (StructWithAny)z.value);
            this.assertEqualsStructWithAny(swa, ret);
        }
    }

    @Test
    public void testStructWithInvalidAny() throws Exception {
        if (!this.shouldRunTest("StructWithInvalidAny")) {
            return;
        }
        StructWithAny swa = new StructWithAny();
        swa.setName("Name");
        swa.setAddress("Some Address");
        StructWithAny yOrig = new StructWithAny();
        yOrig.setName("Name2");
        yOrig.setAddress("Some Other Address");
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement x = factory.createElement("hello", "foo", "http://some.url.com");
        x.addTextNode("This is the text of the node");
        SOAPElement x2 = factory.createElement("hello2", "foo", "http://some.url.com");
        x2.addTextNode("This is the text of the node for the second struct");
        swa.setAny((Element)x);
        yOrig.setAny((Element)x2);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        try {
            if (testDocLiteral) {
                docClient.testStructWithAny(swa, y, z);
            } else if (testXMLBinding) {
                xmlClient.testStructWithAny(swa, y, z);
            } else {
                rpcClient.testStructWithAny(swa, y, z);
            }
        }
        catch (Exception ex) {
            AbstractTypeTestClient3.fail((String)"testStructWithInvalidAny(): caught expected exception - woot.");
        }
    }

    public void assertEqualsStructWithAnyArray(StructWithAnyArray a, StructWithAnyArray b) throws Exception {
        AbstractTypeTestClient3.assertEquals((String)"StructWithAny names don't match", (Object)a.getName(), (Object)b.getName());
        AbstractTypeTestClient3.assertEquals((String)"StructWithAny addresses don't match", (Object)a.getAddress(), (Object)b.getAddress());
        List ae = a.getAny();
        List be = b.getAny();
        AbstractTypeTestClient3.assertEquals((String)"StructWithAny soap element lengths don't match", (Object)ae.size(), (Object)be.size());
        for (int i = 0; i < ae.size(); ++i) {
            this.assertEquals((Element)ae.get(i), (Element)be.get(i));
        }
    }

    @Test
    public void testStructWithAnyArray() throws Exception {
        if (!this.shouldRunTest("StructWithAnyArray")) {
            return;
        }
        StructWithAnyArray swa = new StructWithAnyArray();
        swa.setName("Name");
        swa.setAddress("Some Address");
        StructWithAnyArray yOrig = new StructWithAnyArray();
        yOrig.setName("Name2");
        yOrig.setAddress("Some Other Address");
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement x = factory.createElement("hello", "foo", "http://some.url.com");
        x.addNamespaceDeclaration("foo", "http://some.url.com");
        x.addTextNode("This is the text of the node");
        SOAPElement x2 = factory.createElement("hello2", "foo", "http://some.url.com");
        x2.addNamespaceDeclaration("foo", "http://some.url.com");
        x2.addTextNode("This is the text of the node for the second struct");
        swa.getAny().add(x);
        yOrig.getAny().add(x2);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        StructWithAnyArray ret = testDocLiteral ? docClient.testStructWithAnyArray(swa, y, z) : (testXMLBinding ? xmlClient.testStructWithAnyArray(swa, y, z) : rpcClient.testStructWithAnyArray(swa, y, z));
        if (!this.perfTestOnly) {
            this.assertEqualsStructWithAnyArray(swa, (StructWithAnyArray)y.value);
            this.assertEqualsStructWithAnyArray(yOrig, (StructWithAnyArray)z.value);
            this.assertEqualsStructWithAnyArray(swa, ret);
        }
    }

    @Test
    public void testStructWithInvalidAnyArray() throws Exception {
        if (!this.shouldRunTest("StructWithInvalidAnyArray")) {
            return;
        }
        StructWithAnyArray swa = new StructWithAnyArray();
        swa.setName("Name");
        swa.setAddress("Some Address");
        StructWithAnyArray yOrig = new StructWithAnyArray();
        yOrig.setName("Name2");
        yOrig.setAddress("Some Other Address");
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement x = factory.createElement("hello", "foo", "http://some.url.com");
        x.addTextNode("This is the text of the node");
        SOAPElement x2 = factory.createElement("hello2", "foo", "http://some.url.com");
        x2.addTextNode("This is the text of the node for the second struct");
        swa.getAny().add(x);
        yOrig.getAny().add(x2);
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        try {
            if (testDocLiteral) {
                docClient.testStructWithAnyArray(swa, y, z);
            } else if (testXMLBinding) {
                xmlClient.testStructWithAnyArray(swa, y, z);
            } else {
                rpcClient.testStructWithAnyArray(swa, y, z);
            }
        }
        catch (Exception ex) {
            AbstractTypeTestClient3.fail((String)"testStructWithInvalidAnyArray(): caught expected exception - woot.");
        }
    }

    @Test
    @Ignore
    public void testStructWithAnyStrict() throws Exception {
        if (!this.shouldRunTest("StructWithAnyStrict")) {
            return;
        }
    }

    @Test
    @Ignore
    public void testStructWithAnyArrayLax() throws Exception {
        if (!this.shouldRunTest("StructWithAnyArrayLax")) {
            return;
        }
    }

    protected boolean equalsIDTypeAttribute(IDTypeAttribute x, IDTypeAttribute y) {
        return this.equalsNilable(x.getId(), y.getId());
    }

    @Test
    public void testIDTypeAttribute() throws Exception {
        if (!this.shouldRunTest("IDTypeAttribute")) {
            return;
        }
        IDTypeAttribute x = new IDTypeAttribute();
        x.setId("x123");
        IDTypeAttribute yOrig = new IDTypeAttribute();
        yOrig.setId("x456");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        if (testDocLiteral) {
            docClient.testIDTypeAttribute(x, y, z);
        } else if (testXMLBinding) {
            xmlClient.testIDTypeAttribute(x, y, z);
        } else {
            rpcClient.testIDTypeAttribute(x, y, z);
        }
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testIDTypeAttribute(): Incorrect value for inout param", (boolean)this.equalsIDTypeAttribute(x, (IDTypeAttribute)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testIDTypeAttribute(): Incorrect value for out param", (boolean)this.equalsIDTypeAttribute(yOrig, (IDTypeAttribute)z.value));
        }
    }

    protected boolean equals(MultipleOccursSequenceInSequence x, MultipleOccursSequenceInSequence y) {
        int size = x.getValue().size();
        if (size != y.getValue().size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (((BigInteger)x.getValue().get(i)).compareTo((BigInteger)y.getValue().get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testMultipleOccursSequenceInSequence() throws Exception {
        if (!this.shouldRunTest("MultipleOccursSequenceInSequence")) {
            return;
        }
        MultipleOccursSequenceInSequence x = new MultipleOccursSequenceInSequence();
        x.getValue().add(new BigInteger("32"));
        MultipleOccursSequenceInSequence yOriginal = new MultipleOccursSequenceInSequence();
        yOriginal.getValue().add(new BigInteger("3200"));
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        MultipleOccursSequenceInSequence ret = testDocLiteral ? docClient.testMultipleOccursSequenceInSequence(x, y, z) : (testXMLBinding ? xmlClient.testMultipleOccursSequenceInSequence(x, y, z) : rpcClient.testMultipleOccursSequenceInSequence(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testMultipleOccursSequenceInSequence(): Incorrect value for inout param", (boolean)this.equals(x, (MultipleOccursSequenceInSequence)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testMultipleOccursSequenceInSequence(): Incorrect value for out param", (boolean)this.equals(yOriginal, (MultipleOccursSequenceInSequence)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testMultipleOccursSequenceInSequence(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(StructWithBinary x, StructWithBinary y) {
        return Arrays.equals(x.getBase64(), y.getBase64()) && Arrays.equals(x.getHex(), y.getHex());
    }

    @Test
    public void testStructWithBinary() throws Exception {
        if (!this.shouldRunTest("StructWithBinary")) {
            return;
        }
        StructWithBinary x = new StructWithBinary();
        x.setBase64("base64Binary_x".getBytes());
        x.setHex("hexBinary_x".getBytes());
        StructWithBinary yOriginal = new StructWithBinary();
        yOriginal.setBase64("base64Binary_y".getBytes());
        yOriginal.setHex("hexBinary_y".getBytes());
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        StructWithBinary ret = testDocLiteral ? docClient.testStructWithBinary(x, y, z) : (testXMLBinding ? xmlClient.testStructWithBinary(x, y, z) : rpcClient.testStructWithBinary(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testStructWithBinary(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithBinary)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testStructWithBinary(): Incorrect value for out param", (boolean)this.equals(yOriginal, (StructWithBinary)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testStructWithBinary(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceWithBinary x, ChoiceWithBinary y) {
        if (x.getBase64() != null && y.getBase64() != null) {
            return Arrays.equals(x.getBase64(), y.getBase64());
        }
        return x.getHex() != null && y.getHex() != null && Arrays.equals(x.getHex(), y.getHex());
    }

    @Test
    public void testChoiceWithBinary() throws Exception {
        if (!this.shouldRunTest("ChoiceWithBinary")) {
            return;
        }
        ChoiceWithBinary x = new ChoiceWithBinary();
        x.setBase64("base64Binary_x".getBytes());
        ChoiceWithBinary yOriginal = new ChoiceWithBinary();
        yOriginal.setHex("hexBinary_y".getBytes());
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        ChoiceWithBinary ret = testDocLiteral ? docClient.testChoiceWithBinary(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithBinary(x, y, z) : rpcClient.testChoiceWithBinary(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithBinary(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithBinary)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithBinary(): Incorrect value for out param", (boolean)this.equals(yOriginal, (ChoiceWithBinary)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithBinary(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceWithGroupChoice x, ChoiceWithGroupChoice y) {
        if (x.getVarFloat() != null && y.getVarFloat() != null) {
            return x.getVarFloat().compareTo(y.getVarFloat()) == 0;
        }
        if (x.getVarInt() != null && y.getVarInt() != null) {
            return x.getVarInt().compareTo(y.getVarInt()) == 0;
        }
        if (x.getVarString() != null && y.getVarString() != null) {
            return x.getVarString().equals(y.getVarString());
        }
        if (x.getVarOtherFloat() != null && y.getVarOtherFloat() != null) {
            return x.getVarOtherFloat().compareTo(y.getVarOtherFloat()) == 0;
        }
        if (x.getVarOtherInt() != null && y.getVarOtherInt() != null) {
            return x.getVarOtherInt().compareTo(y.getVarOtherInt()) == 0;
        }
        if (x.getVarOtherString() != null && y.getVarOtherString() != null) {
            return x.getVarOtherString().equals(y.getVarOtherString());
        }
        return false;
    }

    @Test
    public void testChoiceWithGroupChoice() throws Exception {
        if (!this.shouldRunTest("ChoiceWithGroupChoice")) {
            return;
        }
        ChoiceWithGroupChoice x = new ChoiceWithGroupChoice();
        x.setVarFloat(Float.valueOf(1.1f));
        ChoiceWithGroupChoice yOrig = new ChoiceWithGroupChoice();
        yOrig.setVarOtherString("world");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceWithGroupChoice ret = testDocLiteral ? docClient.testChoiceWithGroupChoice(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithGroupChoice(x, y, z) : rpcClient.testChoiceWithGroupChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroupChoice(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithGroupChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroupChoice(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceWithGroupChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroupChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceWithGroupSeq x, ChoiceWithGroupSeq y) {
        if (x.getVarInt() != null && x.getVarFloat() != null && x.getVarString() != null) {
            if (x.getVarInt().compareTo(y.getVarInt()) != 0) {
                return false;
            }
            if (x.getVarFloat().compareTo(y.getVarFloat()) != 0) {
                return false;
            }
            return x.getVarString().equals(y.getVarString());
        }
        if (x.getVarOtherInt() != null && x.getVarOtherFloat() != null && x.getVarOtherString() != null) {
            if (x.getVarOtherInt().compareTo(y.getVarOtherInt()) != 0) {
                return false;
            }
            if (x.getVarOtherFloat().compareTo(y.getVarOtherFloat()) != 0) {
                return false;
            }
            return x.getVarOtherString().equals(y.getVarOtherString());
        }
        return false;
    }

    @Test
    public void testChoiceWithGroupSeq() throws Exception {
        if (!this.shouldRunTest("ChoiceWithGroupSeq")) {
            return;
        }
        ChoiceWithGroupSeq x = new ChoiceWithGroupSeq();
        x.setVarInt(Integer.valueOf(100));
        x.setVarString("hello");
        x.setVarFloat(Float.valueOf(1.1f));
        ChoiceWithGroupSeq yOrig = new ChoiceWithGroupSeq();
        yOrig.setVarOtherInt(Integer.valueOf(11));
        yOrig.setVarOtherString("world");
        yOrig.setVarOtherFloat(Float.valueOf(10.1f));
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceWithGroupSeq ret = testDocLiteral ? docClient.testChoiceWithGroupSeq(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithGroupSeq(x, y, z) : rpcClient.testChoiceWithGroupSeq(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroupSeq(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithGroupSeq)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroupSeq(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceWithGroupSeq)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroupSeq(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(ChoiceWithGroups x, ChoiceWithGroups y) {
        if (x.getVarInt() != null && x.getVarString() != null && x.getVarFloat() != null) {
            return x.getVarInt().compareTo(y.getVarInt()) == 0 && x.getVarString().equals(y.getVarString()) && x.getVarFloat().compareTo(y.getVarFloat()) == 0;
        }
        if (x.getVarOtherFloat() != null && y.getVarOtherFloat() != null) {
            return x.getVarOtherFloat().compareTo(y.getVarOtherFloat()) == 0;
        }
        if (x.getVarOtherInt() != null && y.getVarOtherInt() != null) {
            return x.getVarOtherInt().compareTo(y.getVarOtherInt()) == 0;
        }
        if (x.getVarOtherString() != null && y.getVarOtherString() != null) {
            return x.getVarOtherString().equals(y.getVarOtherString());
        }
        return false;
    }

    @Test
    public void testChoiceWithGroups() throws Exception {
        if (!this.shouldRunTest("ChoiceWithGroups")) {
            return;
        }
        ChoiceWithGroups x = new ChoiceWithGroups();
        x.setVarInt(Integer.valueOf(100));
        x.setVarString("hello");
        x.setVarFloat(Float.valueOf(1.1f));
        ChoiceWithGroups yOrig = new ChoiceWithGroups();
        yOrig.setVarOtherString("world");
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        ChoiceWithGroups ret = testDocLiteral ? docClient.testChoiceWithGroups(x, y, z) : (testXMLBinding ? xmlClient.testChoiceWithGroups(x, y, z) : rpcClient.testChoiceWithGroups(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroups(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithGroups)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroups(): Incorrect value for out param", (boolean)this.equals(yOrig, (ChoiceWithGroups)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithGroups(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Override
    protected boolean equals(ExtBase64Binary x, ExtBase64Binary y) {
        return x.getId() == y.getId() && Arrays.equals(x.getValue(), y.getValue());
    }

    @Override
    @Test
    public void testExtBase64Binary() throws Exception {
        if (!this.shouldRunTest("ExtBase64Binary")) {
            return;
        }
        ExtBase64Binary x1 = new ExtBase64Binary();
        x1.setValue("base64a".getBytes());
        x1.setId(Integer.valueOf(1));
        ExtBase64Binary y1 = new ExtBase64Binary();
        y1.setValue("base64b".getBytes());
        y1.setId(Integer.valueOf(2));
        Holder y1Holder = new Holder((Object)y1);
        Holder z1 = new Holder();
        ExtBase64Binary ret = testDocLiteral ? docClient.testExtBase64Binary(x1, y1Holder, z1) : (testXMLBinding ? xmlClient.testExtBase64Binary(x1, y1Holder, z1) : rpcClient.testExtBase64Binary(x1, y1Holder, z1));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testExtBase64Binary(): Incorrect value for inout param", (boolean)this.equals(x1, (ExtBase64Binary)y1Holder.value));
            AbstractTypeTestClient3.assertTrue((String)"testExtBase64Binary(): Incorrect value for out param", (boolean)this.equals(y1, (ExtBase64Binary)z1.value));
            AbstractTypeTestClient3.assertTrue((String)"testExtBase64Binary(): Incorrect return value", (boolean)this.equals(x1, ret));
        }
    }

    protected boolean equals(StructWithAnyAttribute x, StructWithAnyAttribute y) {
        if (!x.getVarString().equals(y.getVarString()) || x.getVarInt() != y.getVarInt()) {
            return false;
        }
        if (!this.equalsNilable(x.getAtString(), y.getAtString()) || !this.equalsNilable(x.getAtInt(), y.getAtInt())) {
            return false;
        }
        return this.equalsQNameStringPairs(x.getOtherAttributes(), y.getOtherAttributes());
    }

    protected boolean equalsQNameStringPairs(Map<QName, String> x, Map<QName, String> y) {
        if (x == null && y != null || x != null && y == null) {
            return false;
        }
        if (x.isEmpty() && y.isEmpty()) {
            return true;
        }
        if (x.size() != y.size()) {
            return false;
        }
        for (QName attName : x.keySet()) {
            if (attName == null) {
                return false;
            }
            String attValue = y.get(attName);
            if (attValue != null && attValue.equals(x.get(attName))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testStructWithAnyAttribute() throws Exception {
        if (!this.shouldRunTest("StructWithAnyAttribute")) {
            return;
        }
        QName xAt1Name = new QName("http://schemas.iona.com/type_test", "at_one");
        QName xAt2Name = new QName("http://schemas.iona.com/type_test", "at_two");
        QName yAt3Name = new QName("http://apache.org/type_test", "at_thr");
        QName yAt4Name = new QName("http://apache.org/type_test", "at_fou");
        StructWithAnyAttribute x = new StructWithAnyAttribute();
        StructWithAnyAttribute y = new StructWithAnyAttribute();
        x.setVarString("hello");
        x.setVarInt(1000);
        x.setAtString("hello attribute");
        x.setAtInt(new Integer(2000));
        y.setVarString("there");
        y.setVarInt(1001);
        y.setAtString("there attribute");
        y.setAtInt(new Integer(2002));
        Map xAttrMap = x.getOtherAttributes();
        xAttrMap.put(xAt1Name, "one");
        xAttrMap.put(xAt2Name, "two");
        Map yAttrMap = y.getOtherAttributes();
        yAttrMap.put(yAt3Name, "three");
        yAttrMap.put(yAt4Name, "four");
        Holder yh = new Holder((Object)y);
        Holder zh = new Holder();
        StructWithAnyAttribute ret = testDocLiteral ? docClient.testStructWithAnyAttribute(x, yh, zh) : (testXMLBinding ? xmlClient.testStructWithAnyAttribute(x, yh, zh) : rpcClient.testStructWithAnyAttribute(x, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testStructWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(x, (StructWithAnyAttribute)yh.value));
            AbstractTypeTestClient3.assertTrue((String)"testStructWithAnyAttribute(): Incorrect value for out param", (boolean)this.equals(y, (StructWithAnyAttribute)zh.value));
            AbstractTypeTestClient3.assertTrue((String)"testStructWithAnyAttribute(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(ChoiceWithAnyAttribute x, ChoiceWithAnyAttribute y) {
        String xString = x.getVarString();
        String yString = y.getVarString();
        Integer xInt = x.getVarInt();
        Integer yInt = y.getVarInt();
        if (xString != null) {
            if (yString == null || !xString.equals(yString)) {
                AbstractTypeTestClient3.fail((String)(xString + " != " + yString));
                return false;
            }
        } else if (xInt != null) {
            if (yInt == null || !xInt.equals(yInt)) {
                AbstractTypeTestClient3.fail((String)(xInt + " != " + yInt));
                return false;
            }
        } else {
            AbstractTypeTestClient3.fail((String)"null choice");
            return false;
        }
        if (!this.equalsNilable(x.getAtString(), y.getAtString()) || !this.equalsNilable(x.getAtInt(), y.getAtInt())) {
            AbstractTypeTestClient3.fail((String)"grrr");
            return false;
        }
        return this.equalsQNameStringPairs(x.getOtherAttributes(), y.getOtherAttributes());
    }

    @Test
    public void testChoiceWithAnyAttribute() throws Exception {
        if (!this.shouldRunTest("ChoiceWithAnyAttribute")) {
            return;
        }
        QName xAt1Name = new QName("http://schemas.iona.com/type_test", "at_one");
        QName xAt2Name = new QName("http://schemas.iona.com/type_test", "at_two");
        QName yAt3Name = new QName("http://apache.org/type_test", "at_thr");
        QName yAt4Name = new QName("http://apache.org/type_test", "at_fou");
        ChoiceWithAnyAttribute x = new ChoiceWithAnyAttribute();
        ChoiceWithAnyAttribute y = new ChoiceWithAnyAttribute();
        x.setVarString("hello");
        x.setAtString("hello attribute");
        x.setAtInt(new Integer(2000));
        y.setVarInt(Integer.valueOf(1001));
        y.setAtString("there attribute");
        y.setAtInt(new Integer(2002));
        Map xAttrMap = x.getOtherAttributes();
        xAttrMap.put(xAt1Name, "one");
        xAttrMap.put(xAt2Name, "two");
        Map yAttrMap = y.getOtherAttributes();
        yAttrMap.put(yAt3Name, "three");
        yAttrMap.put(yAt4Name, "four");
        Holder yh = new Holder((Object)y);
        Holder zh = new Holder();
        ChoiceWithAnyAttribute ret = testDocLiteral ? docClient.testChoiceWithAnyAttribute(x, yh, zh) : (testXMLBinding ? xmlClient.testChoiceWithAnyAttribute(x, yh, zh) : rpcClient.testChoiceWithAnyAttribute(x, yh, zh));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithAnyAttribute(): Incorrect value for inout param", (boolean)this.equals(x, (ChoiceWithAnyAttribute)yh.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithAnyAttribute(): Incorrect value for out param", (boolean)this.equals(y, (ChoiceWithAnyAttribute)zh.value));
            AbstractTypeTestClient3.assertTrue((String)"testChoiceWithAnyAttribute(): Incorrect return value", (boolean)this.equals(ret, x));
        }
    }

    protected boolean equals(OccuringStruct x, OccuringStruct y) {
        if (!this.equalsNilable(x.getVarAttrib(), y.getVarAttrib())) {
            return false;
        }
        return this.equalsFloatIntStringList(x.getVarFloatAndVarIntAndVarString(), y.getVarFloatAndVarIntAndVarString());
    }

    protected boolean equalsFloatIntStringList(List<Serializable> xList, List<Serializable> yList) {
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (xList.get(i) instanceof Float && yList.get(i) instanceof Float) {
                Float fy;
                Float fx = (Float)xList.get(i);
                if (fx.compareTo(fy = (Float)yList.get(i)) == 0) continue;
                return false;
            }
            if (xList.get(i) instanceof Integer && yList.get(i) instanceof Integer) {
                Integer ix = (Integer)xList.get(i);
                Integer iy = (Integer)yList.get(i);
                if (iy.compareTo(ix) == 0) continue;
                return false;
            }
            if (xList.get(i) instanceof String && yList.get(i) instanceof String) {
                String sy;
                String sx = (String)((Object)xList.get(i));
                if (sx.equals(sy = (String)((Object)yList.get(i)))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Test
    public void testOccuringStruct() throws Exception {
        if (!this.shouldRunTest("OccuringStruct")) {
            return;
        }
        OccuringStruct x = new OccuringStruct();
        List theList = x.getVarFloatAndVarIntAndVarString();
        theList.add(Float.valueOf(1.14f));
        theList.add(new Integer(0));
        theList.add("x1");
        theList.add(Float.valueOf(11.14f));
        theList.add(new Integer(1));
        theList.add("x2");
        x.setVarAttrib("x_attr");
        OccuringStruct yOriginal = new OccuringStruct();
        theList = yOriginal.getVarFloatAndVarIntAndVarString();
        theList.add(Float.valueOf(3.14f));
        theList.add(new Integer(42));
        theList.add("y");
        yOriginal.setVarAttrib("y_attr");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        OccuringStruct ret = testDocLiteral ? docClient.testOccuringStruct(x, y, z) : (testXMLBinding ? xmlClient.testOccuringStruct(x, y, z) : rpcClient.testOccuringStruct(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringStruct)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringStruct)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(OccuringStruct1 x, OccuringStruct1 y) {
        return this.equalsFloatIntStringList(x.getVarFloatAndVarIntAndVarString(), y.getVarFloatAndVarIntAndVarString());
    }

    @Test
    public void testOccuringStruct1() throws Exception {
        if (!this.shouldRunTest("OccuringStruct1")) {
            return;
        }
        OccuringStruct1 x = new OccuringStruct1();
        List theList = x.getVarFloatAndVarIntAndVarString();
        theList.add(Float.valueOf(1.1f));
        theList.add(2);
        theList.add("xX");
        OccuringStruct1 yOriginal = new OccuringStruct1();
        theList = yOriginal.getVarFloatAndVarIntAndVarString();
        theList.add(Float.valueOf(11.11f));
        theList.add(22);
        theList.add("yY");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        OccuringStruct1 ret = testDocLiteral ? docClient.testOccuringStruct1(x, y, z) : (testXMLBinding ? xmlClient.testOccuringStruct1(x, y, z) : rpcClient.testOccuringStruct1(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct1(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringStruct1)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct1(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringStruct1)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct1(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(OccuringStruct2 x, OccuringStruct2 y) {
        if (Float.compare(x.getVarFloat(), y.getVarFloat()) != 0) {
            return false;
        }
        List xList = x.getVarIntAndVarString();
        List yList = y.getVarIntAndVarString();
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (xList.get(i) instanceof Integer && yList.get(i) instanceof Integer) {
                Integer ix = (Integer)xList.get(i);
                Integer iy = (Integer)yList.get(i);
                if (iy.compareTo(ix) == 0) continue;
                return false;
            }
            if (xList.get(i) instanceof String && yList.get(i) instanceof String) {
                String sy;
                String sx = (String)xList.get(i);
                if (sx.equals(sy = (String)yList.get(i))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Test
    public void testOccuringStruct2() throws Exception {
        if (!this.shouldRunTest("OccuringStruct2")) {
            return;
        }
        OccuringStruct2 x = new OccuringStruct2();
        x.setVarFloat(1.14f);
        List theList = x.getVarIntAndVarString();
        theList.add(0);
        theList.add("x1");
        theList.add(1);
        theList.add("x2");
        OccuringStruct2 yOriginal = new OccuringStruct2();
        yOriginal.setVarFloat(3.14f);
        theList = yOriginal.getVarIntAndVarString();
        theList.add(42);
        theList.add("the answer");
        theList.add(6);
        theList.add("hammer");
        theList.add(2);
        theList.add("anvil");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        OccuringStruct2 ret = testDocLiteral ? docClient.testOccuringStruct2(x, y, z) : (testXMLBinding ? xmlClient.testOccuringStruct2(x, y, z) : rpcClient.testOccuringStruct2(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct2(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringStruct2)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct2(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringStruct2)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringStruct2(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(OccuringChoice x, OccuringChoice y) {
        if (!this.equalsNilable(x.getVarAttrib(), y.getVarAttrib())) {
            return false;
        }
        return this.equalsFloatIntStringList(x.getVarFloatOrVarIntOrVarString(), y.getVarFloatOrVarIntOrVarString());
    }

    @Test
    public void testOccuringChoice() throws Exception {
        if (!this.shouldRunTest("OccuringChoice")) {
            return;
        }
        OccuringChoice x = new OccuringChoice();
        List theList = x.getVarFloatOrVarIntOrVarString();
        theList.add(0);
        theList.add(Float.valueOf(1.14f));
        theList.add("x1");
        theList.add(1);
        theList.add(Float.valueOf(11.14f));
        x.setVarAttrib("x_attr");
        OccuringChoice yOriginal = new OccuringChoice();
        theList = yOriginal.getVarFloatOrVarIntOrVarString();
        theList.add(Float.valueOf(3.14f));
        theList.add("y");
        theList.add(42);
        yOriginal.setVarAttrib("y_attr");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        OccuringChoice ret = testDocLiteral ? docClient.testOccuringChoice(x, y, z) : (testXMLBinding ? xmlClient.testOccuringChoice(x, y, z) : rpcClient.testOccuringChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        theList.add(52);
        theList.add(Float.valueOf(4.14f));
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testOccuringChoice(x, y, z) : (testXMLBinding ? xmlClient.testOccuringChoice(x, y, z) : rpcClient.testOccuringChoice(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringChoice)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringChoice)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(OccuringChoice1 x, OccuringChoice1 y) {
        List xList = x.getVarFloatOrVarInt();
        List yList = y.getVarFloatOrVarInt();
        int size = xList.size();
        if (size != yList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Float yf;
            Float xf;
            Integer yi;
            Integer xi;
            if (xList.get(i) instanceof Integer && yList.get(i) instanceof Integer && (xi = (Integer)xList.get(i)).compareTo(yi = (Integer)yList.get(i)) != 0) {
                return false;
            }
            if (!(xList.get(i) instanceof Float) || !(yList.get(i) instanceof Float) || (xf = (Float)xList.get(i)).compareTo(yf = (Float)yList.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testOccuringChoice1() throws Exception {
        if (!this.shouldRunTest("OccuringChoice1")) {
            return;
        }
        OccuringChoice1 x = new OccuringChoice1();
        List theList = x.getVarFloatOrVarInt();
        theList.add(0);
        theList.add(new Float(1.14f));
        theList.add(1);
        theList.add(new Float(11.14f));
        OccuringChoice1 yOriginal = new OccuringChoice1();
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        OccuringChoice1 ret = testDocLiteral ? docClient.testOccuringChoice1(x, y, z) : (testXMLBinding ? xmlClient.testOccuringChoice1(x, y, z) : rpcClient.testOccuringChoice1(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice1(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringChoice1)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice1(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringChoice1)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice1(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    protected boolean equals(OccuringChoice2 x, OccuringChoice2 y) {
        if (x.getVarString() != null && !x.getVarString().equals(y.getVarString())) {
            return false;
        }
        return x.getVarInt() == null || x.getVarInt() == y.getVarInt();
    }

    @Test
    public void testOccuringChoice2() throws Exception {
        if (!this.shouldRunTest("OccuringChoice2")) {
            return;
        }
        OccuringChoice2 x = new OccuringChoice2();
        x.setVarString("x1");
        OccuringChoice2 yOriginal = new OccuringChoice2();
        yOriginal.setVarString("y1");
        Holder y = new Holder((Object)yOriginal);
        Holder z = new Holder();
        OccuringChoice2 ret = testDocLiteral ? docClient.testOccuringChoice2(x, y, z) : (testXMLBinding ? xmlClient.testOccuringChoice2(x, y, z) : rpcClient.testOccuringChoice2(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice2(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringChoice2)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice2(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringChoice2)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice2(): Incorrect return value", (boolean)this.equals(x, ret));
        }
        x = new OccuringChoice2();
        yOriginal = new OccuringChoice2();
        yOriginal.setVarString("y1");
        y = new Holder((Object)yOriginal);
        z = new Holder();
        ret = testDocLiteral ? docClient.testOccuringChoice2(x, y, z) : (testXMLBinding ? xmlClient.testOccuringChoice2(x, y, z) : rpcClient.testOccuringChoice2(x, y, z));
        if (!this.perfTestOnly) {
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice2(): Incorrect value for inout param", (boolean)this.equals(x, (OccuringChoice2)y.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice2(): Incorrect value for out param", (boolean)this.equals(yOriginal, (OccuringChoice2)z.value));
            AbstractTypeTestClient3.assertTrue((String)"testOccuringChoice2(): Incorrect return value", (boolean)this.equals(x, ret));
        }
    }

    @Test
    public void testAnonEnumList() throws Exception {
        if (!this.shouldRunTest("AnonEnumList")) {
            return;
        }
        if (testDocLiteral || testXMLBinding) {
            List ret;
            List<Short> x = Arrays.asList((short)10, (short)100);
            List<Short> yOrig = Arrays.asList((short)1000, (short)10);
            Holder y = new Holder(yOrig);
            Holder z = new Holder();
            List list = ret = testDocLiteral ? docClient.testAnonEnumList(x, y, z) : xmlClient.testAnonEnumList(x, y, z);
            if (!this.perfTestOnly) {
                AbstractTypeTestClient3.assertTrue((String)"testAnonEnumList(): Incorrect value for inout param", (boolean)((Object)x).equals(y.value));
                AbstractTypeTestClient3.assertTrue((String)"testAnonEnumList(): Incorrect value for out param", (boolean)((Object)yOrig).equals(z.value));
                AbstractTypeTestClient3.assertTrue((String)"testAnonEnumList(): Incorrect return value", (boolean)((Object)x).equals(ret));
            }
        } else {
            Short[] x = new Short[]{(short)10, (short)100};
            Short[] yOrig = new Short[]{(short)1000, (short)10};
            Holder y = new Holder((Object)yOrig);
            Holder z = new Holder();
            Short[] ret = rpcClient.testAnonEnumList(x, y, z);
            AbstractTypeTestClient3.assertTrue((((Short[])y.value).length == 2 ? 1 : 0) != 0);
            AbstractTypeTestClient3.assertTrue((((Short[])z.value).length == 2 ? 1 : 0) != 0);
            AbstractTypeTestClient3.assertTrue((ret.length == 2 ? 1 : 0) != 0);
            if (!this.perfTestOnly) {
                for (int i = 0; i < 2; ++i) {
                    AbstractTypeTestClient3.assertEquals((String)"testAnonEnumList(): Incorrect value for inout param", (Object)x[i], (Object)((Short[])y.value)[i]);
                    AbstractTypeTestClient3.assertEquals((String)"testAnonEnumList(): Incorrect value for out param", (Object)yOrig[i], (Object)((Short[])z.value)[i]);
                    AbstractTypeTestClient3.assertEquals((String)"testAnonEnumList(): Incorrect return value", (Object)x[i], (Object)ret[i]);
                }
            }
        }
    }

    @Test
    public void testUnionWithAnonEnum() throws Exception {
        if (!this.shouldRunTest("UnionWithAnonEnum")) {
            return;
        }
        String x = "5";
        String yOrig = "n/a";
        Holder y = new Holder((Object)yOrig);
        Holder z = new Holder();
        String ret = testDocLiteral ? docClient.testUnionWithAnonEnum(x, y, z) : (testXMLBinding ? xmlClient.testUnionWithAnonEnum(x, y, z) : rpcClient.testUnionWithAnonEnum(x, y, z));
        AbstractTypeTestClient3.assertEquals((String)"testUnionWithAnonEnum(): Incorrect value for inout param", (Object)x, (Object)y.value);
        AbstractTypeTestClient3.assertEquals((String)"testUnionWithAnonEnum(): Incorrect value for out param", (Object)yOrig, (Object)z.value);
        AbstractTypeTestClient3.assertEquals((String)"testUnionWithAnonEnum(): Incorrect return value", (Object)x, (Object)ret);
    }
}

