/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.versioning;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AbstractEndpointSelectionInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediatorInInterceptor
extends AbstractEndpointSelectionInterceptor {
    public MediatorInInterceptor() {
        super("post-stream");
        this.addBefore(StaxInInterceptor.class.getName());
    }

    protected Endpoint selectEndpoint(Message message, Set<Endpoint> eps) {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is == null) {
            return null;
        }
        CachedOutputStream bos = new CachedOutputStream(4096L);
        try {
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            is.close();
            message.setContent(InputStream.class, (Object)bos.getInputStream());
            String encoding = (String)message.get((Object)Message.ENCODING);
            XMLStreamReader xsr = StaxInInterceptor.getXMLInputFactory((Message)message).createXMLStreamReader(bos.getInputStream(), encoding);
            do {
                xsr.nextTag();
            } while (!"Body".equals(xsr.getName().getLocalPart()));
            xsr.nextTag();
            if (!xsr.isStartElement()) {
                return null;
            }
            String methodName = xsr.getName().getLocalPart();
            for (Endpoint ep : eps) {
                if (!(methodName.indexOf("sayHi") != -1 ? "2".equals(ep.get((Object)"version")) : "1".equals(ep.get((Object)"version")))) continue;
                return ep;
            }
            bos.close();
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        return null;
    }
}

